/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.model3.chrono.DateOnly;
import net.model3.chrono.DateProvider;
import net.model3.chrono.DateTime;
import net.model3.chrono.TimeOnly;

public class DateFormatter {
    private String _dateFormatString;
    private ConcurrentLinkedQueue<SimpleDateFormat> _delegatePool = new ConcurrentLinkedQueue();
    private TimeZone _overrideTimeZone;

    public DateFormatter(String string) {
        this(string, null);
    }

    public DateFormatter(String string, TimeZone timeZone) {
        this._dateFormatString = string;
        this._overrideTimeZone = timeZone;
    }

    protected TimeZone getDefaultTimeZone() {
        if (this._overrideTimeZone == null) {
            return TimeZone.getDefault();
        }
        return this._overrideTimeZone;
    }

    protected TimeZone getTimeZone(DateProvider dateProvider) {
        if (this._overrideTimeZone != null) {
            return this._overrideTimeZone;
        }
        if (dateProvider != null && dateProvider instanceof DateTime) {
            return ((DateTime)dateProvider).getTimeZone();
        }
        return this.getDefaultTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTime parse(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = this.checkout();
            simpleDateFormat.setTimeZone(this.getDefaultTimeZone());
            Date date = simpleDateFormat.parse(string);
            DateTime dateTime = new DateTime(date.getTime(), this.getDefaultTimeZone());
            return dateTime;
        }
        finally {
            this.checkin(simpleDateFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateOnly parseDateOnly(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = this.checkout();
            simpleDateFormat.setTimeZone(this.getDefaultTimeZone());
            Date date = simpleDateFormat.parse(string);
            DateOnly dateOnly = new DateOnly(date.getTime());
            return dateOnly;
        }
        finally {
            this.checkin(simpleDateFormat);
        }
    }

    public String format(Date date) {
        return this.format(date, this.getDefaultTimeZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String format(Date date, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = this.checkout();
            simpleDateFormat.setTimeZone(timeZone);
            String string = simpleDateFormat.format(date);
            return string;
        }
        finally {
            this.checkin(simpleDateFormat);
        }
    }

    public String format(DateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return this.format(dateTime.asDate(), this.getTimeZone(dateTime));
    }

    public String format(DateOnly dateOnly) {
        if (dateOnly == null) {
            return "";
        }
        return this.format(dateOnly.asDate(), this.getTimeZone(dateOnly));
    }

    public String format(TimeOnly timeOnly) {
        if (timeOnly == null) {
            return "";
        }
        return this.format(timeOnly.asDate(), this.getDefaultTimeZone());
    }

    protected SimpleDateFormat checkout() {
        SimpleDateFormat simpleDateFormat = this._delegatePool.poll();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(this._dateFormatString);
        }
        return simpleDateFormat;
    }

    protected void checkin(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this._delegatePool.add(simpleDateFormat);
        }
    }
}

