/*
 * Decompiled with CFR 0.152.
 */
package net.model3.chrono;

import java.util.TimeZone;
import net.model3.chrono.DateProvider;
import net.model3.chrono.DateTime;
import net.model3.lang.TimeDuration;

public class ChronoHelper {
    public static final ChronoHelper Instance = new ChronoHelper();
    private TimeDuration _oneDay = new TimeDuration("1 day");

    private ChronoHelper() {
    }

    public boolean isToday(DateProvider dateProvider) {
        return this.isSameDay(dateProvider, this.getStartOfToday(this.getTimeZone(dateProvider)));
    }

    TimeZone getTimeZone(DateProvider dateProvider) {
        if (dateProvider instanceof DateTime) {
            return ((DateTime)dateProvider).getTimeZone();
        }
        return TimeZone.getDefault();
    }

    public boolean isTomorrow(DateProvider dateProvider) {
        return this.isSameDay(dateProvider, this.getStartOfTomorrow(this.getTimeZone(dateProvider)));
    }

    public boolean isTodayOld(DateProvider dateProvider) {
        long l = dateProvider.inMillis();
        DateTime dateTime = this.getStartOfToday(this.getTimeZone(dateProvider));
        DateTime dateTime2 = dateTime.addDays(1);
        long l2 = dateTime.inMillis();
        long l3 = dateTime2.inMillis();
        return l2 <= l && l3 > l;
    }

    public boolean isTomorrowOld(DateProvider dateProvider) {
        long l = dateProvider.inMillis();
        DateTime dateTime = this.getStartOfToday(this.getTimeZone(dateProvider));
        DateTime dateTime2 = dateTime.addDays(1);
        long l2 = dateTime2.inMillis();
        long l3 = dateTime2.inMillis();
        return l2 <= l && l3 > l;
    }

    public boolean isSameDay(DateProvider dateProvider, DateProvider dateProvider2) {
        if (this.getTimeZone(dateProvider2).equals(this.getTimeZone(dateProvider))) {
            return dateProvider.getYear() == dateProvider2.getYear() && dateProvider.getMonth() == dateProvider2.getMonth() && dateProvider.getDay() == dateProvider2.getDay();
        }
        return this.isSameDay(dateProvider, new DateTime(dateProvider2.inMillis(), this.getTimeZone(dateProvider)));
    }

    public DateTime getStartOfToday(TimeZone timeZone) {
        DateTime dateTime = new DateTime(System.currentTimeMillis(), timeZone);
        return new DateTime(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, timeZone);
    }

    public DateTime getStartOfTomorrow(TimeZone timeZone) {
        DateTime dateTime = new DateTime(System.currentTimeMillis() + this._oneDay.inMilliseconds(), timeZone);
        return new DateTime(dateTime.getYear(), dateTime.getMonth(), dateTime.getDay(), 0, 0, 0, timeZone);
    }
}

