/*
 * Decompiled with CFR 0.152.
 */
package net.model3.bean.getset;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.model3.bean.AbstractProperty;
import net.model3.bean.AnnotationProvider;
import net.model3.bean.ClassHelper;
import net.model3.bean.Getter;
import net.model3.bean.ReflectionToolException;
import net.model3.bean.Setter;
import net.model3.collections.CollectionX;
import net.model3.collections.ListX;
import net.model3.lang.ModifierX;

public class GetSetProperty<TBean, TValue>
extends AbstractProperty<TBean, TValue>
implements AnnotationProvider {
    Field _field;
    private Method _getterMethod;
    private List<Method> _setterMethods = ListX.create();

    GetSetProperty(ClassHelper classHelper) {
        this.setParentClass(classHelper);
    }

    public void setGetterMethod(Method method) {
        this._getterMethod = method;
        if (this.type() == null) {
            this.setType(method.getReturnType());
        }
        this.setGetter(new Getter<TBean, TValue>(){

            @Override
            public TValue get(TBean TBean) {
                try {
                    if (!GetSetProperty.this._getterMethod.isAccessible()) {
                        GetSetProperty.this._getterMethod.setAccessible(true);
                    }
                    return GetSetProperty.this._getterMethod.invoke(TBean, new Object[0]);
                }
                catch (Exception exception) {
                    throw new ReflectionToolException("error getting property " + this + " of " + TBean);
                }
            }
        });
    }

    public void addSetterMethod(final Method method) {
        this._setterMethods.add(method);
        this.addSetter(new Setter<TBean, Object>(){

            @Override
            public void set(TBean TBean, Object object) {
                try {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    method.invoke(TBean, object);
                }
                catch (Exception exception) {
                    throw new ReflectionToolException("error getting property " + this + " of " + TBean, exception);
                }
            }

            @Override
            public Class type() {
                return method.getParameterTypes()[0];
            }
        });
    }

    @Override
    public boolean isPublic() {
        boolean bl = this._setterMethods.size() == 0;
        for (Method method : this._setterMethods) {
            if (!ModifierX.PUBLIC.isIn(method)) continue;
            bl = true;
            break;
        }
        return bl && (this._field == null || ModifierX.PUBLIC.isIn(this._field));
    }

    @Override
    public boolean isTransient() {
        if (this._field != null) {
            return ModifierX.TRANSIENT.isIn(this._field);
        }
        return false;
    }

    @Override
    public Annotation[] getAnnotations() {
        List list = ListX.create();
        if (this._field != null) {
            Collections.addAll(list, this._field.getAnnotations());
        }
        if (this._getterMethod != null) {
            Collections.addAll(list, this._getterMethod.getAnnotations());
        }
        for (Method method : this._setterMethods) {
            Collections.addAll(list, method.getAnnotations());
        }
        return CollectionX.toArray(list, Annotation.class);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        T t;
        block3: {
            Method method;
            t = null;
            if (this._field != null) {
                t = this._field.getAnnotation(clazz);
            }
            if (t == null && this._getterMethod != null) {
                t = this._getterMethod.getAnnotation(clazz);
            }
            if (t != null) break block3;
            Iterator<Method> iterator = this._setterMethods.iterator();
            while (iterator.hasNext() && (t = (T)(method = iterator.next()).getAnnotation(clazz)) == null) {
            }
        }
        return t;
    }
}

