/*
 * Decompiled with CFR 0.152.
 */
package net.model3.bean;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.model3.bean.ClassHelper;
import net.model3.bean.ConversionException;
import net.model3.bean.ConverterFactory;
import net.model3.bean.ConverterFactoryImpl;
import net.model3.bean.Getter;
import net.model3.bean.Property;
import net.model3.bean.PropertyHelper;
import net.model3.bean.PropertyNotFoundException;
import net.model3.bean.PropertyProvider;
import net.model3.bean.ReflectionToolException;
import net.model3.bean.converters.Converter;
import net.model3.bean.getset.GetSetPropertyProvider;
import net.model3.collections.CaseInsensitiveMapWrapper;
import net.model3.collections.CaseInsensitiveSetWrapper;
import net.model3.collections.CaseInsensitiveSortedMapWrapper;
import net.model3.collections.ListX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class ReflectionTool {
    private static final Logger logger = LoggerHelper.getLogger();
    private static final Object[] ZERO_ELEMENT_ARRAY = new Object[0];
    private final boolean _publicOnly = false;
    private final boolean _caseSensitive;
    private Map<Class<?>, ClassHelper> _classHelperMap = new HashMap();
    private boolean _autoSetAccessible = true;
    private List<PropertyProvider> _propertyProviders = ListX.create();
    ConverterFactory _converterFactory;

    public ReflectionTool() {
        this(false, null);
    }

    @Inject
    public ReflectionTool(ConverterFactory converterFactory) {
        this(false, converterFactory);
    }

    public ReflectionTool(boolean bl) {
        this(bl, null);
    }

    public ReflectionTool(boolean bl, ConverterFactory converterFactory) {
        if (converterFactory == null) {
            converterFactory = new ConverterFactoryImpl();
        }
        this._converterFactory = converterFactory;
        this._caseSensitive = bl;
        this._propertyProviders.add(new GetSetPropertyProvider());
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("net.java.dev.properties.model3.BeansPropertiesProvider");
            PropertyProvider propertyProvider = (PropertyProvider)clazz.newInstance();
            this._propertyProviders.add(propertyProvider);
        }
        catch (Exception exception) {
            logger.debug((Object)"unable to load/find net.model3.beanprops.BeansPropertiesProvider so no bean properties s proper");
        }
    }

    public Object getBeanProperty(Object object, String string) throws ReflectionToolException {
        return this.getGetter(object, string).get(object);
    }

    public Object getFieldValue(Object object, String string) throws ReflectionToolException {
        try {
            Field field = this.getClassHelper(object).getField(string);
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (Exception exception) {
            throw new ReflectionToolException(exception);
        }
    }

    public Object getStaticProperty(Class<?> clazz, String string) throws ReflectionToolException {
        Property property = this.getClassHelper(clazz).getProperty(string);
        return property.getter().get(null);
    }

    public String getBeanPropertyAsString(Object object, String string) throws ReflectionToolException {
        Property<Object, Object> property = this.getProperty(object, string);
        Object object2 = property.getter().get(object);
        if (object2 == null) {
            return null;
        }
        Class<Object> clazz = property.type();
        if (clazz.isArray()) {
            throw new RuntimeException("arrays are not yet supported");
        }
        Converter<Object> converter = this._converterFactory.getConverter(clazz, true);
        String string2 = converter.valueToString(object2);
        return string2;
    }

    public Property<Object, Object> getProperty(Object object, String string) {
        return this.getClassHelper(object).getProperty(string);
    }

    public Property<Object, Object> getProperty(Object object, String string, boolean bl) {
        return this.getClassHelper(object).getProperty(string, bl);
    }

    public void setBeanProperty(Object object, String string, Object object2) throws ReflectionToolException {
        this.getProperty(object, string).setter().set(object, object2);
    }

    public void setBeanProperty(Object object, String string, String string2) throws ReflectionToolException {
        Property<Object, Object> property = this.getProperty(object, string);
        PropertyHelper.setPropertyFromString(this, property, object, string2);
    }

    public Object convertStringToValue(String string, Converter converter, Class clazz, Object object, String string2) {
        try {
            Object t = converter.stringToValue(clazz, string);
            return t;
        }
        catch (Exception exception) {
            String string3 = "unable to convert \"" + string + "\" to a " + clazz.getName() + " for " + object.getClass().getName() + "." + string2;
            throw new ConversionException(string3, exception);
        }
    }

    public void setBeanProperty(Object object, String string, String[] stringArray) throws ReflectionToolException {
        Property<Object, Object> property = this.getProperty(object, string);
        PropertyHelper.setPropertyFromStringArray(this, property, object, stringArray);
    }

    public ClassHelper getClassHelper(Object object) {
        return this.getClassHelper(object.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassHelper getClassHelper(Class<?> clazz) {
        ClassHelper classHelper = this._classHelperMap.get(clazz);
        if (classHelper == null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                classHelper = this._classHelperMap.get(clazz);
                if (classHelper == null) {
                    classHelper = new ClassHelper(this, clazz);
                    this._classHelperMap.put(clazz, classHelper);
                }
            }
        }
        return classHelper;
    }

    boolean isPublicOnly() {
        return false;
    }

    public boolean hasBeanGetter(Object object, String string) {
        return this.getGetter(object, string) != null;
    }

    public Getter getGetter(Object object, String string) {
        Property property = this.getClassHelper(object).getProperty(string, true);
        Getter getter = this.getClassHelper(object).getProperty(string, true).getter();
        if (getter == null) {
            throw new PropertyNotFoundException(property + " does not have a getter (i.e. it is a write only property)");
        }
        return getter;
    }

    public boolean hasBeanSetter(Object object, String string) {
        Property property = this.getClassHelper(object).getProperty(string, false);
        return property != null && property.setter() != null;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    <V> Map<String, V> createMap() {
        if (!this.isCaseSensitive()) {
            return new CaseInsensitiveMapWrapper(new LinkedHashMap());
        }
        return new LinkedHashMap();
    }

    <V> SortedMap<String, V> createSortedMap() {
        if (this.isCaseSensitive()) {
            return new TreeMap();
        }
        return new CaseInsensitiveSortedMapWrapper(new TreeMap());
    }

    Set<String> createSet() {
        if (this.isCaseSensitive()) {
            return new HashSet<String>();
        }
        return new CaseInsensitiveSetWrapper(new HashSet());
    }

    public boolean getAutoSetAccessible() {
        return this._autoSetAccessible;
    }

    public void setAutoSetAccessible(boolean bl) {
        this._autoSetAccessible = bl;
    }

    public String valueToString(Object object) {
        return this._converterFactory.getConverter(object.getClass()).valueToString(object);
    }

    public List<PropertyProvider> getPropertyProviders() {
        return this._propertyProviders;
    }

    public ConverterFactory getConverterFactory() {
        return this._converterFactory;
    }
}

