/*
 * Decompiled with CFR 0.152.
 */
package net.model3.bean;

import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import net.model3.bean.ConverterFactory;
import net.model3.bean.converters.BigDecimalConverter;
import net.model3.bean.converters.BigIntegerConverter;
import net.model3.bean.converters.BooleanConverter;
import net.model3.bean.converters.ByteArrayConverter;
import net.model3.bean.converters.ByteConverter;
import net.model3.bean.converters.ByteSizeConverter;
import net.model3.bean.converters.Converter;
import net.model3.bean.converters.DateConverter;
import net.model3.bean.converters.DirectoryConverter;
import net.model3.bean.converters.DoubleConverter;
import net.model3.bean.converters.EnumConverter;
import net.model3.bean.converters.FloatConverter;
import net.model3.bean.converters.IntegerConverter;
import net.model3.bean.converters.LongConverter;
import net.model3.bean.converters.MoneyConverter;
import net.model3.bean.converters.NewFileConverter;
import net.model3.bean.converters.ShortConverter;
import net.model3.bean.converters.StringConverter;
import net.model3.bean.converters.TimeDurationConverter;
import net.model3.bean.converters.TimestampConverter;
import net.model3.bean.converters.UUIDConverter;
import net.model3.bean.converters.UploadedFileConverter;
import net.model3.collections.ListX;
import net.model3.collections.MapX;
import net.model3.logging.Logger;
import net.model3.logging.LoggerHelper;

@Singleton
public class ConverterFactoryImpl
implements ConverterFactory {
    private static final Logger logger = LoggerHelper.getLogger();
    private List<Converter> _converterList = ListX.create();
    private Map<Class<?>, Converter> _resolvedConverters = MapX.create();

    public ConverterFactoryImpl() {
        this.initializeDefaultConverters();
    }

    public ConverterFactoryImpl(boolean bl) {
        if (bl) {
            this.initializeDefaultConverters();
        }
    }

    @Override
    public List<Converter> getConverters() {
        return this._converterList;
    }

    protected void initializeDefaultConverters() {
        this.addConverter(new StringConverter());
        this.addConverter(new BooleanConverter());
        this.addConverter(new ByteConverter());
        this.addConverter(new ShortConverter());
        this.addConverter(new IntegerConverter());
        this.addConverter(new LongConverter());
        this.addConverter(new FloatConverter());
        this.addConverter(new DoubleConverter());
        this.addConverter(new DateConverter());
        this.addConverter(new BigIntegerConverter());
        this.addConverter(new ByteArrayConverter());
        this.addConverter(new BigDecimalConverter());
        this.addConverter(new MoneyConverter());
        this.addConverter(new NewFileConverter());
        this.addConverter(new DirectoryConverter());
        this.addConverter(new TimestampConverter());
        this.addConverter(new TimeDurationConverter());
        this.addConverter(new ByteSizeConverter());
        this.addConverter(new EnumConverter());
        this.addConverter(new UUIDConverter());
        this.addConverter(new UploadedFileConverter());
    }

    @Override
    public void addConverter(Class<? extends Converter> clazz) {
        try {
            this.addConverter(clazz.newInstance());
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.trace((Object)"{} not loaded as a converter because the classes it converts are not found in the classpath", (Object)clazz.getName());
        }
        catch (Exception exception) {
            logger.warn((Object)"unable to load converter {}", (Object)clazz.getName(), (Object)exception);
        }
    }

    @Override
    public void addConverter(Converter converter) {
        this._converterList.add(converter);
        this._resolvedConverters.clear();
    }

    @Override
    public <T> Converter<T> getConverter(Class<?> clazz, boolean bl) {
        if (this._resolvedConverters.containsKey(clazz)) {
            return this._resolvedConverters.get(clazz);
        }
        for (Converter converter : this._converterList) {
            if (!converter.canConvertType(clazz)) continue;
            this._resolvedConverters.put(clazz, converter);
            return converter;
        }
        if (bl) {
            throw new RuntimeException("cannot find converter for " + clazz);
        }
        return null;
    }

    @Override
    public void setConverter(Class<?> clazz, Converter<?> converter) {
        this._resolvedConverters.put(clazz, converter);
    }

    @Override
    public <T> Converter<T> getConverter(Class<?> clazz) {
        return this.getConverter(clazz, false);
    }

    @Override
    public int getConverterPriority(Converter<?> converter) {
        return this._converterList.indexOf(converter);
    }
}

