/*
 * Decompiled with CFR 0.152.
 */
package net.model3.bean;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import net.model3.bean.Getter;
import net.model3.bean.Property;
import net.model3.bean.PropertyNotFoundException;
import net.model3.bean.PropertyProvider;
import net.model3.bean.ReflectionTool;
import net.model3.collections.ArrayX;
import net.model3.collections.CollectionX;
import net.model3.collections.ListX;
import net.model3.lang.ExceptionPropagator;
import net.model3.util.StringJoiner;

public class ClassHelper {
    private static final Method[] ZERO_LENGTH_METHOD_ARRAY = new Method[0];
    private Method[] declaredMethods_;
    private Field[] declaredFields_;
    private Map<String, Property> _properties;
    private List<Property> _propertyList;
    private List<Property> _writableProperties;
    private Map<String, Method[]> methodsByName_;
    private SortedMap<String, Method> methodsBySignature_;
    private List<Method> _allMethods;
    private Map<String, Field> fieldsByName_;
    private List<Field> fields_;
    private final Class<?> clazz_;
    private ClassHelper superClassHelper_;
    private final ReflectionTool beanTool_;
    private String _propertyNames;

    ClassHelper(ReflectionTool reflectionTool, Class<?> clazz) {
        this.beanTool_ = reflectionTool;
        this.clazz_ = clazz;
        if (this.clazz_.getSuperclass() != null) {
            this.superClassHelper_ = this.beanTool_.getClassHelper(this.clazz_.getSuperclass());
        }
        this.initProperties();
    }

    public String getValidPropertyNames() {
        if (this._propertyNames == null) {
            this._propertyNames = new StringJoiner(this.getProperties().keySet(), ", ").toString();
        }
        return this._propertyNames;
    }

    public Property getProperty(String string) {
        return this.getProperty(string, true);
    }

    public Property getProperty(String string, boolean bl) {
        Property property = this.getProperties().get(string);
        if (bl && property == null) {
            throw new PropertyNotFoundException(this.clazz_, string);
        }
        return property;
    }

    Method[] getMethods(String string) {
        Method[] methodArray = this.getMethodsByName().get(string);
        if (methodArray == null) {
            return ZERO_LENGTH_METHOD_ARRAY;
        }
        return methodArray;
    }

    SortedMap<String, Method> getMethodsBySignature() {
        if (this.methodsBySignature_ == null) {
            this.methodsBySignature_ = this.beanTool_.createSortedMap();
            if (this.superClassHelper_ != null) {
                this.methodsBySignature_.putAll(this.superClassHelper_.getMethodsBySignature());
            }
            Method[] methodArray = this.getDeclaredMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (this.beanTool_.getAutoSetAccessible()) {
                    method.setAccessible(true);
                }
                this.methodsBySignature_.put(ClassHelper.getMethodSignature(method), method);
            }
        }
        return this.methodsBySignature_;
    }

    public List<Method> getAllMethods() {
        if (this._allMethods == null) {
            List list = ListX.create();
            list.addAll(this.getMethodsBySignature().values());
            this._allMethods = list;
        }
        return this._allMethods;
    }

    Map<String, Method[]> getMethodsByName() {
        if (this.methodsByName_ == null) {
            this.methodsByName_ = this.beanTool_.createMap();
            ArrayList<Method> arrayList = new ArrayList<Method>();
            String string = "";
            String string2 = "";
            for (String string3 : this.getMethodsBySignature().keySet()) {
                Method method = (Method)this.methodsBySignature_.get(string3);
                string2 = method.getName();
                if (!this.beanTool_.isCaseSensitive()) {
                    string2 = string2.toLowerCase();
                }
                if (!string2.equals(string)) {
                    if (arrayList.size() > 0) {
                        Method[] methodArray = CollectionX.toArray(arrayList, Method.class);
                        this.methodsByName_.put(string, methodArray);
                        arrayList.clear();
                    }
                    string = string2;
                }
                arrayList.add(method);
            }
            if (arrayList.size() > 0) {
                Method[] methodArray = CollectionX.toArray(arrayList, Method.class);
                this.methodsByName_.put(string2, methodArray);
            }
        }
        return this.methodsByName_;
    }

    public static void main(String[] stringArray) {
        Method[] methodArray = ClassHelper.class.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            System.out.println(method);
            System.out.println();
        }
    }

    public static String getMethodSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        stringBuffer.append("(");
        for (int i = 0; i < classArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(classArray[i].getName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static String getPropertyName(Method method) {
        String string = method.getName();
        if (string.startsWith("get") || string.startsWith("set")) {
            return string.substring(3);
        }
        if (string.startsWith("is")) {
            return string.substring(2);
        }
        return string;
    }

    public Field getField(String string) {
        return this.getFieldsByName().get(string);
    }

    public List<Field> getFields() {
        if (this.fields_ == null) {
            this.getFieldsByName();
        }
        return this.fields_;
    }

    public Map<String, Field> getFieldsByName() {
        if (this.fieldsByName_ == null) {
            Map<String, Field> map = this.beanTool_.createMap();
            ArrayList<Field> arrayList = new ArrayList<Field>();
            if (this.superClassHelper_ != null) {
                map.putAll(this.superClassHelper_.getFieldsByName());
                arrayList.addAll(this.superClassHelper_.getFields());
            }
            Field[] fieldArray = this.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                map.put(field.getName(), field);
                arrayList.add(field);
            }
            this.fieldsByName_ = map;
            this.fields_ = arrayList;
        }
        return this.fieldsByName_;
    }

    public String toString() {
        return this.clazz_.toString();
    }

    public Method getMethod(String string, int n) {
        return this.getMethod(string, n, null);
    }

    Method getMethod(String string, int n, Boolean bl) {
        return this.getMethod(string, n, bl, true);
    }

    public Method getMethod(String string, int n, boolean bl) {
        return this.getMethod(string, n, new Boolean(bl), true);
    }

    public Method getMethod(String string, int n, Boolean bl, boolean bl2) {
        Method[] methodArray = this.getMethods(string);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getParameterTypes().length != n || bl != null && bl.booleanValue() != method.getReturnType().getName().equals("void")) continue;
            return method;
        }
        if (bl2) {
            throw new RuntimeException(this.getName() + "." + string + "() with " + n + " not found.");
        }
        return null;
    }

    String getName() {
        return this.clazz_.getName();
    }

    public Method getMethod(String string, Class[] classArray) {
        Method[] methodArray = this.getMethods(string);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!ArrayX.arrayContentsEqual(classArray, method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public Method[] getDeclaredMethods() {
        if (this.declaredMethods_ == null) {
            this.declaredMethods_ = this.clazz_.getDeclaredMethods();
        }
        return this.declaredMethods_;
    }

    public Field[] getDeclaredFields() {
        if (this.declaredFields_ == null) {
            this.declaredFields_ = this.clazz_.getDeclaredFields();
        }
        return this.declaredFields_;
    }

    public Object newInstance() {
        try {
            Constructor<?> constructor = this.clazz_.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionPropagator.wrap(exception);
        }
    }

    public Method getMethod(String string) {
        Method[] methodArray = this.getMethods(string);
        switch (methodArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return methodArray[0];
            }
        }
        throw new RuntimeException("more than 1 method named " + string + " found in " + this.getName());
    }

    public ReflectionTool getReflectionTool() {
        return this.beanTool_;
    }

    protected void initProperties() {
        this._properties = this.getReflectionTool().createMap();
        this._propertyList = ListX.create();
        for (PropertyProvider propertyProvider : this.getReflectionTool().getPropertyProviders()) {
            propertyProvider.processProperties(this.getReflectionTool(), this);
        }
    }

    public void addProperty(Property property) {
        this._properties.put(property.name(), property);
        this._propertyList.add(property);
    }

    public void removeProperty(Property property) {
        this._properties.remove(property.name());
        this._propertyList.remove(property);
    }

    public List<Property> getWritableProperties() {
        if (this._writableProperties == null) {
            List list = ListX.create();
            for (Property property : this.getPropertyList()) {
                if (property.setter() == null) continue;
                list.add(property);
            }
            this._writableProperties = list;
        }
        return this._writableProperties;
    }

    public List<Property> getPropertyList() {
        return this._propertyList;
    }

    public Map<String, Property> getProperties() {
        return this._properties;
    }

    public Class getClazz() {
        return this.clazz_;
    }

    public Getter getGetter(String string) {
        Property property = this.getProperty(string);
        if (property != null) {
            return property.getter();
        }
        return null;
    }
}

