/*
 * Decompiled with CFR 0.152.
 */
package net.model3.bean;

import java.util.Map;
import net.model3.bean.AlternateSetters;
import net.model3.bean.ClassHelper;
import net.model3.bean.Getter;
import net.model3.bean.Property;
import net.model3.bean.ReflectionTool;
import net.model3.bean.Setter;
import net.model3.collections.MapX;
import net.model3.lang.ClassX;

public abstract class AbstractProperty<TBean, TValue>
implements Property<TBean, TValue>,
AlternateSetters<TBean> {
    private ReflectionTool _beanTool;
    private ClassHelper _parentClass;
    private String _name;
    private Class<TValue> _type;
    private Getter<TBean, TValue> _getter;
    private Map<Class<?>, Setter<TBean, ?>> _settersByType = MapX.create();
    private Setter<TBean, TValue> _setter;
    private boolean _setterSet = false;
    private boolean _sealed = false;

    public void addSetter(Setter<TBean, ?> setter) {
        this.checkForSeal();
        this._settersByType.put(setter.type(), setter);
    }

    @Override
    public Class<TValue> type() {
        return this._type;
    }

    public void setType(Class<TValue> clazz) {
        this.checkForSeal();
        this._type = clazz;
    }

    @Override
    public String name() {
        return this._name;
    }

    public void setName(String string) {
        this.checkForSeal();
        this._name = string;
    }

    @Override
    public Getter<TBean, TValue> getter() {
        return this._getter;
    }

    protected void setGetter(Getter<TBean, TValue> getter) {
        this.checkForSeal();
        this._getter = getter;
    }

    @Override
    public Setter<TBean, TValue> setter() {
        if (!this._setterSet && this._setter == null) {
            this._setter = this.getAlternateSetter(this.type());
            this._setterSet = true;
        }
        return this._setter;
    }

    @Override
    public <T> Setter<TBean, T> getAlternateSetter(Class<T> clazz) {
        return this._settersByType.get(clazz);
    }

    public void setBeanTool(ReflectionTool reflectionTool) {
        this.checkForSeal();
        this._beanTool = reflectionTool;
    }

    public void setParentClass(ClassHelper classHelper) {
        this.checkForSeal();
        this._parentClass = classHelper;
    }

    public String toString() {
        if (this._parentClass != null) {
            return ClassX.getShortName(this._parentClass.getClazz()) + "." + this.name();
        }
        return this.name();
    }

    protected void checkForSeal() {
        if (this._sealed) {
            throw new RuntimeException(this + " is already sealed");
        }
    }

    public void seal() {
        if (this._type == null) {
            this._type = this._settersByType.size() == 1 ? this._settersByType.keySet().iterator().next() : null;
        }
        this._sealed = true;
    }
}

