/*
 * Decompiled with CFR 0.152.
 */
package net.model3.app;

import com.google.inject.Inject;
import net.model3.guice.DependencyInjector;
import net.model3.lang.ClassX;
import net.model3.logging.Log;
import net.model3.logging.LogHelper;
import net.model3.logging.LoggingConfigurator;

public class ToolRunner {
    protected Log logger = LogHelper.getLog();
    @Inject
    protected LoggingConfigurator _loggingConfigurator;

    protected void start() {
        int n = 0;
        try {
            this.configureLogging();
            this.logger.info((Object)"starting!!!!");
            this.run();
        }
        catch (Exception exception) {
            this.logger.fatal((Object)exception);
            n = 1;
        }
        this.logger.info((Object)"done!!!!");
        System.exit(n);
    }

    protected void configureLogging() {
        this._loggingConfigurator.setPrefix(this.getAppName());
        this._loggingConfigurator.addConsoleAppender();
    }

    protected void run() throws Exception {
    }

    public String getAppName() {
        return ClassX.getShortName(this.getClass());
    }

    public static void startFromMain() {
        try {
            Class clazz = ClassX.load(new Throwable().getStackTrace()[1].getClassName());
            String string = ClassX.getShortName(clazz);
            System.setProperty("app.name", string);
            ToolRunner toolRunner = (ToolRunner)DependencyInjector.get().getInstance(clazz);
            toolRunner.start();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

