/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.InvalidStateException;
import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.JTwainException;
import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.lowlevel.Capability;
import com.asprise.util.jtwain.lowlevel.DataTypeImageLayout;
import com.asprise.util.jtwain.lowlevel.OperationResult;

public class Control
implements JTwainConstants {
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_SM_NOT_LOADED = 1;
    public static final int STATE_SM_LOADED = 2;
    public static final int STATE_SM_OPEN = 3;
    public static final int STATE_DS_OPEN = 4;
    public static final int STATE_DS_ENABLED = 5;
    public static final int STATE_TRANSFER_READY = 6;
    public static final int STATE_TRANSFERING = 7;
    public static final int STATE_DS_NOT_IN_USE = -2;
    public static final int ACTION_LOAD_SM = 0;
    public static final int ACTION_OPEN_SM = 1;
    public static final int ACTION_SELECT_DS = 2;
    public static final int ACTION_OPEN_DS = 3;
    public static final int ACTION_CLOSE_DS = 5;
    public static final int ACTION_CLOSE_SM = 6;
    public static final int ACTION_UNLOAD_SM = 7;

    public static OperationResult CapabilityMsg(int messageType, Capability capability) {
        switch (messageType) {
            case 1: {
                return Control.CapabilityMsgGet(capability);
            }
            case 2: {
                return Control.CapabilityMsgGetCurrent(capability);
            }
            case 3: {
                return Control.CapabilityMsgGetDefault(capability);
            }
            case 7: {
                return Control.CapabilityMsgReset(capability);
            }
            case 6: {
                return Control.CapabilityMsgSet(capability);
            }
        }
        return null;
    }

    private static native OperationResult CapabilityMsgGet(Capability var0);

    private static native OperationResult CapabilityMsgGetCurrent(Capability var0);

    private static native OperationResult CapabilityMsgGetDefault(Capability var0);

    public static native OperationResult CapabilityMsgReset(Capability var0);

    public static native OperationResult CapabilityMsgSet(Capability var0);

    public static native OperationResult ImageLayoutGet();

    public static native OperationResult ImageLayoutSet(DataTypeImageLayout var0);

    public static native String getLastScannedFile();

    public static void unloadSourceManager() throws JTwainException {
        if (!Control.performAction(7, null)) {
            throw new JTwainException("Failed to unload source manager. ");
        }
    }

    public static void loadSourceManager() throws JTwainException {
        if (!Control.performAction(0, null)) {
            throw new JTwainException("Failed to load source manager. ");
        }
    }

    public static void openSourceManager() throws JTwainException {
        if (!Control.performAction(1, null)) {
            throw new JTwainException("Failed to open source manager.");
        }
    }

    public static void selectDataSource(String sourceName) throws JTwainException {
        if (!Control.performAction(2, sourceName)) {
            throw new JTwainException("Failed to select the specified data source. ");
        }
    }

    public static void openDataSource(Source source) throws JTwainException {
        if (!Control.performAction(3, source)) {
            throw new JTwainException("Failed to open the specified data source: " + source);
        }
    }

    public static void closeSource() throws JTwainException {
        if (!Control.performAction(5, null)) {
            throw new JTwainException("Failed to close the data source.");
        }
    }

    public static void closeSourceManager() {
        try {
            if (!Control.performAction(6, null)) {
                throw new JTwainException("Failed to close the source manager. ");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static native int getState(Source var0);

    public static native Source getCurrentSource();

    public static native String acquireOneImage(Source var0);

    private static native boolean performAction(int var0, Object var1);

    public static native int getConditionCode();

    public static native int getReturnCode();

    public static native int getNumberOfPendingImages();

    public static native boolean skipNextImage();

    public static native boolean abortAllPendingImages();

    public static void loadLibrary() {
        try {
            System.loadLibrary("AspriseJTwain");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void assertState(Source source, int requiredState) throws InvalidStateException {
        int currentState = Control.getState(source);
        if (source != null && currentState == -2 && requiredState != -2) {
            throw new InvalidStateException("Data source [" + source + "] is not active (currently not in use)");
        }
        if (currentState == requiredState) {
            return;
        }
        if (!source.getMinimumExceptionEnabled()) {
            throw new InvalidStateException("Invalid state: State " + Control.getStateRepresentation(requiredState) + " is required, however the current state is State " + Control.getStateRepresentation(currentState));
        }
    }

    public static void assertStateAtLeast(Source source, int requiredStateAtLeast) throws InvalidStateException {
        int currentState = Control.getState(source);
        if (source != null && currentState == -2 && requiredStateAtLeast != -2) {
            throw new InvalidStateException("Data source [" + source + "] is not active (currently not in use)");
        }
        if (currentState >= requiredStateAtLeast) {
            return;
        }
        if (!source.getMinimumExceptionEnabled()) {
            throw new InvalidStateException("Invalid state: State " + Control.getStateRepresentation(requiredStateAtLeast) + " or above is required, however the current state is State " + Control.getStateRepresentation(currentState));
        }
    }

    public static boolean assertStateNoException(Source source, int requiredState) {
        try {
            Control.assertState(source, requiredState);
            return true;
        }
        catch (InvalidStateException e) {
            return false;
        }
    }

    public static String getStateRepresentation(int code) {
        switch (code) {
            case 1: {
                return "<1> Pre-session - Source Manager Unloaded";
            }
            case 2: {
                return "<2> Source Manager Loaded";
            }
            case 3: {
                return "<3> Source Manager Open";
            }
            case 4: {
                return "<4> Data Source Open";
            }
            case 5: {
                return "<5> Data Source Enabled";
            }
            case 6: {
                return "<6> Transfer Ready";
            }
            case 7: {
                return "<7> Transfering";
            }
            case -2: {
                return "<#> Data Source Not In Use";
            }
        }
        return "<?> Unknown State!";
    }
}

