/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.lowlevel.ValueContainer;

public class Capability
implements JTwainConstants {
    private int capabilityCode;
    private ValueContainer container;

    public static Capability newInstance(int capabilityCode) {
        return new Capability(capabilityCode);
    }

    public Capability() {
    }

    public Capability(int capabilityCode) {
        this.setCapabilityCode(capabilityCode);
    }

    public Capability(int capabilityCode, ValueContainer container) {
        this.setCapabilityCode(capabilityCode);
        this.setContainer(container);
    }

    public int getCapabilityCode() {
        return this.capabilityCode;
    }

    public ValueContainer getContainer() {
        return this.container;
    }

    public void setCapabilityCode(int code) {
        this.capabilityCode = code;
    }

    public void setContainer(ValueContainer container) {
        this.container = container;
    }

    public int getContainerType() {
        if (this.container == null) {
            return 65535;
        }
        return this.container.getContainerType();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Capability: \n");
        sb.append("Capability code:\t" + this.capabilityCode + "\n");
        sb.append("Container:\t" + this.getContainer());
        return sb.toString();
    }

    public static String getCapabilityString(int code) {
        switch (code) {
            case 32768: {
                return "CAP_CUSTOMBASE";
            }
            case 1: {
                return "CAP_XFERCOUNT";
            }
            case 256: {
                return "ICAP_COMPRESSION";
            }
            case 257: {
                return "ICAP_PIXELTYPE";
            }
            case 258: {
                return "ICAP_UNITS";
            }
            case 259: {
                return "ICAP_XFERMECH";
            }
            case 4096: {
                return "CAP_AUTHOR";
            }
            case 4097: {
                return "CAP_CAPTION";
            }
            case 4098: {
                return "CAP_FEEDERENABLED";
            }
            case 4099: {
                return "CAP_FEEDERLOADED";
            }
            case 4100: {
                return "CAP_TIMEDATE";
            }
            case 4101: {
                return "CAP_SUPPORTEDCAPS";
            }
            case 4102: {
                return "CAP_EXTENDEDCAPS";
            }
            case 4103: {
                return "CAP_AUTOFEED";
            }
            case 4104: {
                return "CAP_CLEARPAGE";
            }
            case 4105: {
                return "CAP_FEEDPAGE";
            }
            case 4106: {
                return "CAP_REWINDPAGE";
            }
            case 4107: {
                return "CAP_INDICATORS";
            }
            case 4108: {
                return "CAP_SUPPORTEDCAPSEXT";
            }
            case 4109: {
                return "CAP_PAPERDETECTABLE";
            }
            case 4110: {
                return "CAP_UICONTROLLABLE";
            }
            case 4111: {
                return "CAP_DEVICEONLINE";
            }
            case 4112: {
                return "CAP_AUTOSCAN";
            }
            case 4113: {
                return "CAP_THUMBNAILSENABLED";
            }
            case 4114: {
                return "CAP_DUPLEX";
            }
            case 4115: {
                return "CAP_DUPLEXENABLED";
            }
            case 4116: {
                return "CAP_ENABLEDSUIONLY";
            }
            case 4117: {
                return "CAP_CUSTOMDSDATA";
            }
            case 4118: {
                return "CAP_ENDORSER";
            }
            case 4119: {
                return "CAP_JOBCONTROL";
            }
            case 4120: {
                return "CAP_ALARMS";
            }
            case 4121: {
                return "CAP_ALARMVOLUME";
            }
            case 4122: {
                return "CAP_AUTOMATICCAPTURE";
            }
            case 4123: {
                return "CAP_TIMEBEFOREFIRSTCAPTURE";
            }
            case 4124: {
                return "CAP_TIMEBETWEENCAPTURES";
            }
            case 4125: {
                return "CAP_CLEARBUFFERS";
            }
            case 4126: {
                return "CAP_MAXBATCHBUFFERS";
            }
            case 4127: {
                return "CAP_DEVICETIMEDATE";
            }
            case 4128: {
                return "CAP_POWERSUPPLY";
            }
            case 4129: {
                return "CAP_CAMERAPREVIEWUI";
            }
            case 4130: {
                return "CAP_DEVICEEVENT";
            }
            case 4132: {
                return "CAP_SERIALNUMBER";
            }
            case 4134: {
                return "CAP_PRINTER";
            }
            case 4135: {
                return "CAP_PRINTERENABLED";
            }
            case 4136: {
                return "CAP_PRINTERINDEX";
            }
            case 4137: {
                return "CAP_PRINTERMODE";
            }
            case 4138: {
                return "CAP_PRINTERSTRING";
            }
            case 4139: {
                return "CAP_PRINTERSUFFIX";
            }
            case 4140: {
                return "CAP_LANGUAGE";
            }
            case 4141: {
                return "CAP_FEEDERALIGNMENT";
            }
            case 4142: {
                return "CAP_FEEDERORDER";
            }
            case 4144: {
                return "CAP_REACQUIREALLOWED";
            }
            case 4146: {
                return "CAP_BATTERYMINUTES";
            }
            case 4147: {
                return "CAP_BATTERYPERCENTAGE";
            }
            case 4352: {
                return "ICAP_AUTOBRIGHT";
            }
            case 4353: {
                return "ICAP_BRIGHTNESS";
            }
            case 4355: {
                return "ICAP_CONTRAST";
            }
            case 4356: {
                return "ICAP_CUSTHALFTONE";
            }
            case 4357: {
                return "ICAP_EXPOSURETIME";
            }
            case 4358: {
                return "ICAP_FILTER";
            }
            case 4359: {
                return "ICAP_FLASHUSED";
            }
            case 4360: {
                return "ICAP_GAMMA";
            }
            case 4361: {
                return "ICAP_HALFTONES";
            }
            case 4362: {
                return "ICAP_HIGHLIGHT";
            }
            case 4364: {
                return "ICAP_IMAGEFILEFORMAT";
            }
            case 4365: {
                return "ICAP_LAMPSTATE";
            }
            case 4366: {
                return "ICAP_LIGHTSOURCE";
            }
            case 4368: {
                return "ICAP_ORIENTATION";
            }
            case 4370: {
                return "ICAP_PHYSICALHEIGHT";
            }
            case 4369: {
                return "ICAP_PHYSICALWIDTH";
            }
            case 4371: {
                return "ICAP_SHADOW";
            }
            case 4372: {
                return "ICAP_FRAMES";
            }
            case 4374: {
                return "ICAP_XNATIVERESOLUTION";
            }
            case 4375: {
                return "ICAP_YNATIVERESOLUTION";
            }
            case 4376: {
                return "ICAP_YRESOLUTION";
            }
            case 4377: {
                return "ICAP_YRESOLUTION";
            }
            case 4378: {
                return "ICAP_MAXFRAMES";
            }
            case 4379: {
                return "ICAP_TILES";
            }
            case 4380: {
                return "ICAP_BITORDER";
            }
            case 4381: {
                return "ICAP_CCITTKFACTOR";
            }
            case 4382: {
                return "ICAP_LIGHTPATH";
            }
            case 4383: {
                return "ICAP_PIXELFLAVOR";
            }
            case 4384: {
                return "ICAP_PLANARCHUNKY";
            }
            case 4385: {
                return "ICAP_ROTATION";
            }
            case 4386: {
                return "ICAP_SUPPORTEDSIZES";
            }
            case 4387: {
                return "ICAP_THRESHOLD";
            }
            case 4388: {
                return "ICAP_XSCALING";
            }
            case 4389: {
                return "ICAP_YSCALING";
            }
            case 4390: {
                return "ICAP_BITORDERCODES";
            }
            case 4391: {
                return "ICAP_PIXELFLAVORCODES";
            }
            case 4392: {
                return "ICAP_JPEGPIXELTYPE";
            }
            case 4394: {
                return "ICAP_TIMEFILL";
            }
            case 4395: {
                return "ICAP_BITDEPTH";
            }
            case 4396: {
                return "ICAP_BITDEPTHREDUCTION";
            }
            case 4397: {
                return "ICAP_UNDEFINEDIMAGESIZE";
            }
            case 4398: {
                return "ICAP_IMAGEDATASET";
            }
            case 4399: {
                return "ICAP_EXTIMAGEINFO";
            }
            case 4400: {
                return "ICAP_MINIMUMHEIGHT";
            }
            case 4401: {
                return "ICAP_MINIMUMWIDTH";
            }
            case 4406: {
                return "ICAP_FLIPROTATION";
            }
            case 4407: {
                return "ICAP_BARCODEDETECTIONENABLED";
            }
            case 4408: {
                return "ICAP_SUPPORTEDBARCODETYPES";
            }
            case 4409: {
                return "ICAP_BARCODEMAXSEARCHPRIORITIES";
            }
            case 4410: {
                return "ICAP_BARCODESEARCHPRIORITIES";
            }
            case 4411: {
                return "ICAP_BARCODESEARCHMODE";
            }
            case 4412: {
                return "ICAP_BARCODEMAXRETRIES";
            }
            case 4413: {
                return "ICAP_BARCODETIMEOUT";
            }
            case 4414: {
                return "ICAP_ZOOMFACTOR";
            }
            case 4415: {
                return "ICAP_PATCHCODEDETECTIONENABLED";
            }
            case 4416: {
                return "ICAP_SUPPORTEDPATCHCODETYPES";
            }
            case 4417: {
                return "ICAP_PATCHCODEMAXSEARCHPRIORITIES";
            }
            case 4418: {
                return "ICAP_PATCHCODESEARCHPRIORITIES";
            }
            case 4419: {
                return "ICAP_PATCHCODESEARCHMODE";
            }
            case 4420: {
                return "ICAP_PATCHCODEMAXRETRIES";
            }
            case 4421: {
                return "ICAP_PATCHCODETIMEOUT";
            }
            case 4422: {
                return "ICAP_FLASHUSED2";
            }
            case 4423: {
                return "ICAP_IMAGEFILTER";
            }
            case 4424: {
                return "ICAP_NOISEFILTER";
            }
            case 4425: {
                return "ICAP_OVERSCAN";
            }
            case 4432: {
                return "ICAP_AUTOMATICBORDERDETECTION";
            }
            case 4433: {
                return "ICAP_AUTOMATICDESKEW";
            }
            case 4434: {
                return "ICAP_AUTOMATICROTATE";
            }
            case 4435: {
                return "ICAP_JPEGQUALITY";
            }
            case 4609: {
                return "ACAP_AUDIOFILEFORMAT";
            }
            case 4610: {
                return "ACAP_XFERMECH";
            }
        }
        return "Unknown";
    }
}

