/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIOException;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLRowID
implements SQLData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final byte[] default_ = new byte[0];
    private SQLConversionSettings settings_;
    private int length_;
    private int truncated_;
    private byte[] value_;

    SQLRowID(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
        this.length_ = 0;
        this.truncated_ = 0;
        this.value_ = default_;
    }

    public Object clone() {
        return new SQLRowID(this.settings_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.length_ = BinaryConverter.byteArrayToUnsignedShort(byArray, n);
        this.value_ = new byte[this.length_];
        System.arraycopy(byArray, n + 2, this.value_, 0, this.length_);
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.unsignedShortToByteArray(this.length_, byArray, n);
        int n2 = this.value_.length < byArray.length ? this.value_.length : byArray.length;
        System.arraycopy(this.value_, 0, byArray, n + 2, n2);
        for (int i = n + 2 + n2; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        if (object instanceof String) {
            try {
                this.value_ = BinaryConverter.stringToBytes((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else if (object instanceof byte[]) {
            this.value_ = (byte[])object;
        } else if (object instanceof InputStream) {
            int n2 = n;
            if (n2 >= 0) {
                int n3;
                InputStream inputStream = (InputStream)object;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n4 = n2 < 1000000 ? n2 : 1000000;
                byte[] byArray = new byte[n4];
                try {
                    n3 = 0;
                    int n5 = inputStream.read(byArray, 0, n4);
                    while (n5 > -1 && n3 < n2) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                        int n6 = n2 - (n3 += n5);
                        if (n6 < n4) {
                            n4 = n6;
                        }
                        n5 = inputStream.read(byArray, 0, n4);
                    }
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
                this.value_ = byteArrayOutputStream.toByteArray();
                n3 = this.value_.length;
                if (this.value_.length > 40) {
                    byte[] byArray2 = new byte[40];
                    System.arraycopy(this.value_, 0, byArray2, 0, 40);
                    this.value_ = byArray2;
                }
                this.truncated_ = n3 - this.value_.length;
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof Reader) {
            int n7 = n;
            if (n7 >= 0) {
                try {
                    int n8;
                    int n9 = n7 < 1000000 ? n7 : 1000000;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HexReaderInputStream hexReaderInputStream = new HexReaderInputStream((Reader)object);
                    byte[] byArray = new byte[n9];
                    int n10 = 0;
                    int n11 = hexReaderInputStream.read(byArray, 0, n9);
                    while (n11 > -1 && n10 < n7) {
                        byteArrayOutputStream.write(byArray, 0, n11);
                        n8 = n7 - (n10 += n11);
                        if (n8 < n9) {
                            n9 = n8;
                        }
                        n11 = hexReaderInputStream.read(byArray, 0, n9);
                    }
                    this.value_ = byteArrayOutputStream.toByteArray();
                    n8 = this.value_.length;
                    if (this.value_.length > 40) {
                        byte[] byArray3 = new byte[40];
                        System.arraycopy(this.value_, 0, byArray3, 0, 40);
                        this.value_ = byArray3;
                    }
                    hexReaderInputStream.close();
                    this.truncated_ = n8 - this.value_.length;
                }
                catch (ExtendedIOException extendedIOException) {
                    JDError.throwSQLException((Object)this, "07006", extendedIOException);
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "HY000", iOException);
                }
            } else {
                JDError.throwSQLException(this, "07006");
            }
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Blob) {
            this.value_ = ((Blob)object).getBytes(1L, (int)((Blob)object).length());
        } else if (JDUtilities.JDBCLevel_ >= 20 && object instanceof Clob) {
            try {
                this.value_ = BinaryConverter.stringToBytes(((Clob)object).getSubString(1L, (int)((Clob)object).length()));
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
        } else {
            JDError.throwSQLException(this, "07006");
        }
        int n12 = this.value_.length;
        if (n12 > 40) {
            byte[] byArray = new byte[40];
            System.arraycopy(this.value_, 0, byArray, 0, 40);
            this.value_ = byArray;
            this.truncated_ = n12 - 40;
        } else {
            this.truncated_ = 0;
        }
        this.length_ = this.value_.length;
    }

    public int getSQLType() {
        return 25;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 40;
    }

    public String getJavaClassName() {
        return "[B";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "ROWID";
    }

    public int getMaximumPrecision() {
        return 40;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 904;
    }

    public int getPrecision() {
        return 40;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return -2;
    }

    public String getTypeName() {
        return "ROWID";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.value_.length;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(BinaryConverter.bytesToString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        return new ByteArrayInputStream(this.getBytes());
    }

    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        byte[] byArray = this.getBytes();
        return new AS400JDBCBlob(byArray, byArray.length);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        int n = this.settings_.getMaxFieldSize();
        if (this.value_.length > n && n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.value_, 0, byArray, 0, n);
            return byArray;
        }
        return this.value_;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        return new StringReader(BinaryConverter.bytesToString(this.getBytes()));
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        String string = BinaryConverter.bytesToString(this.getBytes());
        return new AS400JDBCClob(string, string.length());
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        return this.getBytes();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        return BinaryConverter.bytesToString(this.getBytes());
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        try {
            return new ByteArrayInputStream(ConvTable.getTable(13488, null).stringToByteArray(BinaryConverter.bytesToString(this.getBytes())));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

