/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DecFloat;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLData;
import com.ibm.as400.access.SQLDataFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLDecFloat16
implements SQLData {
    private static final BigDecimal default_ = BigDecimal.valueOf(0L);
    private static final BigDecimal BYTE_MAX_VALUE = BigDecimal.valueOf(127L);
    private static final BigDecimal BYTE_MIN_VALUE = BigDecimal.valueOf(-128L);
    private static final BigDecimal SHORT_MAX_VALUE = BigDecimal.valueOf(32767L);
    private static final BigDecimal SHORT_MIN_VALUE = BigDecimal.valueOf(-32768L);
    private static final BigDecimal INTEGER_MAX_VALUE = BigDecimal.valueOf(Integer.MAX_VALUE);
    private static final BigDecimal INTEGER_MIN_VALUE = BigDecimal.valueOf(Integer.MIN_VALUE);
    private static final BigDecimal LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal FLOAT_MAX_VALUE = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal FLOAT_MIN_VALUE = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal DOUBLE_MAX_VALUE = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal DOUBLE_MIN_VALUE = new BigDecimal(-1.7976931348623157E308);
    private static final int DECFLOAT16_MIN_EXP = -383;
    private SQLConversionSettings settings_;
    private int precision_;
    private int truncated_;
    String specialValue_ = null;
    private AS400DecFloat typeConverter_;
    private BigDecimal value_;
    private JDProperties properties_;
    private int roundingMode;
    private String roundingModeStr;
    private int vrm_;

    SQLDecFloat16(SQLConversionSettings sQLConversionSettings, int n, JDProperties jDProperties) {
        this.settings_ = sQLConversionSettings;
        this.precision_ = 16;
        this.truncated_ = 0;
        this.roundingModeStr = jDProperties.getString(74);
        this.typeConverter_ = new AS400DecFloat(this.precision_);
        this.value_ = default_;
        this.vrm_ = n;
        this.properties_ = jDProperties;
        if (this.roundingModeStr.equals("up")) {
            this.roundingMode = 0;
        } else if (this.roundingModeStr.equals("down")) {
            this.roundingMode = 1;
        } else if (this.roundingModeStr.equals("ceiling")) {
            this.roundingMode = 2;
        } else if (this.roundingModeStr.equals("floor")) {
            this.roundingMode = 3;
        } else if (this.roundingModeStr.equals("half up")) {
            this.roundingMode = 4;
        } else if (this.roundingModeStr.equals("half down")) {
            this.roundingMode = 5;
        } else if (this.roundingModeStr.equals("half even")) {
            this.roundingMode = 6;
        }
        this.roundingModeStr = "ROUND_" + this.roundingModeStr.toUpperCase().replace(' ', '_');
    }

    public Object clone() {
        return new SQLDecFloat16(this.settings_, this.vrm_, this.properties_);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        block2: {
            try {
                this.value_ = (BigDecimal)this.typeConverter_.toObject(byArray, n);
                this.specialValue_ = null;
            }
            catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
                this.specialValue_ = this.getSpecialValue(extendedIllegalArgumentException.toString());
                if (this.specialValue_ != null) break block2;
                throw extendedIllegalArgumentException;
            }
        }
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        try {
            if (this.specialValue_ == null) {
                this.typeConverter_.toBytes(this.value_, byArray, n);
            } else {
                this.typeConverter_.toBytes(this.specialValue_, byArray, n);
            }
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            JDError.throwSQLException((Object)this, "07006", extendedIllegalArgumentException);
        }
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        BigDecimal bigDecimal = null;
        this.specialValue_ = null;
        if (object instanceof String) {
            try {
                this.specialValue_ = this.getSpecialValue((String)object);
                if (this.specialValue_ == null) {
                    bigDecimal = new BigDecimal((String)object);
                }
            }
            catch (NumberFormatException numberFormatException) {
                JDError.throwSQLException((Object)this, "07006", numberFormatException);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                JDError.throwSQLException(this, "07006");
            }
        } else if (object instanceof Number) {
            this.specialValue_ = this.getSpecialValue(object.toString());
            if (this.specialValue_ == null) {
                bigDecimal = new BigDecimal(object.toString());
            }
        } else if (object instanceof Boolean) {
            bigDecimal = (Boolean)object == true ? BigDecimal.valueOf(1L) : BigDecimal.valueOf(0L);
        } else {
            JDError.throwSQLException(this, "07006");
        }
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            this.value_ = null;
            return;
        }
        this.value_ = AS400DecFloat.roundByMode(bigDecimal, 16, this.roundingModeStr);
    }

    public int getSQLType() {
        return 38;
    }

    public String getCreateParameters() {
        return null;
    }

    public int getDisplaySize() {
        return 23;
    }

    public String getJavaClassName() {
        return "java.math.BigDecimal";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "DECFLOAT";
    }

    public int getMaximumPrecision() {
        return this.precision_;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 996;
    }

    public int getPrecision() {
        return this.precision_;
    }

    public int getRadix() {
        return 10;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 1111;
    }

    public String getTypeName() {
        return "DECFLOAT";
    }

    public boolean isSigned() {
        return true;
    }

    public boolean isText() {
        return false;
    }

    public int getActualSize() {
        if (this.specialValue_ == null) {
            return SQLDataFactory.getPrecision(this.value_);
        }
        return this.specialValue_.length();
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public InputStream getAsciiStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            JDError.throwSQLException(this, "07006");
            return null;
        }
        if (n >= 0) {
            if (n >= this.value_.scale()) {
                return this.value_.setScale(n);
            }
            this.truncated_ = this.value_.scale() - n;
            return this.value_.setScale(n, this.roundingMode);
        }
        return this.value_;
    }

    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Blob getBlob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public boolean getBoolean() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            return false;
        }
        return this.value_.compareTo(BigDecimal.valueOf(0L)) != 0;
    }

    public byte getByte() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Double("-NaN").byteValue();
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Double("NaN").byteValue();
            }
            return new Double(this.specialValue_).byteValue();
        }
        if (this.value_.compareTo(BYTE_MAX_VALUE) > 0 || this.value_.compareTo(BYTE_MIN_VALUE) < 0) {
            this.truncated_ = this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0 ? (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0 ? (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0 ? 15 : 7) : 3) : 1;
        }
        return this.value_.byteValue();
    }

    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Reader getCharacterStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Clob getClob() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Double("-NaN");
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Double("NaN");
            }
            return new Double(this.specialValue_);
        }
        if (this.value_.compareTo(DOUBLE_MAX_VALUE) > 0 || this.value_.compareTo(DOUBLE_MIN_VALUE) < 0) {
            this.truncated_ = 8;
        }
        return this.value_.doubleValue();
    }

    public float getFloat() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            if (this.specialValue_.indexOf("-SNaN") != -1) {
                return new Float("-NaN").floatValue();
            }
            if (this.specialValue_.indexOf("SNaN") != -1) {
                return new Float("NaN").floatValue();
            }
            return new Float(this.specialValue_).floatValue();
        }
        if (this.value_.compareTo(FLOAT_MAX_VALUE) > 0 || this.value_.compareTo(FLOAT_MIN_VALUE) < 0) {
            this.truncated_ = this.value_.compareTo(DOUBLE_MAX_VALUE) > 0 || this.value_.compareTo(DOUBLE_MIN_VALUE) < 0 ? 12 : 4;
        }
        return this.value_.floatValue();
    }

    public int getInt() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            JDError.throwSQLException(this, "07006");
        }
        if (this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0) {
            this.truncated_ = this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0 ? 12 : 4;
        }
        return this.value_.intValue();
    }

    public long getLong() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            JDError.throwSQLException(this, "07006");
        }
        if (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0) {
            this.truncated_ = 8;
        }
        return this.value_.longValue();
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            return this.specialValue_;
        }
        return this.value_;
    }

    public short getShort() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            JDError.throwSQLException(this, "07006");
        }
        if (this.value_.compareTo(SHORT_MAX_VALUE) > 0 || this.value_.compareTo(SHORT_MIN_VALUE) < 0) {
            this.truncated_ = this.value_.compareTo(INTEGER_MAX_VALUE) > 0 || this.value_.compareTo(INTEGER_MIN_VALUE) < 0 ? (this.value_.compareTo(LONG_MAX_VALUE) > 0 || this.value_.compareTo(LONG_MIN_VALUE) < 0 ? 14 : 6) : 2;
        }
        return this.value_.shortValue();
    }

    public String getString() throws SQLException {
        this.truncated_ = 0;
        if (this.specialValue_ != null) {
            return this.specialValue_;
        }
        String string = this.value_.toString();
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + this.settings_.getDecimalSeparator() + string.substring(n + 1);
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }

    private String getSpecialValue(String string) {
        int n = -1;
        n = string.toUpperCase().indexOf("SNAN");
        if (n != -1) {
            if (n > 0 && string.charAt(n - 1) == '-') {
                return "-SNaN";
            }
            return "SNaN";
        }
        n = string.toUpperCase().indexOf("NAN");
        if (n != -1) {
            if (n > 0 && string.charAt(n - 1) == '-' || n > 1 && string.charAt(n - 2) == '-') {
                return "-NaN";
            }
            return String.valueOf(Double.NaN);
        }
        n = string.toUpperCase().indexOf("INF");
        if (n != -1) {
            if (n != 0 && string.charAt(n - 1) == '-') {
                return String.valueOf(Double.NEGATIVE_INFINITY);
            }
            return String.valueOf(Double.POSITIVE_INFINITY);
        }
        return null;
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException(this, "07006");
        return null;
    }
}

