/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.LicenseBaseRequest;
import com.ibm.as400.access.LicenseException;
import com.ibm.as400.access.LicenseGetInformationReply;
import com.ibm.as400.access.LicenseGetReply;
import com.ibm.as400.access.LicenseGetRequest;
import com.ibm.as400.access.LicenseReleaseReply;
import com.ibm.as400.access.LicenseReleaseRequest;
import com.ibm.as400.access.NLSExchangeAttrReply;
import com.ibm.as400.access.NLSExchangeAttrRequest;
import com.ibm.as400.access.ProductLicenseEvent;
import com.ibm.as400.access.ProductLicenseListener;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;

public class ProductLicense
implements Serializable {
    public static final int USAGE_CONCURRENT = 1;
    public static final int USAGE_REGISTERED = 2;
    public static final int COMPLIANCE_OPERATOR_ACTION = 1;
    public static final int COMPLIANCE_WARNING = 2;
    public static final int COMPLIANCE_KEYED = 3;
    public static final int CONDITION_OK = 0;
    public static final int CONDITION_EXCEEDED_OK = 43;
    public static final int CONDITION_EXCEEDED_GRACE_PERIOD = 44;
    public static final int CONDITION_GRACE_PERIOD_EXPIRED = 46;
    private transient PropertyChangeSupport changes_;
    private transient Vector productLicenseListeners_;
    static final long serialVersionUID = 4L;
    private transient boolean released_;
    private transient int condition_;
    private transient AS400 sys_;
    private transient AS400Server server_;
    private transient AS400ImplRemote sysImpl_;
    private String productID_;
    private String featureID_;
    private String releaseLevel_;
    private transient int usageLimit_;
    private transient int usageCount_;
    private transient int usageType_;
    private transient int complianceType_;
    private transient String licenseTerm_;

    public ProductLicense() {
        this.initializeTransient();
        this.productID_ = null;
        this.featureID_ = null;
    }

    public ProductLicense(AS400 aS400, String string, String string2, String string3) {
        this();
        this.sys_ = new AS400(aS400);
        if (this.sys_ == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("productID");
        }
        this.productID_ = string;
        if (string2 == null) {
            throw new NullPointerException("featureID");
        }
        this.featureID_ = string2;
        this.releaseLevel_ = string3 == null ? "      " : string3;
    }

    public void addProductLicenseListener(ProductLicenseListener productLicenseListener) {
        if (productLicenseListener == null) {
            throw new NullPointerException("listener");
        }
        this.productLicenseListeners_.addElement(productLicenseListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        AS400 aS400 = this.sys_;
        synchronized (aS400) {
            block7: {
                if (this.server_ != null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Disconnecting from server");
                    }
                    try {
                        this.sysImpl_.disconnectServer(this.server_);
                        this.server_ = null;
                    }
                    catch (Exception exception) {
                        if (!Trace.isTraceOn()) break block7;
                        Trace.log(2, "Exception encountered while disconnecting", (Throwable)exception);
                    }
                }
            }
        }
    }

    protected void finalize() {
        block3: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "finalize() - ProductLicense");
            }
            try {
                this.release();
            }
            catch (Exception exception) {
                if (!Trace.isTraceOn()) break block3;
                Trace.log(2, "release license failed", (Throwable)exception);
            }
        }
    }

    private void fireProductLicenseEvent(int n) {
        ProductLicenseEvent productLicenseEvent = new ProductLicenseEvent(this, n);
        Vector vector = (Vector)this.productLicenseListeners_.clone();
        block4: for (int i = 0; i < vector.size(); ++i) {
            ProductLicenseListener productLicenseListener = (ProductLicenseListener)vector.elementAt(i);
            switch (n) {
                case 0: {
                    productLicenseListener.licenseReleased(productLicenseEvent);
                    continue block4;
                }
                case 1: {
                    productLicenseListener.licenseRequested(productLicenseEvent);
                }
            }
        }
    }

    public int getComplianceType() {
        if (this.released_) {
            throw new ExtendedIllegalStateException(14);
        }
        return this.complianceType_;
    }

    public int getCondition() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 14);
        }
        return this.condition_;
    }

    public String getFeature() {
        return this.featureID_;
    }

    public String getLicenseTerm() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 14);
        }
        return this.licenseTerm_;
    }

    public String getProductID() {
        return this.productID_;
    }

    public String getReleaseLevel() {
        return this.releaseLevel_;
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    public int getUsageCount() {
        if (this.released_) {
            throw new ExtendedIllegalStateException(14);
        }
        return this.usageCount_;
    }

    public int getUsageLimit() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 14);
        }
        return this.usageLimit_;
    }

    public int getUsageType() {
        if (this.released_) {
            throw new ExtendedIllegalStateException("UsageType", 14);
        }
        return this.usageType_;
    }

    private void initializeTransient() {
        this.changes_ = new PropertyChangeSupport(this);
        this.productLicenseListeners_ = new Vector();
        this.sys_ = null;
        this.sysImpl_ = null;
        this.condition_ = 0;
        this.released_ = true;
        this.usageLimit_ = 0;
        this.usageCount_ = -1;
        this.usageType_ = -1;
        this.complianceType_ = -1;
        this.licenseTerm_ = null;
        this.releaseLevel_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws IOException, InterruptedException, LicenseException {
        if (this.sys_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "System not set yet.");
            }
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.productID_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Product ID not set yet.");
            }
            throw new ExtendedIllegalStateException("productID", 4);
        }
        if (this.featureID_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Feature ID not set yet.");
            }
            throw new ExtendedIllegalStateException("featureID", 4);
        }
        if (this.releaseLevel_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Release not set yet.");
            }
            throw new ExtendedIllegalStateException("release", 4);
        }
        AS400 aS400 = this.sys_;
        synchronized (aS400) {
            if (this.released_) {
                return;
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "Releasing license from server");
            }
            if (this.server_ != null) {
                LicenseReleaseRequest licenseReleaseRequest = new LicenseReleaseRequest(this.sys_);
                licenseReleaseRequest.setProductID(this.productID_);
                licenseReleaseRequest.setFeature(this.featureID_);
                licenseReleaseRequest.setRelease(this.releaseLevel_);
                DataStream dataStream = this.server_.sendAndReceive(licenseReleaseRequest);
                if (dataStream instanceof LicenseReleaseReply) {
                    LicenseReleaseReply licenseReleaseReply = (LicenseReleaseReply)dataStream;
                    this.released_ = true;
                    this.disconnect();
                    if (licenseReleaseReply.getPrimaryRC() != 0) {
                        if (Trace.isTraceOn()) {
                            Trace.log(1, "Release license failed, primary return code = ", licenseReleaseReply.getPrimaryRC());
                            Trace.log(1, "Release license failed, secondary return code = ", licenseReleaseReply.getSecondaryRC());
                        }
                        throw new LicenseException(licenseReleaseReply.getPrimaryRC(), licenseReleaseReply.getSecondaryRC());
                    }
                    this.fireProductLicenseEvent(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int request() throws IOException, AS400SecurityException, InterruptedException, LicenseException {
        if (this.sys_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "System not set yet.");
            }
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.productID_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Product ID not set yet.");
            }
            throw new ExtendedIllegalStateException("productID", 4);
        }
        if (this.featureID_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Feature ID not set yet.");
            }
            throw new ExtendedIllegalStateException("featureID", 4);
        }
        if (this.releaseLevel_ == null) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Release not set yet.");
            }
            throw new ExtendedIllegalStateException("release", 4);
        }
        AS400 aS400 = this.sys_;
        synchronized (aS400) {
            ClientAccessDataStream clientAccessDataStream;
            if (!this.released_) {
                throw new ExtendedIllegalStateException("Object= " + this.sys_.getSystemName(), 15);
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "retrieving license from server");
            }
            this.sys_.connectService(6);
            this.sysImpl_ = (AS400ImplRemote)this.sys_.getImpl();
            this.server_ = this.sysImpl_.getConnection(6, false);
            NLSExchangeAttrRequest nLSExchangeAttrRequest = new NLSExchangeAttrRequest();
            try {
                this.server_.sendExchangeAttrRequest(nLSExchangeAttrRequest);
            }
            catch (IOException iOException) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "IOException After Exchange Attribute Request", (Throwable)iOException);
                }
                this.disconnect();
                throw iOException;
            }
            DataStream dataStream = this.server_.getExchangeAttrReply();
            if (dataStream instanceof NLSExchangeAttrReply) {
                clientAccessDataStream = (NLSExchangeAttrReply)dataStream;
                if (((NLSExchangeAttrReply)clientAccessDataStream).primaryRC_ != 0) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Exchange attribute failed, primary return code =" + ((NLSExchangeAttrReply)clientAccessDataStream).primaryRC_ + "secondary return code =" + ((NLSExchangeAttrReply)clientAccessDataStream).secondaryRC_);
                    }
                    this.disconnect();
                    throw new IOException();
                }
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "Unknown instance returned from Exchange Attribute Reply");
                }
                throw new InternalErrorException(2);
            }
            clientAccessDataStream = new LicenseGetRequest(this.sys_);
            ((LicenseBaseRequest)clientAccessDataStream).setProductID(this.productID_);
            ((LicenseBaseRequest)clientAccessDataStream).setFeature(this.featureID_);
            ((LicenseBaseRequest)clientAccessDataStream).setRelease(this.releaseLevel_);
            try {
                dataStream = this.server_.sendAndReceive(clientAccessDataStream);
            }
            catch (IOException iOException) {
                if (Trace.isTraceOn()) {
                    Trace.log(2, "IOException occured - Request license", (Throwable)iOException);
                }
                this.disconnect();
                throw iOException;
            }
            if (dataStream instanceof LicenseGetReply) {
                LicenseGetReply licenseGetReply = (LicenseGetReply)dataStream;
                if (licenseGetReply.getPrimaryRC() == 0) {
                    this.usageLimit_ = licenseGetReply.getUsageLimit();
                    this.usageCount_ = licenseGetReply.getUsageCount();
                    ++this.usageCount_;
                    this.usageType_ = licenseGetReply.getUsageType();
                    this.complianceType_ = licenseGetReply.getComplianceType();
                    this.licenseTerm_ = licenseGetReply.getLicenseTerm();
                    this.releaseLevel_ = licenseGetReply.getReleaseLevel();
                    this.condition_ = licenseGetReply.getSecondaryRC();
                    this.released_ = false;
                    this.fireProductLicenseEvent(1);
                    return this.condition_;
                }
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Request license failed, primary return code =" + licenseGetReply.getPrimaryRC() + "secondary return code =" + licenseGetReply.getSecondaryRC());
                }
                throw new LicenseException(licenseGetReply.getPrimaryRC(), licenseGetReply.getSecondaryRC());
            }
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unknown instance returned from Get License Reply");
            }
            throw new InternalErrorException(2);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeProductLicenseListener(ProductLicenseListener productLicenseListener) {
        if (productLicenseListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.productLicenseListeners_.removeElement(productLicenseListener);
    }

    public void setFeature(String string) {
        if (string == null) {
            throw new NullPointerException("featureID");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("featureID", 5);
        }
        String string2 = this.featureID_;
        this.featureID_ = string;
        this.changes_.firePropertyChange("featureID", string2, this.featureID_);
    }

    public void setProductID(String string) {
        if (string == null) {
            throw new NullPointerException("productID");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("productID", 5);
        }
        String string2 = this.productID_;
        this.productID_ = string;
        this.changes_.firePropertyChange("productID", string2, this.productID_);
    }

    public void setReleaseLevel(String string) {
        if (string == null) {
            throw new NullPointerException("releaseLevel");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("releaseLevel", 5);
        }
        String string2 = this.releaseLevel_;
        this.releaseLevel_ = string;
        this.changes_.firePropertyChange("releaseLevel", string2, this.releaseLevel_);
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.sysImpl_ != null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        AS400 aS4002 = this.sys_;
        this.sys_ = aS400;
        this.changes_.firePropertyChange("path", aS4002, this.sys_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    static {
        AS400Server.addReplyStream((DataStream)new NLSExchangeAttrReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new LicenseGetReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new LicenseReleaseReply(), "as-central");
        AS400Server.addReplyStream((DataStream)new LicenseGetInformationReply(), "as-central");
    }
}

