/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTF;
import com.ibm.as400.access.ProductDirectoryInformation;
import com.ibm.as400.access.ProductLicense;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class Product {
    private static final String USERSPACE_NAME = "JT4PTF    QTEMP     ";
    private static final String USERSPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC";
    private boolean loaded_ = false;
    private boolean loadedLoadID_ = false;
    private boolean partiallyLoaded_ = false;
    private boolean loadedOptions_ = false;
    private boolean loadedDescriptionText_ = false;
    private boolean loaded500_ = false;
    private boolean loaded800_ = false;
    private boolean error100_ = false;
    private boolean error500_ = false;
    private boolean error800_ = false;
    private AS400 system_;
    private String productID_;
    private String productOption_;
    private String releaseLevel_;
    private String descriptionID_;
    private String descriptionText_;
    private String messageFile_;
    private boolean installed_ = true;
    private String loadID_;
    private String loadType_;
    private String symbolicLoadState_;
    private boolean loadErrorIndicator_;
    private String loadState_;
    private boolean supported_;
    private String registrationType_;
    private String registrationValue_;
    private String primaryLanguageLoadID_;
    private String minimumTargetRelease_;
    private String minimumBaseVRM_;
    private int requirementsMet_;
    private String level_;
    private boolean allowsMultipleReleases_;
    private Date releaseDate_;
    private String firstCopyright_;
    private String currentCopyright_;
    private boolean allowsDynamicNaming_;
    private String minimumVRM_;
    private boolean allowsMixedReleases_;
    private ProductDirectoryInformation[] directories_;
    private Product[] options_;
    private int chunkSize_ = 8192;
    public static final String LOAD_STATE_DEFINED_NO_OBJECT = "10";
    public static final String LOAD_STATE_DEFINED_OBJECT_EXISTS = "20";
    public static final String LOAD_STATE_PACKAGED_RESTORE_FAILED_EXIT_PROGRAM_FAILED = "3E";
    public static final String LOAD_STATE_PACKAGED_RESTORE_FAILED = "3F";
    public static final String LOAD_STATE_PACKAGED = "30";
    public static final String LOAD_STATE_PACKAGED_RENAMED = "32";
    public static final String LOAD_STATE_PACKAGED_DAMAGED = "33";
    public static final String LOAD_STATE_PACKAGED_DELETED = "34";
    public static final String LOAD_STATE_PACKAGED_RESTORE_IN_PROGRESS = "35";
    public static final String LOAD_STATE_PACKAGED_DELETE_IN_PROGRESS = "38";
    public static final String LOAD_STATE_INSTALLED_RESTORE_IN_PROGRESS = "50";
    public static final String LOAD_STATE_INSTALLED_DELETE_IN_PROGRESS = "53";
    public static final String LOAD_STATE_IBM_SUPPLIED_NOT_COMPATIBLE = "59";
    public static final String LOAD_STATE_INSTALLED_RESTORE_FAILED_EXIT_PROGRAM_FAILED = "6E";
    public static final String LOAD_STATE_INSTALLED_RESTORE_FAILED = "6F";
    public static final String LOAD_STATE_RESTORED = "60";
    public static final String LOAD_STATE_RESTORED_EXIT_PROGRAM_FAILED = "61";
    public static final String LOAD_STATE_RESTORED_RENAMED = "62";
    public static final String LOAD_STATE_RESTORED_DAMAGED = "63";
    public static final String LOAD_STATE_RESTORED_DELETED = "64";
    public static final String LOAD_STATE_CHECK_ERROR = "67";
    public static final String LOAD_STATE_INSTALLED = "90";
    public static final String LOAD_TYPE_CODE = "*CODE";
    public static final String LOAD_TYPE_LANGUAGE = "*LNG";
    public static final String PRODUCT_OPTION_BASE = "*BASE";
    public static final String PRODUCT_FEATURE_CODE = "*CODE";
    public static final String PRODUCT_ID_OPERATING_SYSTEM = "*OPSYS";
    public static final String PRODUCT_RELEASE_CURRENT = "*CUR";
    public static final String PRODUCT_RELEASE_ONLY = "*ONLY";
    public static final String PRODUCT_RELEASE_PREVIOUS = "*PRV";
    public static final String PRODUCT_RELEASE_ANY = "ANY";
    public static final String REGISTRATION_TYPE_PHONE = "02";
    public static final String REGISTRATION_TYPE_SYSTEM = "04";
    public static final String REGISTRATION_TYPE_CUSTOMER = "08";
    public static final int REQUIREMENTS_UNKNOWN = 0;
    public static final int REQUIREMENTS_MET = 1;
    public static final int REQUIREMENTS_OPTION_TOO_OLD = 2;
    public static final int REQUIREMENTS_BASE_TOO_OLD = 3;
    public static final String SYMBOLIC_LOAD_STATE_DEFINED = "*DEFINED";
    public static final String SYMBOLIC_LOAD_STATE_CREATED = "*CREATED";
    public static final String SYMBOLIC_LOAD_STATE_PACKAGED = "*PACKAGED";
    public static final String SYMBOLIC_LOAD_STATE_DAMAGED = "*DAMAGED";
    public static final String SYMBOLIC_LOAD_STATE_LOADED = "*LOADED";
    public static final String SYMBOLIC_LOAD_STATE_INSTALLED = "*INSTALLED";

    public Product(AS400 aS400, String string) {
        this(aS400, string, PRODUCT_OPTION_BASE, PRODUCT_RELEASE_ANY, "*CODE");
    }

    public Product(AS400 aS400, String string, String string2) {
        this(aS400, string, string2, PRODUCT_RELEASE_ANY, "*CODE");
    }

    public Product(AS400 aS400, String string, String string2, String string3, String string4) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("productID");
        }
        if (string2 == null) {
            throw new NullPointerException("productOption");
        }
        if (string3 == null) {
            throw new NullPointerException("releaseLevel");
        }
        if (string4 == null) {
            throw new NullPointerException("featureID");
        }
        String string5 = string.toUpperCase().trim();
        if (string5.length() != 7 && !string5.equals(PRODUCT_ID_OPERATING_SYSTEM)) {
            throw new ExtendedIllegalArgumentException("productID", 1);
        }
        String string6 = string2.toUpperCase().trim();
        if (string6.equals(PRODUCT_OPTION_BASE)) {
            string6 = "0000";
        }
        if (string6.length() > 4) {
            throw new ExtendedIllegalArgumentException("productOption", 1);
        }
        while (string6.length() < 4) {
            string6 = "0" + string6;
        }
        String string7 = string3.toUpperCase().trim();
        if (!(string7.length() == 6 || string7.length() == 0 || string7.equals(PRODUCT_RELEASE_CURRENT) || string7.equals(PRODUCT_RELEASE_ONLY) || string7.equals(PRODUCT_RELEASE_PREVIOUS) || string7.equals(PRODUCT_RELEASE_ANY))) {
            throw new ExtendedIllegalArgumentException("releaseLevel", 1);
        }
        String string8 = string4.toUpperCase().trim();
        if (string8.length() != 4 && !string8.equals("*CODE")) {
            throw new ExtendedIllegalArgumentException("featureID", 1);
        }
        this.system_ = aS400;
        this.productID_ = string5;
        this.productOption_ = string6;
        this.releaseLevel_ = string7;
        this.loadID_ = string8;
    }

    public Product(AS400 aS400, String string, String string2, String string3, String string4, String string5) {
        this(aS400, string, string2, string3, "*CODE");
        if (string4 == null) {
            throw new NullPointerException("loadType");
        }
        if (string5 == null) {
            throw new NullPointerException("languageID");
        }
        this.loadType_ = string4;
        this.primaryLanguageLoadID_ = string5;
    }

    Product(AS400 aS400, String string, String string2, String string3, String string4, boolean bl, String string5, String string6) {
        this(aS400, string, string2, string3, string4);
        this.allowsDynamicNaming_ = bl;
        this.descriptionID_ = string5;
        this.minimumVRM_ = string6;
        this.loadedOptions_ = true;
    }

    Product(AS400 aS400, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, String string7, String string8) {
        this.system_ = aS400;
        this.productID_ = string;
        if (string2.equals(PRODUCT_OPTION_BASE)) {
            string2 = "0000";
        } else if (string2.length() > 4) {
            string2 = string2.substring(1, 5);
        }
        this.productOption_ = string2;
        this.releaseLevel_ = string3;
        this.descriptionID_ = string4;
        this.descriptionText_ = string5;
        this.messageFile_ = string6;
        this.installed_ = bl;
        this.supported_ = bl2;
        this.registrationType_ = string7;
        this.registrationValue_ = string8;
        this.partiallyLoaded_ = true;
    }

    public boolean allowsDynamicNaming() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedOptions_) {
            this.fillInOptionInformation();
        }
        return this.allowsDynamicNaming_;
    }

    public boolean allowsMixedReleases() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.allowsMixedReleases_;
    }

    public boolean allowsMultipleReleases() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.allowsMultipleReleases_;
    }

    private void fillInOptionInformation() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Product[] productArray = this.getProductOptions();
        for (int i = 0; i < productArray.length; ++i) {
            if (!productArray[i].getProductOption().equals(this.productOption_)) continue;
            this.allowsDynamicNaming_ = productArray[i].allowsDynamicNaming_;
            this.descriptionID_ = productArray[i].descriptionID_;
            this.minimumVRM_ = productArray[i].minimumVRM_;
            return;
        }
    }

    public String getCurrentCopyright() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.currentCopyright_;
    }

    public String getDescriptionID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedOptions_) {
            this.fillInOptionInformation();
        }
        return this.descriptionID_;
    }

    public String getDescriptionMessageFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.partiallyLoaded_ && !this.loaded500_) {
            this.refresh(500);
        }
        return this.messageFile_;
    }

    public String getDescriptionText() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.partiallyLoaded_ && !this.loadedDescriptionText_) {
            block3: {
                String string = this.getDescriptionMessageFile();
                String string2 = this.getDescriptionID();
                try {
                    MessageFile messageFile = new MessageFile(this.system_, string);
                    AS400Message aS400Message = messageFile.getMessage(string2);
                    this.descriptionText_ = aS400Message.getText();
                }
                catch (Exception exception) {
                    if (!Trace.traceOn_) break block3;
                    Trace.log(2, "Unable to retrieve product description text for " + string + " and " + string2 + ": ", (Throwable)exception);
                }
            }
            this.loadedDescriptionText_ = true;
        }
        return this.descriptionText_;
    }

    public ProductDirectoryInformation[] getDirectoryInformation() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded800_) {
            this.refresh(800);
        }
        return this.directories_;
    }

    public String getFeatureID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.loadID_ == null && !this.loadedLoadID_) {
            this.refresh(100);
        }
        return this.loadID_;
    }

    public String getFirstCopyright() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.firstCopyright_;
    }

    public String getLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.level_;
    }

    public ProductLicense getLicense() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String string = this.getFeatureID();
        String string2 = this.getReleaseLevel();
        ProductLicense productLicense = new ProductLicense(this.system_, this.productID_, string, string2);
        return productLicense;
    }

    public String getLoadState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.loadState_;
    }

    public String getLoadType() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.loadType_;
    }

    public String getMinimumRequiredRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loadedOptions_) {
            this.fillInOptionInformation();
        }
        return this.minimumVRM_;
    }

    public String getMinimumRequiredReleaseForBase() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.minimumBaseVRM_;
    }

    public String getMinimumTargetRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.minimumTargetRelease_;
    }

    public String getPrimaryLanguageFeatureID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.primaryLanguageLoadID_;
    }

    public String getProductID() {
        return this.productID_;
    }

    public String getProductOption() {
        return this.productOption_;
    }

    public Product[] getProductOptions() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.options_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PTF[] getPTFs(boolean bl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ProgramParameter[] programParameterArray;
        ConvTable convTable;
        block22: {
            if (!this.isInstalled()) {
                return new PTF[0];
            }
            int n = this.system_.getCcsid();
            convTable = ConvTable.getTable(n, null);
            programParameterArray = new ProgramParameter[4];
            try {
                programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray(USERSPACE_NAME));
                programParameterArray[0].setParameterType(2);
                object4 = new byte[50];
                object3 = new AS400Text(4, n, this.system_);
                AS400Text aS400Text = new AS400Text(6, n, this.system_);
                object2 = new AS400Text(7, n, this.system_);
                object = new AS400Text(10, n, this.system_);
                ((AS400Text)object2).toBytes(this.productID_, (byte[])object4, 0);
                aS400Text.toBytes(this.getReleaseLevel(), (byte[])object4, 7);
                ((AS400Text)object3).toBytes(this.productOption_, (byte[])object4, 13);
                if (this.loadID_ == null) {
                    this.refresh(100);
                }
                ((AS400Text)object).toBytes(this.loadID_.equals("*CODE") ? "*ALL" : this.loadID_, (byte[])object4, 17);
                object4[27] = bl ? -15 : -16;
                programParameterArray[1] = new ProgramParameter((byte[])object4);
                programParameterArray[1].setParameterType(2);
                programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("PTFL0100"));
                programParameterArray[2].setParameterType(2);
                programParameterArray[3] = new ProgramParameter(new byte[4]);
                programParameterArray[3].setParameterType(2);
            }
            catch (PropertyVetoException propertyVetoException) {
                if (!Trace.traceOn_) break block22;
                Trace.log(2, propertyVetoException);
            }
        }
        object4 = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZLSTFX.SRVPGM", "QpzListPTF", 0, programParameterArray);
        boolean bl2 = ((ProgramCall)object4).isStayOnThread();
        object3 = bl2 ? USERSPACE_PATH : this.system_;
        object2 = null;
        object = object3;
        synchronized (object) {
            UserSpace userSpace = new UserSpace(this.system_, USERSPACE_PATH);
            userSpace.setMustUseProgramCall(true);
            if (!bl2) {
                userSpace.setMustUseSockets(true);
            }
            try {
                userSpace.create(262144, true, "", (byte)0, "User space for PTF list", "*EXCLUDE");
                if (!((ServiceProgramCall)object4).run()) {
                    AS400Message[] aS400MessageArray = ((ProgramCall)object4).getMessageList();
                    if (aS400MessageArray.length == 1 && (aS400MessageArray[0].getID().equalsIgnoreCase("CPF6601") || aS400MessageArray[0].getID().equalsIgnoreCase("CPF35BE"))) {
                        PTF[] pTFArray = new PTF[]{};
                        return pTFArray;
                    }
                    throw new AS400Exception(((ProgramCall)object4).getMessageList());
                }
                int n = userSpace.getLength();
                object2 = new byte[n];
                userSpace.read((byte[])object2, 0);
            }
            finally {
                try {
                    userSpace.delete();
                }
                catch (Exception exception) {
                    Trace.log(2, "Exception while deleting temporary user space", (Throwable)exception);
                }
            }
        }
        int n = BinaryConverter.byteArrayToInt((byte[])object2, 124);
        int n2 = BinaryConverter.byteArrayToInt((byte[])object2, 132);
        int n3 = BinaryConverter.byteArrayToInt((byte[])object2, 136);
        int n4 = BinaryConverter.byteArrayToInt((byte[])object2, 140);
        convTable = ConvTable.getTable(n4, null);
        int n5 = 0;
        PTF[] pTFArray = new PTF[n2];
        int n6 = 0;
        while (n6 < n2) {
            n5 = n + n6 * n3;
            String string = convTable.byteArrayToString((byte[])object2, n5, 7);
            String string2 = convTable.byteArrayToString((byte[])object2, n5 += 7, 6);
            String string3 = convTable.byteArrayToString((byte[])object2, n5 += 6, 4);
            String string4 = convTable.byteArrayToString((byte[])object2, n5 += 4, 4);
            n5 += 4;
            String string5 = convTable.byteArrayToString((byte[])object2, n5++, 1);
            boolean bl3 = object2[n5++] == -15;
            boolean bl4 = object2[n5++] == -15;
            boolean bl5 = object2[n5++] == -15;
            int n7 = object2[n5++] & 0xF;
            boolean bl6 = object2[n5++] == -15;
            String string6 = convTable.byteArrayToString((byte[])object2, n5++, 1);
            String string7 = convTable.byteArrayToString((byte[])object2, n5++, 1);
            boolean bl7 = object2[n5++] == -15;
            String string8 = convTable.byteArrayToString((byte[])object2, n5, 2);
            String string9 = convTable.byteArrayToString((byte[])object2, n5 += 2, 2);
            String string10 = convTable.byteArrayToString((byte[])object2, n5 += 2, 13);
            Date date = null;
            if (string10.trim().length() == 13) {
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.set(Integer.parseInt(string10.substring(0, 3)) + 1900, Integer.parseInt(string10.substring(3, 5)) - 1, Integer.parseInt(string10.substring(5, 7)), Integer.parseInt(string10.substring(7, 9)), Integer.parseInt(string10.substring(9, 11)), Integer.parseInt(string10.substring(11, 13)));
                date = calendar.getTime();
            }
            pTFArray[n6] = new PTF(this.system_, this.productID_, string, string2, string3, string4, string5, bl3, bl4, bl5, n7, bl6, string6, string7, bl7, string8, string9, date);
            ++n6;
        }
        return pTFArray;
    }

    public String getRegistrationType() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.registrationType_;
    }

    public String getRegistrationValue() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.registrationValue_;
    }

    public Date getReleaseDate() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded500_) {
            this.refresh(500);
        }
        return this.releaseDate_;
    }

    public String getReleaseLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.releaseLevel_.equals(PRODUCT_RELEASE_CURRENT) || this.releaseLevel_.equals(PRODUCT_RELEASE_PREVIOUS) || this.releaseLevel_.equals(PRODUCT_RELEASE_ONLY) || this.releaseLevel_.equals(PRODUCT_RELEASE_ANY)) {
            this.refresh(100);
        }
        return this.releaseLevel_;
    }

    public int getRequirementsMet() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.requirementsMet_;
    }

    public String getSymbolicLoadState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.getSymbolicLoadState(true);
    }

    private String getSymbolicLoadState(boolean bl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100, bl);
        }
        return this.symbolicLoadState_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public boolean isInstalled() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.partiallyLoaded_) {
            return this.installed_;
        }
        try {
            return this.getSymbolicLoadState(false).equals(SYMBOLIC_LOAD_STATE_INSTALLED);
        }
        catch (AS400Exception aS400Exception) {
            AS400Message[] aS400MessageArray = aS400Exception.getAS400MessageList();
            if (aS400MessageArray.length == 1 && aS400MessageArray[0].getID().equalsIgnoreCase("CPF0C1F")) {
                return false;
            }
            throw aS400Exception;
        }
    }

    public boolean isLoadInError() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_) {
            this.refresh(100);
        }
        return this.loadErrorIndicator_;
    }

    public boolean isSupported() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.loaded_ && !this.partiallyLoaded_) {
            this.refresh(100);
        }
        return this.supported_;
    }

    public boolean refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.loadedLoadID_ = false;
        if (!this.error500_ && !this.error100_) {
            this.refresh(500);
        }
        if (!this.error800_ && !this.error100_) {
            this.refresh(800);
        }
        if (this.error500_ && this.error800_ && !this.error100_) {
            this.refresh(100);
        }
        if (!this.error500_) {
            this.loadedDescriptionText_ = false;
            this.getDescriptionText();
        }
        this.fillInOptionInformation();
        return !this.error100_;
    }

    private void refresh(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.refresh(n, true);
    }

    private void refresh(int n, boolean bl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n2;
        Object object;
        block38: {
            if (this.releaseLevel_.equals(PRODUCT_RELEASE_ANY)) {
                this.error100_ = false;
                this.releaseLevel_ = PRODUCT_RELEASE_ONLY;
                try {
                    this.refresh(n);
                    return;
                }
                catch (AS400Exception aS400Exception) {
                    if (!this.error100_) break block38;
                    this.error100_ = false;
                    this.releaseLevel_ = PRODUCT_RELEASE_PREVIOUS;
                    try {
                        this.refresh(n);
                        return;
                    }
                    catch (AS400Exception aS400Exception2) {
                        if (!this.error100_) break block38;
                        this.error100_ = false;
                        this.releaseLevel_ = PRODUCT_RELEASE_CURRENT;
                        this.refresh(n);
                        return;
                    }
                }
            }
        }
        String string = null;
        int n3 = 0;
        switch (n) {
            case 100: {
                if (this.error100_) {
                    return;
                }
                string = "PRDR0100";
                n3 = 108;
                break;
            }
            case 500: {
                if (this.error500_) {
                    return;
                }
                string = "PRDR0500";
                n3 = 157 + this.chunkSize_;
                break;
            }
            case 800: {
                if (this.error800_) {
                    return;
                }
                string = "PRDR0800";
                n3 = 125 + this.chunkSize_;
                break;
            }
            default: {
                string = "PRDR0100";
                n = 100;
                n3 = 108;
            }
        }
        int n4 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n4, null);
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        programParameterArray[0] = new ProgramParameter(n3);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray(string));
        byte[] byArray = new byte[36];
        AS400Text aS400Text = new AS400Text(4, n4, this.system_);
        AS400Text aS400Text2 = new AS400Text(6, n4, this.system_);
        AS400Text aS400Text3 = new AS400Text(7, n4, this.system_);
        AS400Text aS400Text4 = new AS400Text(10, n4, this.system_);
        aS400Text3.toBytes(this.productID_, byArray, 0);
        aS400Text2.toBytes(this.releaseLevel_, byArray, 7);
        String string2 = this.productOption_;
        if (string2.equals(PRODUCT_OPTION_BASE) || n == 500) {
            string2 = "0000";
        }
        aS400Text.toBytes(string2, byArray, 13);
        aS400Text4.toBytes(this.loadID_ == null || n == 500 ? "*CODE" : this.loadID_, byArray, 17);
        BinaryConverter.intToByteArray(36, byArray, 28);
        BinaryConverter.intToByteArray(n4, byArray, 32);
        programParameterArray[3] = new ProgramParameter(byArray);
        programParameterArray[4] = bl ? new ErrorCodeParameter() : new ErrorCodeParameter(true, false);
        programParameterArray[5] = new ProgramParameter(convTable.stringToByteArray("PRDI0200"));
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QSZRTVPR.PGM", programParameterArray);
        boolean bl2 = programCall.run();
        AS400Message[] aS400MessageArray = null;
        if (bl) {
            if (!bl2) {
                aS400MessageArray = programCall.getMessageList();
            }
        } else {
            object = (ErrorCodeParameter)programParameterArray[4];
            String string3 = ((ErrorCodeParameter)object).getMessageID();
            if (string3 != null) {
                bl2 = false;
                try {
                    String string4 = ((ErrorCodeParameter)object).getSubstitutionData();
                    MessageFile messageFile = new MessageFile(this.system_, "/QSYS.LIB/QCPFMSG.MSGF");
                    AS400Message aS400Message = messageFile.getMessage(string3, string4);
                    aS400MessageArray = new AS400Message[]{aS400Message};
                }
                catch (Throwable throwable) {
                    Trace.log(2, "Error when retrieving error messages.", throwable);
                }
            }
        }
        if (!bl2) {
            if (aS400MessageArray.length == 1 && aS400MessageArray[0].getID().equalsIgnoreCase("CPF0C1F")) {
                if (Trace.traceOn_) {
                    Trace.log(1, "No product definition found for " + this.toString() + " using format " + n + ".");
                }
                this.installed_ = false;
                if (n != 100) {
                    this.refresh(100);
                    if (n == 500) {
                        this.releaseDate_ = null;
                        this.firstCopyright_ = null;
                        this.currentCopyright_ = null;
                        this.options_ = new Product[0];
                        this.loaded500_ = true;
                        this.error500_ = true;
                    } else if (n == 800) {
                        this.directories_ = new ProductDirectoryInformation[0];
                        this.loaded500_ = true;
                        this.error800_ = true;
                    }
                    return;
                }
                this.error100_ = true;
            }
            throw new AS400Exception(aS400MessageArray);
        }
        object = programParameterArray[0].getOutputData();
        int n5 = BinaryConverter.byteArrayToInt((byte[])object, 0);
        if (n5 < (n2 = BinaryConverter.byteArrayToInt((byte[])object, 4))) {
            this.chunkSize_ = n2;
            this.refresh(n);
            return;
        }
        this.releaseLevel_ = convTable.byteArrayToString((byte[])object, 19, 6);
        if (n != 500) {
            this.loadID_ = convTable.byteArrayToString((byte[])object, 29, 4);
            this.loadedLoadID_ = true;
        }
        this.loadType_ = convTable.byteArrayToString((byte[])object, 33, 10).trim();
        this.symbolicLoadState_ = convTable.byteArrayToString((byte[])object, 43, 10);
        this.loadErrorIndicator_ = !convTable.byteArrayToString((byte[])object, 53, 10).trim().equals("*NONE");
        this.loadState_ = convTable.byteArrayToString((byte[])object, 63, 2);
        this.supported_ = convTable.byteArrayToString((byte[])object, 65, 1).equals("1");
        this.registrationType_ = convTable.byteArrayToString((byte[])object, 66, 2);
        this.registrationValue_ = convTable.byteArrayToString((byte[])object, 68, 14);
        this.primaryLanguageLoadID_ = convTable.byteArrayToString((byte[])object, 88, 4);
        this.minimumTargetRelease_ = convTable.byteArrayToString((byte[])object, 92, 6);
        this.minimumBaseVRM_ = convTable.byteArrayToString((byte[])object, 98, 6);
        this.requirementsMet_ = object[104] & 0xF;
        this.level_ = convTable.byteArrayToString((byte[])object, 105, 3);
        this.loaded_ = true;
        if (n == 500) {
            Object object2;
            int n6 = BinaryConverter.byteArrayToInt((byte[])object, 84);
            this.allowsMultipleReleases_ = object[n6++] == -15;
            boolean bl3 = object[n6++] == -15;
            String string5 = convTable.byteArrayToString((byte[])object, n6, 6);
            Date date = null;
            if (string5.trim().length() == 6) {
                object2 = Calendar.getInstance();
                ((Calendar)object2).clear();
                ((Calendar)object2).set(Integer.parseInt(string5.substring(0, 2)) + (bl3 ? 2000 : 1900), Integer.parseInt(string5.substring(2, 4)) - 1, Integer.parseInt(string5.substring(4, 6)));
                date = ((Calendar)object2).getTime();
            }
            this.releaseDate_ = date;
            this.firstCopyright_ = convTable.byteArrayToString((byte[])object, n6 += 6, 4);
            this.currentCopyright_ = convTable.byteArrayToString((byte[])object, n6 += 4, 4).trim();
            object2 = convTable.byteArrayToString((byte[])object, n6 += 4, 10).trim();
            String string6 = convTable.byteArrayToString((byte[])object, n6 += 10, 10).trim();
            this.messageFile_ = ((String)object2).length() > 0 ? QSYSObjectPathName.toPath(string6, (String)object2, "MSGF") : "";
            int n7 = BinaryConverter.byteArrayToInt((byte[])object, n6 += 10);
            int n8 = BinaryConverter.byteArrayToInt((byte[])object, n6 += 4);
            int n9 = BinaryConverter.byteArrayToInt((byte[])object, n6 += 4);
            this.allowsMixedReleases_ = object[n6 += 4] == -15;
            this.options_ = new Product[n7];
            for (int i = 0; i < n7; ++i) {
                n6 = n9 + n8 * i;
                String string7 = convTable.byteArrayToString((byte[])object, n6, 4);
                boolean bl4 = object[n6 += 4] == -15;
                String string8 = convTable.byteArrayToString((byte[])object, ++n6, 7);
                String string9 = convTable.byteArrayToString((byte[])object, n6 += 7, 6);
                this.options_[i] = new Product(this.system_, this.productID_, string7, this.releaseLevel_, this.getFeatureID(), bl4, string8, string9);
            }
            this.loaded500_ = true;
        } else if (n == 800) {
            boolean bl5;
            int n10 = BinaryConverter.byteArrayToInt((byte[])object, 84);
            int n11 = BinaryConverter.byteArrayToInt((byte[])object, n10);
            if (n11 == 0) {
                this.directories_ = new ProductDirectoryInformation[0];
                return;
            }
            int n12 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 4);
            int n13 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 4);
            int n14 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 4);
            n10 += 4;
            boolean bl6 = bl5 = object[n10++] == -16;
            if (!bl5) {
                n4 = n14;
                convTable = ConvTable.getTable(n4, null);
            }
            ProductDirectoryInformation[] productDirectoryInformationArray = new ProductDirectoryInformation[n11];
            for (int i = 0; i < n11; ++i) {
                n10 = n13 + i * n12;
                int n15 = BinaryConverter.byteArrayToInt((byte[])object, n10);
                int n16 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 4);
                int n17 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 12);
                int n18 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 4);
                int n19 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 12);
                int n20 = BinaryConverter.byteArrayToInt((byte[])object, n10 += 4);
                String string10 = convTable.byteArrayToString((byte[])object, n10 += 4, 10);
                String string11 = convTable.byteArrayToString((byte[])object, n16, n15);
                String string12 = convTable.byteArrayToString((byte[])object, n18, n17);
                String[] stringArray = new String[n19];
                for (int j = 0; j < n19; ++j) {
                    stringArray[j] = convTable.byteArrayToString((byte[])object, n20 + j * 10, 10);
                }
                productDirectoryInformationArray[i] = new ProductDirectoryInformation(string10, string11, string12, stringArray);
            }
            this.directories_ = productDirectoryInformationArray;
            this.loaded800_ = true;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.productID_);
        stringBuffer.append('/');
        stringBuffer.append(this.productOption_);
        stringBuffer.append('/');
        stringBuffer.append(this.releaseLevel_);
        return stringBuffer.toString();
    }
}

