/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConnectionPoolEventSupport;
import com.ibm.as400.access.ConnectionPoolException;
import com.ibm.as400.access.ConnectionPoolListener;
import com.ibm.as400.access.ConnectionPoolProperties;
import com.ibm.as400.access.PoolMaintenance;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public abstract class ConnectionPool
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int CCSID_DEFAULT = -1;
    ConnectionPoolProperties properties_ = new ConnectionPoolProperties();
    private boolean inUse_ = false;
    private boolean isRunMaintenance_ = true;
    transient PoolMaintenance maintenance_;
    transient PropertyChangeSupport changes_;
    transient ConnectionPoolEventSupport poolListeners_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionPoolListener(ConnectionPoolListener connectionPoolListener) {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.poolListeners_ == null) {
                this.poolListeners_ = new ConnectionPoolEventSupport();
            }
        }
        this.poolListeners_.addConnectionPoolListener(connectionPoolListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.addPropertyChangeListener(propertyChangeListener);
            this.properties_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    abstract void cleanupConnections();

    public abstract void close() throws ConnectionPoolException;

    protected void finalize() throws Throwable {
        if (this.maintenance_ != null && this.maintenance_.isAlive()) {
            this.maintenance_.shutdown();
        }
        super.finalize();
    }

    int getCCSID() {
        return this.properties_.getCCSID();
    }

    public long getCleanupInterval() {
        return this.properties_.getCleanupInterval();
    }

    public int getMaxConnections() {
        return this.properties_.getMaxConnections();
    }

    public long getMaxInactivity() {
        return this.properties_.getMaxInactivity();
    }

    public long getMaxLifetime() {
        return this.properties_.getMaxLifetime();
    }

    public int getMaxUseCount() {
        return this.properties_.getMaxUseCount();
    }

    public long getMaxUseTime() {
        return this.properties_.getMaxUseTime();
    }

    private void initializeTransient() {
    }

    boolean isInUse() {
        return this.inUse_;
    }

    public boolean isRunMaintenance() {
        return this.isRunMaintenance_;
    }

    public boolean isThreadUsed() {
        return this.properties_.isThreadUsed();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
        this.properties_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeConnectionPoolListener(ConnectionPoolListener connectionPoolListener) {
        if (this.poolListeners_ != null) {
            this.poolListeners_.removeConnectionPoolListener(connectionPoolListener);
        }
    }

    abstract void runMaintenance(boolean var1);

    void setCCSID(int n) {
        this.properties_.setCCSID(n);
    }

    public void setCleanupInterval(long l) {
        this.properties_.setCleanupInterval(l);
        this.runMaintenance(false);
        if (l == 0L) {
            this.setRunMaintenance(false);
        }
    }

    void setInUse(boolean bl) {
        this.inUse_ = bl;
    }

    public void setMaxConnections(int n) {
        int n2 = this.getMaxConnections();
        this.properties_.setMaxConnections(n);
        boolean bl = n2 == -1 || n2 > n;
        this.runMaintenance(bl);
    }

    public void setMaxInactivity(long l) {
        this.properties_.setMaxInactivity(l);
    }

    public void setMaxLifetime(long l) {
        this.properties_.setMaxLifetime(l);
    }

    public void setMaxUseCount(int n) {
        this.properties_.setMaxUseCount(n);
    }

    public void setMaxUseTime(long l) {
        this.properties_.setMaxUseTime(l);
    }

    public void setRunMaintenance(boolean bl) {
        String string = "runMaintenance";
        boolean bl2 = this.isRunMaintenance_;
        this.isRunMaintenance_ = bl;
        if (this.changes_ != null) {
            this.changes_.firePropertyChange(string, new Boolean(bl2), new Boolean(bl));
        }
        if (this.maintenance_ != null) {
            this.maintenance_.setRunning(bl);
        }
    }

    public void setThreadUsed(boolean bl) {
        this.properties_.setThreadUsed(bl, this.isInUse());
    }
}

