/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.util.Hashtable;

abstract class AS400Server {
    protected int connectionID_;
    static Hashtable[] replyStreamsHashTables = new Hashtable[]{new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable(), new Hashtable()};

    AS400Server() {
    }

    final int getConnectionID() {
        return this.connectionID_;
    }

    static final int getServerId(String string) {
        if ("as-central".equals(string)) {
            return 57344;
        }
        if ("as-file".equals(string)) {
            return 57346;
        }
        if ("as-netprt".equals(string)) {
            return 57347;
        }
        if ("as-database".equals(string)) {
            return 57348;
        }
        if ("as-dtaq".equals(string)) {
            return 57351;
        }
        if ("as-rmtcmd".equals(string)) {
            return 57352;
        }
        if ("as-signon".equals(string)) {
            return 57353;
        }
        Trace.log(2, "Invalid service name: " + string);
        throw new InternalErrorException(6);
    }

    static final int getServerId(int n) {
        switch (n) {
            case 6: {
                return 57344;
            }
            case 0: {
                return 57346;
            }
            case 1: {
                return 57347;
            }
            case 4: {
                return 57348;
            }
            case 3: {
                return 57351;
            }
            case 2: {
                return 57352;
            }
            case 7: {
                return 57353;
            }
        }
        Trace.log(2, "Invalid service:", n);
        throw new InternalErrorException(6);
    }

    static int getServiceId(String string) {
        if (string.equals("as-file")) {
            return 0;
        }
        if (string.equals("as-netprt")) {
            return 1;
        }
        if (string.equals("as-rmtcmd")) {
            return 2;
        }
        if (string.equals("as-dtaq")) {
            return 3;
        }
        if (string.equals("as-ddm")) {
            return 5;
        }
        if (string.equals("as-database")) {
            return 4;
        }
        if (string.equals("as-central")) {
            return 6;
        }
        if (string.equals("as-signon")) {
            return 7;
        }
        Trace.log(2, "Invalid service: " + string);
        throw new InternalErrorException(6);
    }

    static void addReplyStream(DataStream dataStream, String string) {
        AS400Server.addReplyStream(dataStream, AS400Server.getServiceId(string));
    }

    static void addReplyStream(DataStream dataStream, int n) {
        replyStreamsHashTables[n].put(dataStream, dataStream);
    }

    abstract int getService();

    abstract String getJobString();

    abstract boolean isConnected();

    abstract DataStream getExchangeAttrReply();

    abstract DataStream sendExchangeAttrRequest(DataStream var1) throws IOException, InterruptedException;

    abstract void addInstanceReplyStream(DataStream var1);

    abstract void clearInstanceReplyStreams();

    abstract DataStream sendAndReceive(DataStream var1) throws IOException, InterruptedException;

    abstract void sendAndDiscardReply(DataStream var1) throws IOException;

    abstract int send(DataStream var1) throws IOException;

    abstract int newCorrelationId();

    abstract void send(DataStream var1, int var2) throws IOException;

    abstract DataStream receive(int var1) throws IOException, InterruptedException;

    abstract void forceDisconnect();
}

