/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBColumnDescriptorsDataFormat;
import com.ibm.as400.access.DBExtendedColumnDescriptors;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDRow;
import com.ibm.as400.access.SQLData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class AS400JDBCResultSetMetaData
implements ResultSetMetaData {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final int SQL_UNSEARCHABLE = 240;
    private static final int SQL_LIKE_ONLY = 241;
    private static final int SQL_ALL_EXCEPT_LIKE = 242;
    private static final int SQL_SEARCHABLE = 243;
    private static final int SQL_READ_ONLY = 240;
    private static final int SQL_WRITE_CAPABLE = 241;
    private static final int SQL_READ_WRITE_UNKNOWN = 242;
    private String catalog_;
    private int concurrency_;
    private String cursorName_;
    private JDRow row_;
    private DBExtendedColumnDescriptors extendedColumnDescriptors_;
    private ConvTable convTable_;
    private Connection con_;

    AS400JDBCResultSetMetaData(String string, int n, String string2, JDRow jDRow, DBExtendedColumnDescriptors dBExtendedColumnDescriptors, ConvTable convTable, Connection connection) {
        this.catalog_ = string;
        this.concurrency_ = n;
        this.cursorName_ = string2;
        this.row_ = jDRow;
        this.extendedColumnDescriptors_ = dBExtendedColumnDescriptors;
        this.convTable_ = convTable;
        this.con_ = connection;
    }

    private void checkIndex(int n) throws SQLException {
        if (n < 1 || n > this.row_.getFieldCount()) {
            JDError.throwSQLException(this, "07009");
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkIndex(n);
        return this.catalog_;
    }

    public String getColumnClassName(int n) throws SQLException {
        this.checkIndex(n);
        SQLData sQLData = this.row_.getSQLType(n);
        String string = sQLData.getObject().getClass().getName();
        return string;
    }

    public int getColumnCount() throws SQLException {
        return this.row_.getFieldCount();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getDisplaySize();
    }

    public String getColumnLabel(int n) throws SQLException {
        String string;
        DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat;
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null && (dBColumnDescriptorsDataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(n, this.convTable_)) != null && (string = dBColumnDescriptorsDataFormat.getColumnLabel(this.convTable_)) != null) {
            return string;
        }
        return this.row_.getFieldName(n);
    }

    public String getColumnName(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getFieldName(n);
    }

    public int getColumnType(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getType();
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getTypeName();
    }

    public int getPrecision(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getPrecision();
    }

    public int getScale(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).getScale();
    }

    public String getSchemaName(int n) throws SQLException {
        DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat;
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null && (dBColumnDescriptorsDataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(n, this.convTable_)) != null) {
            return dBColumnDescriptorsDataFormat.getBaseTableSchemaName(this.convTable_);
        }
        return "";
    }

    public String getTableName(int n) throws SQLException {
        DBColumnDescriptorsDataFormat dBColumnDescriptorsDataFormat;
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null && (dBColumnDescriptorsDataFormat = this.extendedColumnDescriptors_.getColumnDescriptors(n, this.convTable_)) != null) {
            return dBColumnDescriptorsDataFormat.getBaseTableName(this.convTable_);
        }
        return "";
    }

    /*
     * Loose catch block
     */
    public boolean isAutoIncrement(int n) throws SQLException {
        ResultSet resultSet;
        Statement statement;
        block14: {
            this.checkIndex(n);
            statement = null;
            resultSet = null;
            statement = this.con_.prepareStatement("SELECT identity_generation FROM QSYS2" + this.getCatalogSeparator() + "SYSCOLUMNS" + " WHERE identity_generation is not null" + " AND column_name = ?" + " AND table_name = ?" + " AND table_schema = ?");
            statement.setString(1, this.getColumnName(n));
            statement.setString(2, this.getTableName(n));
            statement.setString(3, this.getSchemaName(n));
            resultSet = statement.executeQuery();
            if (!resultSet.next()) break block14;
            boolean bl = true;
            Object var6_7 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (statement != null) {
                statement.close();
            }
            return bl;
        }
        boolean bl = false;
        Object var6_8 = null;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (statement != null) {
            statement.close();
        }
        return bl;
        catch (SQLException sQLException) {
            try {
                throw sQLException;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var6_9 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (statement == null) break block17;
                    statement.close();
                }
                throw throwable;
            }
        }
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).isText();
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkIndex(n);
        return false;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        this.checkIndex(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.isNullable(n);
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null) {
            return this.extendedColumnDescriptors_.getUpdateable(n) == -16;
        }
        return this.concurrency_ == 1007;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkIndex(n);
        if (this.extendedColumnDescriptors_ != null) {
            return this.extendedColumnDescriptors_.getSearchable(n) != -16;
        }
        return true;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkIndex(n);
        return this.row_.getSQLType(n).isSigned();
    }

    public boolean isWritable(int n) throws SQLException {
        return !this.isReadOnly(n);
    }

    public String toString() {
        return this.cursorName_;
    }

    private String getCatalogSeparator() throws SQLException {
        String string = ((AS400JDBCConnection)this.con_).getProperties().equals(9, "sql") ? "." : "/";
        return string;
    }
}

