/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCClobLocatorOutputStream;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.AS400JDBCWriter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.ReaderInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class AS400JDBCClobLocator
implements Clob {
    private ConvTable converter_;
    JDLobLocator locator_;
    Object savedObject_;
    int savedScale_;
    private char[] cache_;
    private int cacheOffset_;
    private static final char[] INIT_CACHE = new char[0];
    private int maxLength_;
    private boolean isXML_ = false;

    AS400JDBCClobLocator(JDLobLocator jDLobLocator, ConvTable convTable, Object object, int n) {
        this.locator_ = jDLobLocator;
        this.converter_ = convTable;
        this.savedObject_ = object;
        this.savedScale_ = n;
        this.maxLength_ = this.locator_.getMaxLength();
    }

    AS400JDBCClobLocator(JDLobLocator jDLobLocator, ConvTable convTable, Object object, int n, boolean bl) {
        this(jDLobLocator, convTable, object, n);
        this.isXML_ = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        if (this.locator_ == null) {
            return;
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            this.locator_.free();
            this.locator_ = null;
            this.converter_ = null;
            this.savedObject_ = null;
            this.cache_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            try {
                return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid(), this.converter_.bidiStringType_, this.isXML_), 819);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            try {
                return new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid(), this.converter_.bidiStringType_, this.isXML_);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
                return null;
            }
        }
    }

    int getHandle() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        return this.locator_.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSubString(long l, int n) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            String string;
            int n2;
            int n3 = (int)l - 1;
            if (n3 < 0 || n < 0 || (long)(n3 + n) > this.length()) {
                JDError.throwSQLException(this, "HY024");
            }
            if ((n2 = (int)this.length() - n3) < 0) {
                return "";
            }
            if (n2 > n) {
                n2 = n;
            }
            if (!this.isXML_) {
                DBLobData dBLobData = this.locator_.retrieveData(n3, n2);
                int n4 = dBLobData.getLength();
                return this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), n4);
            }
            ConvTableReader convTableReader = null;
            try {
                convTableReader = new ConvTableReader((InputStream)new AS400JDBCInputStream(this.locator_), this.converter_.getCcsid(), this.converter_.bidiStringType_, this.isXML_);
                convTableReader.skip(n3);
                string = convTableReader.read(n2);
            }
            catch (Exception exception) {
                JDError.throwSQLException((Object)this, "HY000", exception);
                String string2 = null;
                return string2;
            }
            return string;
            finally {
                try {
                    convTableReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            return this.locator_.getLength();
        }
    }

    private void initCache() {
        this.cacheOffset_ = 0;
        this.cache_ = INIT_CACHE;
    }

    private int getCachedChar(int n) throws SQLException {
        int n2 = n - this.cacheOffset_;
        if (n2 >= this.cache_.length) {
            int n3 = 1000000;
            int n4 = (int)this.length();
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            if (n3 + n > n4) {
                n3 = n4 - n;
            }
            this.cache_ = this.getSubString(n + 1, n3).toCharArray();
            this.cacheOffset_ = n;
            n2 = 0;
        }
        if (this.cache_.length == 0) {
            return -1;
        }
        return this.cache_[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String string, long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n = (int)l - 1;
            if (string == null || n < 0 || (long)n >= this.length()) {
                JDError.throwSQLException(this, "HY024");
            }
            char[] cArray = string.toCharArray();
            int n2 = (int)this.length() - cArray.length;
            this.initCache();
            for (int i = n; i <= n2; ++i) {
                int n3 = 0;
                int n4 = this.getCachedChar(i + n3);
                while (n3 < cArray.length && n4 != -1 && cArray[n3] == n4) {
                    n4 = this.getCachedChar(i + ++n3);
                }
                if (n3 != cArray.length) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(Clob clob, long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n;
            int n2;
            int n3 = (int)l - 1;
            if (clob == null || n3 < 0 || (long)n3 >= this.length()) {
                JDError.throwSQLException(this, "HY024");
            }
            if ((n2 = (int)clob.length()) > (n = (int)this.length()) || n2 < 0) {
                return -1L;
            }
            int n4 = n - n2;
            char[] cArray = clob.getSubString(1L, n2).toCharArray();
            this.initCache();
            for (int i = n3; i <= n4; ++i) {
                int n5 = 0;
                int n6 = this.getCachedChar(i + n5);
                while (n5 < n2 && n6 != -1 && cArray[n5] == n6) {
                    n6 = this.getCachedChar(i + ++n5);
                }
                if (n5 != n2) continue;
                return i + 1;
            }
            return -1L;
        }
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if (l <= 0L || l > (long)this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        try {
            return new AS400JDBCClobLocatorOutputStream(this, l, ConvTable.getTable(819, null));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException("HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        if (l <= 0L || l > (long)this.maxLength_) {
            JDError.throwSQLException(this, "HY024");
        }
        return new AS400JDBCWriter(this, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long l, String string) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            Object[] objectArray;
            int n;
            char[] cArray;
            int n2;
            int n3 = (int)l - 1;
            if (n3 < 0 || n3 >= this.maxLength_ || string == null) {
                JDError.throwSQLException(this, "HY024");
            }
            if ((n2 = n3 + (cArray = string.toCharArray()).length) < 0) {
                n2 = Integer.MAX_VALUE;
            }
            if ((n = n2 - n3) != cArray.length) {
                objectArray = cArray;
                cArray = new char[n2];
                System.arraycopy(objectArray, 0, cArray, 0, n);
            }
            objectArray = this.converter_.stringToByteArray(cArray, 0, cArray.length);
            this.locator_.writeData((long)n3, (byte[])objectArray, false);
            return cArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n3;
            int n4;
            int n5 = (int)l - 1;
            if (n5 < 0 || n5 >= this.maxLength_ || string == null || n < 0 || n2 < 0 || n + n2 > string.length() || n5 + n2 > this.maxLength_) {
                JDError.throwSQLException(this, "HY024");
            }
            if ((n4 = n5 + n2) < 0) {
                n4 = Integer.MAX_VALUE;
            }
            int n6 = (n3 = n4 - n5) < n2 ? n3 : n2;
            char[] cArray = new char[n6];
            string.getChars(n, n + n3, cArray, 0);
            byte[] byArray = this.converter_.stringToByteArray(cArray, 0, cArray.length);
            this.locator_.writeData((long)n5, byArray, false);
            return cArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        if (this.locator_ == null) {
            JDError.throwSQLException(this, "HY010");
        }
        JDLobLocator jDLobLocator = this.locator_;
        synchronized (jDLobLocator) {
            int n = (int)l;
            if (n < 0 || n > this.maxLength_) {
                JDError.throwSQLException(this, "HY024");
            }
            this.locator_.writeData(n, new byte[0], 0, 0, true);
        }
    }
}

