/*
 * Decompiled with CFR 0.152.
 */
package unused;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Global
extends ImporterTopLevel {
    static final long serialVersionUID = 4029130780977538005L;
    NativeArray history;
    private InputStream inStream;
    private PrintStream outStream;
    private PrintStream errStream;
    private boolean sealedStdLib = false;
    boolean initialized;

    public Global() {
    }

    public Global(Context cx) {
        this.init(cx);
    }

    public void init(ContextFactory factory) {
        factory.call(new ContextAction(){

            public Object run(Context cx) {
                Global.this.init(cx);
                return null;
            }
        });
    }

    public void init(Context cx) {
        this.initStandardObjects(cx, this.sealedStdLib);
        String[] names = new String[]{"defineClass", "help", "print", "readFile", "readUrl", "toint32", "version"};
        this.defineFunctionProperties(names, Global.class, 2);
        this.history = (NativeArray)cx.newArray((Scriptable)this, 0);
        this.defineProperty("history", this.history, 2);
        this.initialized = true;
    }

    public static void help(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        PrintStream out = Global.getInstance(funObj).getOut();
        out.println(ToolErrorReporter.getMessage((String)"msg.help"));
    }

    public static Object print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        PrintStream out = Global.getInstance(funObj).getOut();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                out.print(" ");
            }
            String s = Context.toString((Object)args[i]);
            out.print(s);
        }
        out.println();
        return Context.getUndefinedValue();
    }

    public static double version(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double result = cx.getLanguageVersion();
        if (args.length > 0) {
            double d = Context.toNumber((Object)args[0]);
            cx.setLanguageVersion((int)d);
        }
        return result;
    }

    public static void defineClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Class<?> clazz = Global.getClass(args);
        ScriptableObject.defineClass((Scriptable)thisObj, clazz);
    }

    private static Class<?> getClass(Object[] args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object wrapped;
        if (args.length == 0) {
            throw Global.reportRuntimeError("msg.expected.string.arg");
        }
        Object arg0 = args[0];
        if (arg0 instanceof Wrapper && (wrapped = ((Wrapper)arg0).unwrap()) instanceof Class) {
            return (Class)wrapped;
        }
        String className = Context.toString((Object)args[0]);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw Global.reportRuntimeError("msg.class.not.found", className);
        }
    }

    public static Object readFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        if (args.length == 0) {
            throw Global.reportRuntimeError("msg.shell.readFile.bad.args");
        }
        String path = ScriptRuntime.toString((Object)args[0]);
        String charCoding = null;
        if (args.length >= 2) {
            charCoding = ScriptRuntime.toString((Object)args[1]);
        }
        return Global.readUrl(path, charCoding, true);
    }

    public static Object readUrl(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        if (args.length == 0) {
            throw Global.reportRuntimeError("msg.shell.readUrl.bad.args");
        }
        String url = ScriptRuntime.toString((Object)args[0]);
        String charCoding = null;
        if (args.length >= 2) {
            charCoding = ScriptRuntime.toString((Object)args[1]);
        }
        return Global.readUrl(url, charCoding, false);
    }

    public static Object toint32(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg;
        Object object = arg = args.length != 0 ? args[0] : Undefined.instance;
        if (arg instanceof Integer) {
            return arg;
        }
        return ScriptRuntime.wrapInt((int)ScriptRuntime.toInt32((Object)arg));
    }

    public InputStream getIn() {
        return this.inStream == null ? System.in : this.inStream;
    }

    public void setIn(InputStream in) {
        this.inStream = in;
    }

    public PrintStream getOut() {
        return this.outStream == null ? System.out : this.outStream;
    }

    public void setOut(PrintStream out) {
        this.outStream = out;
    }

    public PrintStream getErr() {
        return this.errStream == null ? System.err : this.errStream;
    }

    public void setErr(PrintStream err) {
        this.errStream = err;
    }

    public void setSealedStdLib(boolean value) {
        this.sealedStdLib = value;
    }

    private static Global getInstance(Function function) {
        Scriptable scope = function.getParentScope();
        if (!(scope instanceof Global)) {
            throw Global.reportRuntimeError("msg.bad.shell.function.scope", String.valueOf(scope));
        }
        return (Global)scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl(String filePath, String charCoding, boolean urlIsFile) throws IOException {
        InputStream is = null;
        try {
            int chunkLength;
            if (!urlIsFile) {
                String type;
                URL urlObj = new URL(filePath);
                URLConnection uc = urlObj.openConnection();
                is = uc.getInputStream();
                chunkLength = uc.getContentLength();
                if (chunkLength <= 0) {
                    chunkLength = 1024;
                }
                if (charCoding == null && (type = uc.getContentType()) != null) {
                    charCoding = Global.getCharCodingFromType(type);
                }
            } else {
                File f = new File(filePath);
                long length = f.length();
                chunkLength = (int)length;
                if ((long)chunkLength != length) {
                    throw new IOException("Too big file size: " + length);
                }
                if (chunkLength == 0) {
                    String string = "";
                    return string;
                }
                is = new FileInputStream(f);
            }
            InputStreamReader r = charCoding == null ? new InputStreamReader(is) : new InputStreamReader(is, charCoding);
            String string = Global.readReader(r, chunkLength);
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    private static String getCharCodingFromType(String type) {
        int i = type.indexOf(59);
        if (i >= 0) {
            int end = type.length();
            ++i;
            while (i != end && type.charAt(i) <= ' ') {
                ++i;
            }
            String charset = "charset";
            if (charset.regionMatches(true, 0, type, i, charset.length())) {
                i += charset.length();
                while (i != end && type.charAt(i) <= ' ') {
                    ++i;
                }
                if (i != end && type.charAt(i) == '=') {
                    ++i;
                    while (i != end && type.charAt(i) <= ' ') {
                        ++i;
                    }
                    if (i != end) {
                        while (type.charAt(end - 1) <= ' ') {
                            --end;
                        }
                        return type.substring(i, end);
                    }
                }
            }
        }
        return null;
    }

    private static String readReader(Reader reader, int initialBufferSize) throws IOException {
        int n;
        char[] buffer = new char[initialBufferSize];
        int offset = 0;
        while ((n = reader.read(buffer, offset, buffer.length - offset)) >= 0) {
            if ((offset += n) != buffer.length) continue;
            char[] tmp = new char[buffer.length * 2];
            System.arraycopy(buffer, 0, tmp, 0, offset);
            buffer = tmp;
        }
        return new String(buffer, 0, offset);
    }

    static RuntimeException reportRuntimeError(String msgId) {
        String message = ToolErrorReporter.getMessage((String)msgId);
        return Context.reportRuntimeError((String)message);
    }

    static RuntimeException reportRuntimeError(String msgId, String msgArg) {
        String message = ToolErrorReporter.getMessage((String)msgId, (String)msgArg);
        return Context.reportRuntimeError((String)message);
    }
}

