/*
 * Decompiled with CFR 0.152.
 */
package rhino;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class File
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private java.io.File file;
    private BufferedReader reader;
    private PrintStream writer;

    public String getClassName() {
        return "File";
    }

    public String jsGet_name() {
        return this.name;
    }

    public Object jsFunction_readLines() throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = this.jsFunction_readLine()) != null) {
            lines.add(line);
        }
        Object[] linesArray = lines.toArray();
        Scriptable scope = ScriptableObject.getTopLevelScope((Scriptable)this);
        Context cx = Context.getCurrentContext();
        return cx.newObject(scope, "Array", linesArray);
    }

    public boolean jsFunction_exists() {
        return this.file.exists();
    }

    public Long jsFunction_lastModified() {
        return this.file.lastModified();
    }

    public void jsFunction_remove() {
        if (this.file != null) {
            this.file.delete();
        }
    }

    public String jsFunction_readAsOneBigString() throws IOException {
        int byteCount = (int)this.file.length();
        byte[] buffer = new byte[byteCount];
        DataInputStream input = new DataInputStream(new FileInputStream(this.file));
        input.readFully(buffer);
        String results = new String(buffer);
        return results;
    }

    public String jsFunction_readLine() throws IOException {
        return this.getReader().readLine();
    }

    public String jsFunction_readChar() throws IOException {
        int i = this.getReader().read();
        if (i == -1) {
            return null;
        }
        char[] charArray = new char[]{(char)i};
        return new String(charArray);
    }

    public void jsFunction_close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        } else if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void finalize() {
        try {
            this.jsFunction_close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object jsFunction_getReader() {
        if (this.reader == null) {
            return null;
        }
        Scriptable parent = ScriptableObject.getTopLevelScope((Scriptable)this);
        return Context.javaToJS((Object)this.reader, (Scriptable)parent);
    }

    public Object jsFunction_getWriter() {
        if (this.writer == null) {
            return null;
        }
        Scriptable parent = ScriptableObject.getTopLevelScope((Scriptable)this);
        return Context.javaToJS((Object)this.writer, (Scriptable)parent);
    }

    private BufferedReader getReader() throws FileNotFoundException {
        if (this.writer != null) {
            throw Context.reportRuntimeError((String)("already writing file \"" + this.name + "\""));
        }
        if (this.reader == null) {
            this.reader = this.file == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(this.file));
        }
        return this.reader;
    }

    public void jsFunction_write(String s) throws IOException {
        this.write0(s, false);
    }

    public void jsFunction_writeString(String s) throws IOException {
        this.write0(s, true);
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        File result = new File();
        if (args.length == 0 || args[0] == Context.getUndefinedValue()) {
            result.name = "";
            result.file = null;
        } else {
            result.name = Context.toString((Object)args[0]);
            result.file = new java.io.File(result.name);
        }
        return result;
    }

    private void write0(String string, boolean eol) throws IOException {
        if (this.reader != null) {
            throw Context.reportRuntimeError((String)("already writing file \"" + this.name + "\""));
        }
        if (this.writer == null) {
            this.writer = this.file == null ? System.out : new PrintStream(new FileOutputStream(this.file));
        }
        this.writer.print(string);
        if (eol) {
            this.writer.println();
        }
        this.writer.flush();
    }
}

