/*
 * Decompiled with CFR 0.152.
 */
package playground;

import net.model3.logging.LogHelper;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.newfile.File;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class ParseJavascript {
    public static void main(String[] args) throws Exception {
        new SimpleLoggingConfigurator().addConsoleAppender();
        Parser parser = new Parser(new CompilerEnvirons(), (ErrorReporter)new MyErrorReporter());
        File sourceFile = new File("./source/jsx/com/myjsx/dom/Component.js");
        System.out.println("--- original ---");
        System.out.println(sourceFile.readText());
        ScriptOrFnNode script = parser.parse(sourceFile.readText(), sourceFile.getCanonicalPath(), 0);
        script.toString();
        System.out.println("\n\n--- parsed ---");
        System.out.println(ParseJavascript.rebuildSource((Node)script));
    }

    static String rebuildSource(Node node) throws Exception {
        Node next;
        Node first;
        StringBuilder sb = new StringBuilder();
        if (node.getClass().getName().endsWith("StringNode")) {
            sb.append(node.getString());
            if (node.getType() == 37) {
                sb.append(".");
            }
        } else if (node.getClass().getName().endsWith("NumberNode")) {
            sb.append(node.getDouble());
        } else if (node instanceof FunctionNode) {
            sb.append(((FunctionNode)node).getFunctionName());
            sb.append("(");
        } else {
            node.toString();
        }
        if ((first = node.getFirstChild()) != null) {
            sb.append(ParseJavascript.rebuildSource(first));
        }
        if ((next = node.getNext()) != null) {
            sb.append(ParseJavascript.rebuildSource(next));
        }
        if (node.getClass().getName().endsWith("FunctionNode")) {
            sb.append(")");
        }
        return sb.toString();
    }

    static class MyErrorReporter
    implements ErrorReporter {
        MyErrorReporter() {
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            LogHelper.getLog().error(new Object[]{"{}({},{}) - " + message + "\n source = {}", sourceName, line, lineOffset, lineSource});
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            LogHelper.getLog().error(new Object[]{"{}({},{}) - " + message + "\n source = {}", sourceName, line, lineOffset, lineSource});
            return null;
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            LogHelper.getLog().warn(new Object[]{"{}({},{}) - " + message + "\n source = {}", sourceName, line, lineOffset, lineSource});
        }
    }
}

