/*
 * Decompiled with CFR 0.152.
 */
package ide;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.model3.swing.GuiHelper;

public class DeveloperGui {
    JTextArea _textArea;

    public static void main(String[] args) {
        new DeveloperGui().run();
    }

    void run() {
        this._textArea = new JTextArea();
        GuiHelper.createFrame((JComponent)new JScrollPane(this._textArea));
        this._textArea.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (DeveloperGui.this.isControlSpace(e)) {
                    DeveloperGui.this.showContentAssistPopup();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    boolean isControlSpace(KeyEvent e) {
        return e.isControlDown() && e.getKeyCode() == 32;
    }

    void showContentAssistPopup() {
        int cursorPosition = this._textArea.getCaretPosition();
        String sourceCode = this._textArea.getText();
        JPopupMenu popupMenu = this.createSamplePopupMenu();
        popupMenu.setLocation(this._textArea.getCaret().getMagicCaretPosition());
        int x = this._textArea.getCaret().getMagicCaretPosition().x;
        int y = this._textArea.getCaret().getMagicCaretPosition().y;
        popupMenu.show(this._textArea, x, y);
    }

    JPopupMenu createSamplePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        popup.add(this.createMenuItem("item1"));
        popup.add(this.createMenuItem("item2"));
        popup.addSeparator();
        popup.add(this.createMenuItem("item3"));
        return popup;
    }

    JMenuItem createMenuItem(final String itemLabel) {
        JMenuItem menuItem = new JMenuItem(itemLabel);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cursorPosition = DeveloperGui.this._textArea.getCaretPosition();
                String sourceCode = DeveloperGui.this._textArea.getText();
                String beforeCaret = sourceCode.substring(0, cursorPosition);
                String afterCaret = sourceCode.substring(cursorPosition);
                String newSourceCode = beforeCaret + itemLabel + afterCaret;
                DeveloperGui.this._textArea.setText(newSourceCode);
                DeveloperGui.this._textArea.getCaret().setDot(cursorPosition + itemLabel.length());
            }
        });
        return menuItem;
    }
}

