/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.Int8;
import com.jniwrapper.IntBool;
import com.jniwrapper.LongInt;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.ShortInt;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastError;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Msg;
import com.jniwrapper.win32.Point;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.FlashInfo;
import com.jniwrapper.win32.ui.PaintStruct;
import com.jniwrapper.win32.ui.User32;
import com.jniwrapper.win32.ui.WindowMessageListener;
import com.jniwrapper.win32.ui.WindowProc;
import com.jniwrapper.win32.ui.WindowTools;
import com.jniwrapper.win32.ui.a;
import com.jniwrapper.win32.ui.d;
import java.awt.Component;
import java.util.List;

public class Wnd
extends Handle {
    private WindowProc f;
    private WindowMessageListener d;
    public static final int GW_HWNDFIRST = 0;
    public static final int GW_HWNDLAST = 1;
    public static final int GW_HWNDNEXT = 2;
    public static final int GW_HWNDPREV = 3;
    public static final int GW_OWNER = 4;
    public static final int GW_CHILD = 5;
    private static final FunctionName j = new FunctionName("FindWindow");
    private static final FunctionName a = new FunctionName("FindWindowEx");
    private static final FunctionName c = new FunctionName("CreateWindowEx");
    private static final FunctionName e = new FunctionName("GetClassName");
    private static final FunctionName l = new FunctionName("SetWindowLong");
    private static final FunctionName i = new FunctionName("GetWindowLong");
    private static final FunctionName k = new FunctionName("PeekMessage");
    private static final FunctionName o = new FunctionName("SendMessage");
    private static final FunctionName h = new FunctionName("PostMessage");
    private static final FunctionName n = new FunctionName("CallWindowProc");
    private static final FunctionName m = new FunctionName("GetWindowText");
    public static final String FUNCTION_GET_WINDOW_THREAD_PROCESS_ID = "GetWindowThreadProcessId";
    public static final int WS_OVERLAPPED = 0;
    public static final int WS_POPUP = Integer.MIN_VALUE;
    public static final int WS_CHILD = 0x40000000;
    public static final int WS_MINIMIZE = 0x20000000;
    public static final int WS_VISIBLE = 0x10000000;
    public static final int WS_DISABLED = 0x8000000;
    public static final int WS_CLIPSIBLINGS = 0x4000000;
    public static final int WS_CLIPCHILDREN = 0x2000000;
    public static final int WS_MAXIMIZE = 0x1000000;
    public static final int WS_CAPTION = 0xC00000;
    public static final int WS_BORDER = 0x800000;
    public static final int WS_DLGFRAME = 0x400000;
    public static final int WS_VSCROLL = 0x200000;
    public static final int WS_HSCROLL = 0x100000;
    public static final int WS_SYSMENU = 524288;
    public static final int WS_THICKFRAME = 262144;
    public static final int WS_GROUP = 131072;
    public static final int WS_TABSTOP = 65536;
    public static final int WS_MINIMIZEBOX = 131072;
    public static final int WS_MAXIMIZEBOX = 65536;
    public static final int WS_OVERLAPPEDWINDOW = 0xCF0000;
    public static final int WS_POPUPWINDOW = -2138570752;
    public static final int WS_CHILDWINDOW = 0x40000000;
    public static final int WS_TILED = 0;
    public static final int WS_ICONIC = 0x20000000;
    public static final int WS_SIZEBOX = 262144;
    public static final int WS_TILEDWINDOW = 0xCF0000;
    public static final int WS_EX_DLGMODALFRAME = 1;
    public static final int WS_EX_NOPARENTNOTIFY = 4;
    public static final int WS_EX_TOPMOST = 8;
    public static final int WS_EX_ACCEPTFILES = 16;
    public static final int WS_EX_TRANSPARENT = 32;
    public static final int WS_EX_MDICHILD = 64;
    public static final int WS_EX_TOOLWINDOW = 128;
    public static final int WS_EX_WINDOWEDGE = 256;
    public static final int WS_EX_CLIENTEDGE = 512;
    public static final int WS_EX_CONTEXTHELP = 1024;
    public static final int WS_EX_RIGHT = 4096;
    public static final int WS_EX_LEFT = 0;
    public static final int WS_EX_RTLREADING = 8192;
    public static final int WS_EX_LTRREADING = 0;
    public static final int WS_EX_LEFTSCROLLBAR = 16384;
    public static final int WS_EX_RIGHTSCROLLBAR = 0;
    public static final int WS_EX_CONTROLPARENT = 65536;
    public static final int WS_EX_STATICEDGE = 131072;
    public static final int WS_EX_APPWINDOW = 262144;
    public static final int WS_EX_OVERLAPPEDWINDOW = 768;
    public static final int WS_EX_PALETTEWINDOW = 392;
    public static final int WS_EX_LAYERED = 524288;
    public static final int LWA_COLORKEY = 1;
    public static final int LWA_ALPHA = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOZORDER = 4;
    public static final int SWP_NOREDRAW = 8;
    public static final int SWP_NOACTIVATE = 16;
    public static final int SWP_FRAMECHANGED = 32;
    public static final int SWP_SHOWWINDOW = 64;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOCOPYBITS = 256;
    public static final int SWP_NOOWNERZORDER = 512;
    public static final int SWP_NOSENDCHANGING = 1024;
    public static final int SWP_DRAWFRAME = 32;
    public static final int SWP_NOREPOSITION = 512;
    public static final int SWP_DEFERERASE = 8192;
    public static final int SWP_ASYNCWINDOWPOS = 16384;
    public static final int HWND_TOP = 0;
    public static final int HWND_BOTTOM = 1;
    public static final int HWND_TOPMOST = -1;
    public static final int HWND_NOTOPMOST = -2;
    public static final int GWL_WNDPROC = -4;
    public static final int GWL_HINSTANCE = -6;
    public static final int GWL_HWNDPARENT = -8;
    public static final int GWL_STYLE = -16;
    public static final int GWL_EXSTYLE = -20;
    public static final int GWL_USERDATA = -21;
    public static final int GWL_ID = -12;
    public static final int RDW_INVALIDATE = 1;
    public static final int RDW_INTERNALPAINT = 2;
    public static final int RDW_ERASE = 4;
    public static final int RDW_VALIDATE = 8;
    public static final int RDW_NOINTERNALPAINT = 16;
    public static final int RDW_NOERASE = 32;
    public static final int RDW_NOCHILDREN = 64;
    public static final int RDW_ALLCHILDREN = 128;
    public static final int RDW_UPDATENOW = 256;
    public static final int RDW_ERASENOW = 512;
    public static final int RDW_FRAME = 1024;
    public static final int RDW_NOFRAME = 2048;
    public static final int OPAQUE = 255;
    public static final int TRANSPARENT = 0;

    public Wnd() {
    }

    public Wnd(long l2) {
        super(l2);
    }

    public Wnd(Component component) {
        this(WindowTools.getWindowHandle(component));
    }

    static Function a(Object object) {
        return User32.getInstance().getFunction(object.toString());
    }

    public void eventLoop() {
        Wnd.eventLoop(this.getValue());
    }

    public static void eventLoop(long l2) {
        if (l2 == 0L) {
            throw new IllegalArgumentException("Event processing window is not available");
        }
        Function function = Wnd.a(User32.FUNCTION_GET_MESSAGE);
        Function function2 = Wnd.a("TranslateMessage");
        Function function3 = Wnd.a(User32.FUNCTION_DISPATCH_MESSAGE);
        Wnd wnd = new Wnd(l2);
        ShortInt shortInt = new ShortInt(1L);
        Msg msg = new Msg();
        UInt32 uInt32 = new UInt32(0L);
        while (shortInt.getValue() != 0L) {
            Pointer pointer = new Pointer(msg);
            function.invoke(shortInt, pointer, wnd, uInt32, uInt32);
            if (shortInt.getValue() == -1L) break;
            function2.invoke(null, pointer);
            function3.invoke(null, pointer);
        }
    }

    public static Wnd findWindow(String string, String string2) {
        Function function = Wnd.a(j);
        Wnd wnd = new Wnd();
        Parameter parameter = string2 == null ? new Handle() : new Str(string2);
        Str str = new Str(string);
        function.invoke(wnd, new Pointer(str), parameter);
        return wnd;
    }

    public static Wnd findWindowEx(Wnd wnd, String string, String string2) {
        Function function = Wnd.a(a);
        Wnd wnd2 = new Wnd();
        Parameter parameter = string2 == null ? new Handle() : new Str(string2);
        Str str = new Str(string);
        function.invoke(wnd2, wnd != null ? wnd : new Handle(), new Handle(), new Pointer(str), new Pointer(parameter));
        return wnd2;
    }

    public static Wnd findWindow(String string) {
        return Wnd.findWindow(string, null);
    }

    public static Wnd findWindowByName(String string) {
        Function function = Wnd.a(j);
        Wnd wnd = new Wnd();
        function.invoke(wnd, new Pointer(null, true), new Str(string));
        return wnd;
    }

    public static Wnd getDesktopWindow() {
        Function function = Wnd.a("GetDesktopWindow");
        Wnd wnd = new Wnd();
        function.invoke(wnd);
        return wnd;
    }

    private static Wnd a(Object object, Parameter[] parameterArray) {
        Wnd wnd = new Wnd();
        Function function = Wnd.a(object);
        long l2 = function.invoke((Parameter)wnd, parameterArray);
        if (wnd.getValue() == 0L) {
            throw new LastErrorException(l2, "Cannot create window.");
        }
        return wnd;
    }

    public static Wnd createWindow(String string, String string2, int n2, long l2, long l3, long l4, long l5, Wnd wnd, Handle handle, Handle handle2, Handle handle3) {
        return Wnd.a(c, new Parameter[]{new UInt(0L), new Str(string), new Str(string2), new Int(n2), new Int(l2), new Int(l3), new Int(l4), new Int(l5), wnd, handle, handle2, handle3});
    }

    public static Wnd createWindow(int n2, String string, String string2, int n3, long l2, long l3, long l4, long l5, Wnd wnd, Handle handle, Handle handle2, Handle handle3) {
        return Wnd.a(c, new Parameter[]{new Int32(n2), new Str(string), new Str(string2), new Int(n3), new Int(l2), new Int(l3), new Int(l4), new Int(l5), wnd, handle, handle2, handle3});
    }

    public static Wnd createWindow(String string) {
        Handle handle = new Handle();
        Wnd wnd = new Wnd();
        return Wnd.createWindow(0, string, string, 0, 0L, 0L, 0L, 0L, wnd, handle, handle, handle);
    }

    public void update() {
        Function function = Wnd.a("UpdateWindow");
        Int intVal = new Int();
        long l2 = function.invoke((Parameter)intVal, this);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2, "Error updating window.");
        }
    }

    public void destroy() {
        Function function = Wnd.a("DestroyWindow");
        Int intVal = new Int();
        long l2 = function.invoke((Parameter)intVal, this);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2, "Error destroying window.");
        }
    }

    public Size getSize() {
        Size size = new Size();
        Rect rect = this.getWindowRect();
        size.setCx(rect.getRightAsInt() - rect.getLeftAsInt());
        size.setCy(rect.getBottomAsInt() - rect.getTopAsInt());
        return size;
    }

    public Size getClientSize() {
        Size size = new Size();
        Rect rect = this.getClientRect();
        size.setCx(rect.getRightAsInt() - rect.getLeftAsInt());
        size.setCy(rect.getBottomAsInt() - rect.getTopAsInt());
        return size;
    }

    public Rect getBounds() {
        Rect rect = new Rect();
        Function function = Wnd.a("GetWindowRect");
        function.invoke(null, this, new Pointer.OutOnly(rect));
        return rect;
    }

    public Rect getWindowRect() {
        Function function = Wnd.a("GetWindowRect");
        Rect rect = new Rect();
        function.invoke(null, this, new Pointer.OutOnly(rect));
        return rect;
    }

    public void centerInDesktop() {
        Rect rect = Wnd.getDesktopWindow().getWindowRect();
        Rect rect2 = this.getWindowRect();
        int n2 = (rect.getWidth() - rect2.getWidth()) / 2;
        int n3 = (rect.getHeight() - rect2.getHeight()) / 2;
        rect2.moveTo(n2, n3);
        this.moveWindow((int)rect2.getLeft(), (int)rect2.getTop(), rect2.getWidth(), rect2.getHeight(), true);
    }

    public Rect getClientRect() {
        Rect rect = new Rect();
        Function function = Wnd.a("GetClientRect");
        function.invoke(null, this, new Pointer.OutOnly(rect));
        return rect;
    }

    public void setRegion(Region region, boolean bl) {
        Function function = Wnd.a("SetWindowRgn");
        function.invoke(null, this, region == null ? new Handle() : region, new Bool(bl));
    }

    public Region getRegion() {
        Region region = new Region();
        Function function = Wnd.a("GetWindowRgn");
        function.invoke(null, this, region);
        return region;
    }

    public boolean setPosition(Wnd wnd, long l2, long l3, long l4, long l5, long l6) {
        Function function = Wnd.a("SetWindowPos");
        IntBool intBool = new IntBool();
        long l7 = function.invoke((Parameter)intBool, new Parameter[]{this, wnd, new Int(l2), new Int(l3), new Int(l4), new Int(l5), new UInt(l6)});
        if (intBool.getValue() == 0L) {
            throw new LastErrorException(l7, "Failed to show splash.", true);
        }
        return true;
    }

    public DC beginPaint(PaintStruct paintStruct) {
        Function function = Wnd.a("BeginPaint");
        DC dC = new DC();
        long l2 = function.invoke(dC, this, new Pointer.OutOnly(paintStruct));
        if (dC.isNull()) {
            throw new LastErrorException(l2, "Failed to get DC.", true);
        }
        return dC;
    }

    public void endPaint(PaintStruct paintStruct) {
        Function function = User32.getInstance().getFunction("EndPaint");
        function.invoke(null, this, new Pointer.Const(paintStruct));
    }

    public boolean sendMessage(int n2, long l2, long l3) {
        Function function = Wnd.a(o);
        Bool bool = new Bool();
        function.invoke(bool, this, new UInt(n2), new LongInt(l2), new LongInt(l3));
        return bool.getValue();
    }

    public long sendMessageEx(int n2, long l2, long l3) {
        Function function = Wnd.a(o);
        LongInt longInt = new LongInt();
        function.invoke(longInt, this, new UInt(n2), new LongInt(l2), new LongInt(l3));
        return longInt.getValue();
    }

    public boolean peekMessage(long l2, boolean bl) {
        return this.peekMessage(new Msg(), l2, l2, bl);
    }

    public boolean peekMessage(Msg msg, long l2, long l3, boolean bl) {
        Function function = Wnd.a(k);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{new Pointer(msg), this, new UInt(l2), new UInt(l3), new UInt(bl ? 1L : 0L)});
        return bool.getValue();
    }

    public boolean postMessage(int n2, long l2, long l3) {
        Function function = Wnd.a(h);
        Bool bool = new Bool();
        function.invoke(bool, this, new UInt(n2), new UInt32(l2), new UInt32(l3));
        return bool.getValue();
    }

    public void show(ShowWindowCommand showWindowCommand) {
        Function function = Wnd.a("ShowWindow");
        function.invoke(null, this, new Int(showWindowCommand.getValue()));
    }

    public void setWindowLong(int n2, long l2) {
        this.setWindowLong(n2, new UInt(l2));
    }

    public long setWindowLong(int n2, Parameter parameter) {
        UInt uInt = new UInt();
        Function function = Wnd.a(l);
        LastError.setValue(0);
        long l2 = function.invoke(uInt, this, new Int(n2), parameter);
        if (uInt.getValue() == 0L && l2 != 0L) {
            throw new LastErrorException(l2);
        }
        return uInt.getValue();
    }

    public long getWindowLong(int n2) {
        Function function = Wnd.a(i);
        UInt uInt = new UInt();
        function.invoke(uInt, this, new Int(n2));
        return uInt.getValue();
    }

    public void setLayeredWindowAttributes(ColorRef colorRef, byte by, int n2) {
        Function function = Wnd.a("SetLayeredWindowAttributes");
        function.invoke(null, this, colorRef == null ? new ColorRef(0L) : colorRef, new Int8(by), new UInt32(n2));
    }

    public boolean getLayeredWindowAttributes(ColorRef colorRef, Int8 int8, UInt32 uInt32) {
        Function function = Wnd.a("GetLayeredWindowAttributes");
        Int32 int32 = new Int32();
        function.invoke(int32, this, colorRef == null ? new Pointer.Void(0L) : new Pointer.OutOnly(colorRef), int8 == null ? new Pointer.Void(0L) : new Pointer.OutOnly(int8), uInt32 == null ? new Pointer.Void(0L) : new Pointer.OutOnly(uInt32));
        return int32.getValue() != 0L;
    }

    public void redraw(Rect rect, Region region, int n2) {
        Function function = Wnd.a("RedrawWindow");
        function.invoke(null, this, new Pointer(rect, rect == null), region == null ? new Region() : region, new UInt(n2));
    }

    public void setParent(Wnd wnd) {
        Function function = Wnd.a("SetParent");
        Wnd wnd2 = new Wnd();
        long l2 = function.invoke(wnd2, this, wnd);
        if (wnd2.isNull()) {
            throw new LastErrorException(l2);
        }
    }

    public Wnd getParent() {
        Function function = Wnd.a("GetParent");
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd, this);
        return wnd;
    }

    public void bringToTop() {
        Function function = Wnd.a("BringWindowToTop");
        function.invoke(null, this);
    }

    public void setForeground() {
        Function function = Wnd.a("SetForegroundWindow");
        function.invoke(null, this);
    }

    public static long callWindowProc(Handle handle, Wnd wnd, UInt uInt, UInt32 uInt32, UInt32 uInt322) {
        Function function = Wnd.a(n);
        UInt32 uInt323 = new UInt32();
        function.invoke((Parameter)uInt323, new Parameter[]{handle, wnd, uInt, uInt32, uInt322});
        return uInt323.getValue();
    }

    public void moveWindow(int n2, int n3, int n4, int n5, boolean bl) {
        Function function = Wnd.a("MoveWindow");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Int(n2), new Int(n3), new Int(n4), new Int(n5), new Bool(bl)});
    }

    public void moveWindow(int n2, int n3, int n4, int n5) {
        this.moveWindow(n2, n3, n4, n5, false);
    }

    public boolean getUpdateRect(Rect rect, boolean bl) {
        Function function = Wnd.a("GetUpdateRect");
        Bool bool = new Bool();
        function.invoke(bool, this, new Pointer.OutOnly(rect), new Bool(bl));
        return bool.getValue();
    }

    public boolean getUpdateRect(Rect rect) {
        return this.getUpdateRect(rect, false);
    }

    public boolean flashWindow(FlashInfo flashInfo) {
        Function function = Wnd.a("FlashWindowEx");
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Pointer(flashInfo));
        return bool.getValue();
    }

    public String getWindowClassName() {
        Str str = new Str();
        Function function = User32.getInstance().getFunction(e.toString());
        function.invoke(null, this, str, new Int(str.getMaxLength()));
        return str.getValue();
    }

    public Wnd getWindow(int n2) {
        Wnd wnd = new Wnd();
        User32.getInstance().getFunction("GetWindow").invoke(wnd, this, new UInt(n2));
        return wnd;
    }

    public Object clone() {
        return new Wnd(this.getValue());
    }

    public Point screenToClient(Point point) {
        Function function = User32.getInstance().getFunction("ScreenToClient");
        Bool bool = new Bool();
        Point point2 = new Point(point);
        long l2 = function.invoke(bool, this, new Pointer(point2));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        return point2;
    }

    public Point clientToScreen(Point point) {
        Function function = User32.getInstance().getFunction("ClientToScreen");
        Bool bool = new Bool();
        Point point2 = new Point(point);
        long l2 = function.invoke(bool, this, new Pointer(point2));
        if (!bool.getValue()) {
            throw new LastErrorException(l2);
        }
        return point2;
    }

    public static List getAllWindows() {
        Bool bool = new Bool();
        Int32 int32 = new Int32();
        a a2 = new a();
        Function function = User32.getInstance().getFunction("EnumWindows");
        function.invoke(bool, a2, int32);
        return a2.getWindows();
    }

    public static List getChildWindows(Wnd wnd) {
        Bool bool = new Bool();
        Int32 int32 = new Int32();
        a a2 = new a();
        Function function = User32.getInstance().getFunction("EnumChildWindows");
        function.invoke(bool, wnd, a2, int32);
        return a2.getWindows();
    }

    public List getChildWindows() {
        return Wnd.getChildWindows(this);
    }

    public static List getThreadWindows(long l2) {
        Bool bool = new Bool();
        Int32 int32 = new Int32();
        a a2 = new a();
        Function function = User32.getInstance().getFunction("EnumThreadWindows");
        function.invoke(bool, new UInt32(l2), a2, int32);
        return a2.getWindows();
    }

    public String getWindowText() {
        Function function = User32.getInstance().getFunction(m.toString());
        Str str = new Str(1024);
        Int intVal = new Int();
        function.invoke(intVal, this, new Pointer(str), new Int(1024L));
        return str.getValue();
    }

    public void setVisible(boolean bl) {
        long l2 = this.getWindowLong(-16);
        l2 = !bl ? (l2 &= 0xFFFFFFFFEFFFFFFFL) : (l2 |= 0x10000000L);
        this.setWindowLong(-16, l2);
    }

    public boolean isVisible() {
        long l2 = this.getWindowLong(-16);
        return (l2 & 0x10000000L) != 0L;
    }

    public void setWindowStyle(long l2) {
        this.setWindowLong(-16, l2);
        this.setPosition(this, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowStyle() {
        return this.getWindowLong(-16);
    }

    public void setWindowExStyle(long l2) {
        this.setWindowLong(-20, l2);
        this.setPosition(this, 0L, 0L, 0L, 0L, 39L);
    }

    public long getWindowExStyle() {
        return this.getWindowLong(-20);
    }

    public boolean isTransparent() {
        long l2 = this.getWindowExStyle();
        return (l2 & 0x80000L) != 0L;
    }

    public void setTransparent(boolean bl) {
        long l2 = this.getWindowExStyle();
        if (bl) {
            long l3 = l2 | 0x80000L;
            this.setWindowExStyle(l3);
            this.setLayeredWindowAttributes(new ColorRef(0L), this.getTransparency(), 2);
        } else {
            long l4 = l2 & 0xFFFFFFFFFFF7FFFFL;
            this.setWindowExStyle(l4);
        }
        this.redraw(null, null, 288);
    }

    public void setTransparent(byte by) {
        long l2 = this.getWindowExStyle();
        if (by != 0) {
            long l3 = l2 | 0x80000L;
            this.setWindowExStyle(l3);
            this.setLayeredWindowAttributes(new ColorRef(0L), by, 2);
        } else {
            long l4 = l2 & 0xFFFFFFFFFFF7FFFFL;
            this.setWindowExStyle(l4);
        }
        this.redraw(null, null, 288);
    }

    public byte getTransparency() {
        Int8 int8 = new Int8();
        this.getLayeredWindowAttributes(null, int8, null);
        return (byte)int8.getValue();
    }

    public void setTransparency(byte by) {
        this.setLayeredWindowAttributes(null, by, 2);
    }

    public boolean isPalleteWindow() {
        long l2 = this.getWindowExStyle();
        return (l2 & 0x188L) != 0L;
    }

    public void setPalleteWindow(boolean bl) {
        long l2 = this.getWindowExStyle();
        long l3 = bl ? l2 | 0x188L : l2 & 0xFFFFFFFFFFFFFE77L;
        this.setWindowExStyle(l3);
        this.redraw(null, null, 1025);
    }

    public void setTopmost(boolean bl) {
        int n2 = -2;
        if (bl) {
            n2 = -1;
        }
        this.setPosition(new Wnd(n2), 0L, 0L, 0L, 0L, 3L);
    }

    public void setRounded(boolean bl, int n2, int n3) {
        Region region = null;
        if (bl) {
            Rect rect = this.getWindowRect();
            rect.moveTo(0L, 0L);
            region = Region.createRoundRectRegion((int)rect.getLeft(), (int)rect.getTop(), (int)rect.getRight(), (int)rect.getBottom(), n2, n3);
        }
        this.setRegion(region, true);
    }

    public void setRounded(boolean bl) {
        this.setRounded(bl, 30, 30);
    }

    public void setWindowIcon(Icon icon, Icon.IconType iconType) {
        this.sendMessageEx(128, iconType.getValue(), (int)icon.getValue());
    }

    public void setCaptionVisible(boolean bl) {
        long l2 = this.getWindowStyle();
        long l3 = bl ? l2 | 0xC00000L : l2 & 0xFFFFFFFFFF3FFFFFL;
        this.setWindowStyle(l3);
        this.redraw(null, null, 6);
    }

    public boolean isCaptionVisible() {
        long l2 = this.getWindowStyle();
        return (l2 & 0xC00000L) != 0L;
    }

    public void setBorderVisible(boolean bl) {
        long l2 = this.getWindowStyle();
        long l3 = bl ? l2 | 0x800000L : l2 & 0xFFFFFFFFFFFBFFFFL;
        this.setWindowStyle(l3);
    }

    public boolean isBorderVisible() {
        long l2 = this.getWindowStyle();
        return (l2 & 0x800000L) != 0L;
    }

    public Region setRegion(Region region) {
        Region region2 = this.getRegion();
        this.setRegion(region, true);
        return region2;
    }

    public void setContinuousRepainting(boolean bl) {
        WindowMessageListener windowMessageListener = this.b();
        WindowProc windowProc = this.c();
        if (bl) {
            windowProc.addMessageListener(windowMessageListener);
            windowProc.substitute();
        } else {
            windowProc.removeMessageListener(windowMessageListener);
            windowProc.restoreNative();
        }
    }

    private WindowProc c() {
        if (this.f == null) {
            this.f = new WindowProc(this);
        }
        return this.f;
    }

    private WindowMessageListener b() {
        if (this.d == null) {
            this.d = new d(this);
        }
        return this.d;
    }

    public Wnd setFocus() {
        Function function = User32.getInstance().getFunction("SetFocus");
        Wnd wnd = new Wnd();
        function.invoke((Parameter)wnd, this);
        return wnd;
    }

    public static Wnd getFocus() {
        Function function = User32.getInstance().getFunction("GetFocus");
        Wnd wnd = new Wnd();
        function.invoke(wnd);
        return wnd;
    }

    public int getThreadId() {
        Function function = User32.getInstance().getFunction(FUNCTION_GET_WINDOW_THREAD_PROCESS_ID);
        UInt32 uInt32 = new UInt32();
        function.invoke(uInt32, this, new Handle());
        return (int)uInt32.getValue();
    }

    public int getProcessId() {
        Function function = User32.getInstance().getFunction(FUNCTION_GET_WINDOW_THREAD_PROCESS_ID);
        UInt32 uInt32 = new UInt32();
        UInt32 uInt322 = new UInt32();
        function.invoke(uInt32, this, new Pointer(uInt322));
        return (int)uInt322.getValue();
    }

    public void invalidateRect(Rect rect, boolean bl) {
        Function function = User32.getInstance().getFunction("InvalidateRect");
        Bool bool = new Bool();
        function.invoke(bool, this, new Pointer(rect, rect == null), new Bool(bl));
    }

    public static class ShowWindowCommand
    extends EnumItem {
        public static final ShowWindowCommand HIDE = new ShowWindowCommand(0);
        public static final ShowWindowCommand SHOWNORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand NORMAL = new ShowWindowCommand(1);
        public static final ShowWindowCommand SHOWMINIMIZED = new ShowWindowCommand(2);
        public static final ShowWindowCommand SHOWMAXIMIZED = new ShowWindowCommand(3);
        public static final ShowWindowCommand MAXIMIZE = new ShowWindowCommand(3);
        public static final ShowWindowCommand SHOWNOACTIVATE = new ShowWindowCommand(4);
        public static final ShowWindowCommand SHOW = new ShowWindowCommand(5);
        public static final ShowWindowCommand MINIMIZE = new ShowWindowCommand(6);
        public static final ShowWindowCommand SHOWMINNOACTIVE = new ShowWindowCommand(7);
        public static final ShowWindowCommand SHOWNA = new ShowWindowCommand(8);
        public static final ShowWindowCommand RESTORE = new ShowWindowCommand(9);
        public static final ShowWindowCommand SHOWDEFAULT = new ShowWindowCommand(10);
        public static final ShowWindowCommand FORCEMINIMIZE = new ShowWindowCommand(11);
        public static final ShowWindowCommand MAX = new ShowWindowCommand(11);

        protected ShowWindowCommand(int n2) {
            super(n2);
        }
    }
}

