/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.ui;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.WinFunctionCache;
import com.jniwrapper.win32.ui.Wnd;

public class User32
extends WinFunctionCache {
    public static final FunctionName FUNCTION_GET_MESSAGE = new FunctionName("GetMessage");
    public static final FunctionName FUNCTION_POST_THREAD_MESSAGE = new FunctionName("PostThreadMessage");
    public static final String FUNCTION_TRANSLATE_MESSAGE = "TranslateMessage";
    public static final FunctionName FUNCTION_DISPATCH_MESSAGE = new FunctionName("DispatchMessage");
    public static final String FUNCTION_POST_QUIT_MESSAGE = "PostQuitMessage";
    public static final String FUNCTION_CREATE_ELLIPRIC_RGN = "CreateEllipticRgn";
    public static final FunctionName FUNCTION_LOAD_IMAGE = new FunctionName("LoadImage");
    public static final String FUNCTION_CREATE_MENU = "CreateMenu";
    public static final String FUNCTION_CREATE_POPUP_MENU = "CreatePopupMenu";
    public static final String FUNCTION_SET_MENU = "SetMenu";
    public static final String FUNCTION_GET_MENU = "GetMenu";
    public static final FunctionName FUNCTION_REGISTER_CLIPBOARD_FORMAT = new FunctionName("RegisterClipboardFormat");
    public static final String FUNCTION_ATTACH_THREAD_INPUT = "AttachThreadInput";
    public static final String FUNCTION_GET_WINDOW_THREAD_PROCESS_ID = "GetWindowThreadProcessId";
    private static User32 c;

    private User32() {
        super("user32");
    }

    public static User32 getInstance() {
        if (c == null) {
            c = new User32();
        }
        return c;
    }

    public static void postQuitMessage(int n2) {
        Function function = User32.getInstance().getFunction(FUNCTION_POST_QUIT_MESSAGE);
        function.invoke(null, new Int(n2));
    }

    public static Handle loadResourceFromFile(String string, int n2) {
        return User32.loadResourceFromFile(string, n2, 0, 0);
    }

    public static Handle loadResourceFromFile(String string, int n2, int n3, int n4) {
        Function function = User32.getInstance().getFunction(FUNCTION_LOAD_IMAGE.toString());
        Handle handle = new Handle();
        long l2 = function.invoke((Parameter)handle, new Parameter[]{new Pointer(null, true), new Str(string), new UInt(n2), new Int(n3), new Int(n4), new UInt(32784L)});
        if (handle.isNull()) {
            throw new LastErrorException(l2, "Failed to load resource.", true);
        }
        return handle;
    }

    public static void setMenu(Wnd wnd, Handle handle) {
        Function function = User32.getInstance().getFunction(FUNCTION_SET_MENU);
        function.invoke(null, wnd, handle);
    }

    public static Handle getMenu(Wnd wnd) {
        Handle handle = new Handle();
        Function function = User32.getInstance().getFunction(FUNCTION_GET_MENU);
        function.invoke((Parameter)handle, wnd);
        return handle;
    }

    public static Handle createMenu() {
        Handle handle = new Handle();
        Function function = User32.getInstance().getFunction(FUNCTION_CREATE_MENU);
        function.invoke(handle);
        return handle;
    }

    public static Handle createPopupMenu() {
        Handle handle = new Handle();
        Function function = User32.getInstance().getFunction(FUNCTION_CREATE_POPUP_MENU);
        function.invoke((Parameter)handle, new Parameter[0]);
        return handle;
    }

    public static long registerClipboardFormat(String string) {
        Function function = User32.getInstance().getFunction(FUNCTION_REGISTER_CLIPBOARD_FORMAT.toString());
        UInt uInt = new UInt();
        function.invoke((Parameter)uInt, new Str(string));
        return uInt.getValue();
    }

    private static void a(int n2, int n3, boolean bl) {
        Int intVal = new Int();
        Function function = User32.getInstance().getFunction(FUNCTION_ATTACH_THREAD_INPUT);
        function.invoke(intVal, new UInt32(n2), new UInt32(n3), new Bool(bl));
        if (intVal.getValue() == 0L) {
            throw new RuntimeException("Failed to attach thread input. Tried to attach thread: " + n2 + " to thread: " + n3);
        }
    }

    public static void attachThreadInput(int n2, int n3) {
        User32.a(n2, n3, true);
    }

    public static void detachThreadInput(int n2, int n3) {
        User32.a(n2, n3, false);
    }
}

