/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.UInt;
import com.jniwrapper.ULongInt;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.system.Kernel32;
import com.jniwrapper.win32.system.MemoryAllocationAttributes;

public class GlobalMemoryBlock
extends Handle {
    public GlobalMemoryBlock() {
    }

    public GlobalMemoryBlock(Handle handle) {
        super(handle.getValue());
    }

    public GlobalMemoryBlock(int n2, MemoryAllocationAttributes memoryAllocationAttributes) {
        this.a(n2, memoryAllocationAttributes);
    }

    public void free() {
        GlobalMemoryBlock globalMemoryBlock = new GlobalMemoryBlock();
        Function function = Kernel32.getInstance().getFunction("GlobalFree");
        function.invoke((Parameter)globalMemoryBlock, this);
        if (!globalMemoryBlock.isNull()) {
            throw new RuntimeException("Can't free global memory block.");
        }
    }

    private void a(int n2, MemoryAllocationAttributes memoryAllocationAttributes) {
        Function function = Kernel32.getInstance().getFunction("GlobalAlloc");
        function.invoke(this, new UInt(memoryAllocationAttributes.getValue()), new ULongInt(n2));
    }

    public int size() {
        Function function = Kernel32.getInstance().getFunction("GlobalSize");
        ULongInt uLongInt = new ULongInt();
        function.invoke((Parameter)uLongInt, this);
        return (int)uLongInt.getValue();
    }

    public Handle lock() {
        Handle handle = new Handle();
        Function function = Kernel32.getInstance().getFunction("GlobalLock");
        function.invoke((Parameter)handle, this);
        return handle;
    }

    public int unlock() {
        Int intVal = new Int();
        Function function = Kernel32.getInstance().getFunction("GlobalUnlock");
        function.invoke((Parameter)intVal, this);
        return (int)intVal.getValue();
    }
}

