/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.Logger;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.registry.RegistryEventListener;
import com.jniwrapper.win32.registry.RegistryException;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import com.jniwrapper.win32.registry.b;
import com.jniwrapper.win32.registry.e;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RegistryKey
extends Handle {
    public static final RegistryKey CLASSES_ROOT = new RegistryKey(Integer.MIN_VALUE, "HKEY_CLASSES_ROOT");
    public static final RegistryKey CURRENT_USER = new RegistryKey(-2147483647L, "HKEY_CURRENT_USER");
    public static final RegistryKey LOCAL_MACHINE = new RegistryKey(-2147483646L, "HKEY_LOCAL_MACHINE");
    public static final RegistryKey USERS = new RegistryKey(-2147483645L, "HKEY_USERS");
    public static final RegistryKey PERFORMANCE_DATA = new RegistryKey(-2147483644L, "HKEY_PERFORMANCE_DATA");
    public static final RegistryKey CURRENT_CONFIG = new RegistryKey(-2147483643L, "HKEY_CURRENT_CONFIG");
    public static final RegistryKey DYN_DATA = new RegistryKey(-2147483642L, "HKEY_DYN_DATA");
    private static final Logger c = Logger.getInstance(j == null ? (j = RegistryKey.a("com.jniwrapper.win32.registry.RegistryKey")) : j);
    public static final int REG_NOTIFY_CHANGE_NAME = 1;
    public static final int REG_NOTIFY_CHANGE_ATTRIBUTES = 2;
    public static final int REG_NOTIFY_CHANGE_LAST_SET = 4;
    public static final int REG_NOTIFY_CHANGE_SECURITY = 8;
    private String i = "";
    private String d = "";
    private RegistryKey f;
    private int e = 0;
    private RegistryKeyValues h;
    private boolean a = false;
    private List k = new LinkedList();
    static Class j;

    private RegistryKey() {
    }

    private RegistryKey(long l2) {
        super(l2);
    }

    private RegistryKey(long l2, String string) {
        super(l2);
        this.d = string;
        this.f = new RegistryKey(this.getValue());
    }

    public String getName() {
        return this.d;
    }

    public String getPath() {
        return this.i;
    }

    public String getAbsolutePath() {
        String string = this.getPath();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.length() > 0 && !string.endsWith("\\")) {
            stringBuffer.append('\\');
        }
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    protected void checkError() {
        if (this.e != 0) {
            throw new RegistryException(this.e);
        }
    }

    protected void checkError(long l2) {
        this.e = (int)l2;
        this.checkError();
    }

    public int getSubKeyCount() {
        UInt32 uInt32 = new UInt32();
        this.checkError(com.jniwrapper.win32.registry.e.queryInfoKey(this, null, null, uInt32, null, null, null, null, null));
        int n2 = (int)uInt32.getValue();
        return n2;
    }

    public void close() {
        this.checkError(com.jniwrapper.win32.registry.e.closeKey(this));
    }

    public RegistryKey createSubKey(String string, boolean bl) {
        RegistryKey registryKey = new RegistryKey();
        this.checkError(com.jniwrapper.win32.registry.e.createKey(this, string, 0L, bl ? 131103L : 131097L, (Handle)registryKey));
        registryKey.i = this.getAbsolutePath();
        registryKey.d = string;
        registryKey.f = this.getRootKey();
        return registryKey;
    }

    public RegistryKey createSubKey(String string) {
        return this.createSubKey(string, false);
    }

    public void deleteSubKey(String string) {
        this.checkError(com.jniwrapper.win32.registry.e.deleteKey(this, string));
    }

    public void deleteSubTree(String string) {
        RegistryKey registryKey = this.openSubKey(string, true);
        int n2 = 0;
        Str str = new Str(260);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (com.jniwrapper.win32.registry.e.enumKeyEx(registryKey, n2++, str, new UInt32(260L), null, null) == 0L) {
            linkedList.add(str.getValue());
        }
        for (int i2 = 0; i2 < linkedList.size(); ++i2) {
            registryKey.deleteSubTree((String)linkedList.get(i2));
        }
        registryKey.close();
        this.deleteSubKey(string);
    }

    public void rename(String string) {
        String string2 = this.getAbsolutePath();
        String string3 = "";
        try {
            string3 = string2.substring(string2.indexOf("\\") + 1, string2.lastIndexOf("\\"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        RegistryKey registryKey = this.getRootKey();
        if (string3.length() != 0) {
            registryKey = registryKey.openSubKey(string3);
        }
        RegistryKey registryKey2 = this.copy(registryKey, string, false);
        String string4 = this.getName().lastIndexOf("\\") != -1 ? this.getName().substring(this.getName().lastIndexOf("\\") + 1) : this.getName();
        registryKey.deleteSubTree(string4);
        registryKey.close();
        this.setValue(registryKey2.getValue());
        this.i = registryKey2.i;
        this.d = registryKey2.d;
        this.f = registryKey2.getRootKey();
    }

    public RegistryKey getRootKey() {
        return this.f;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RegistryKey)) {
            return false;
        }
        RegistryKey registryKey = (RegistryKey)object;
        return this.getValue() == registryKey.getValue();
    }

    public int hashCode() {
        int n2 = this.i.hashCode();
        n2 = 29 * n2 + this.d.hashCode();
        n2 = 29 * n2 + this.hashCode();
        return n2;
    }

    public void flush() {
        this.checkError(com.jniwrapper.win32.registry.e.flushKey(this));
    }

    public List getSubKeyNames() {
        int n2 = this.getSubKeyCount();
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        if (n2 > 0) {
            RegistryKey registryKey = this;
            int n3 = 0;
            int n4 = 0;
            while (n4 == 0) {
                Str str = new Str("", 260);
                n4 = (int)com.jniwrapper.win32.registry.e.enumKeyEx(registryKey, n3, str, new UInt32(260L), null, null);
                if (n4 == 0) {
                    arrayList.add(str.getValue());
                }
                ++n3;
            }
        }
        return arrayList;
    }

    public String toString() {
        return this.getName();
    }

    public RegistryKey openSubKey(String string) {
        return this.openSubKey(string, false, false);
    }

    public RegistryKey openSubKey(String string, boolean bl) {
        return this.openSubKey(string, bl, false);
    }

    public RegistryKey openSubKey(String string, boolean bl, boolean bl2) {
        RegistryKey registryKey = new RegistryKey();
        registryKey.e = (int)com.jniwrapper.win32.registry.e.openKey(this, string.startsWith("\\\\") ? string.replaceFirst("\\\\+", "") : string, bl ? 131103 : 131097, registryKey);
        registryKey.i = this.getAbsolutePath();
        registryKey.d = string;
        registryKey.f = this.getRootKey();
        if (!bl2) {
            registryKey.checkError();
        }
        return registryKey;
    }

    public boolean exists(String string) {
        this.e = (int)com.jniwrapper.win32.registry.e.openKey(this, string, 131097, new Handle());
        return this.e != 2;
    }

    public RegistryKey copy(RegistryKey registryKey, String string, boolean bl) {
        if (registryKey == null) {
            throw new IllegalArgumentException("newBase parameter cannot be null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("newName parameter cannot be null.");
        }
        RegistryKey registryKey2 = new RegistryKey();
        UInt32 uInt32 = new UInt32();
        RegistryKey registryKey3 = registryKey;
        this.checkError(com.jniwrapper.win32.registry.e.createKey(registryKey3, string, 0L, 131103L, registryKey2, uInt32));
        registryKey2.i = this.i;
        registryKey2.d = string;
        registryKey2.f = this.getRootKey();
        if (uInt32.getValue() == 2L && !bl) {
            throw new RegistryException("The specified registry key already exists.");
        }
        int n2 = 0;
        Str str = new Str(260);
        while (com.jniwrapper.win32.registry.e.enumKeyEx(this, n2++, str, new UInt32(260L), null, null) == 0L) {
            this.openSubKey(str.getValue()).copy(registryKey, registryKey2.getName() + "\\" + str.getValue(), true);
        }
        List list = this.values().getEntries();
        RegistryKeyValues registryKeyValues = registryKey2.values();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            RegistryKeyValues.RegistryValueEntry registryValueEntry = (RegistryKeyValues.RegistryValueEntry)list.get(i2);
            registryKeyValues.put(registryValueEntry.getKey(), registryValueEntry.getValue(), registryValueEntry.getType());
        }
        return registryKey2;
    }

    public List getSubkeys() {
        List list = this.getSubKeyNames();
        LinkedList<RegistryKey> linkedList = new LinkedList<RegistryKey>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                RegistryKey registryKey = this.openSubKey(string);
                linkedList.add(registryKey);
            }
            catch (RegistryException registryException) {
                c.error("Failed to read the registry key " + this.getAbsolutePath() + '\\' + string, registryException);
                RegistryKey registryKey = this.openSubKey(string, false, true);
                linkedList.add(registryKey);
            }
        }
        return linkedList;
    }

    public RegistryKeyValues values() {
        this.b();
        if (this.h == null) {
            this.h = new RegistryKeyValues(this);
        }
        return this.h;
    }

    public Handle getHandle() {
        return this;
    }

    private void b() {
        if (this.isNull()) {
            this.checkError(com.jniwrapper.win32.registry.e.openKey(new Handle(this.getValue()), "", 131097, this));
        }
    }

    public void addRegistryEventListener(RegistryEventListener registryEventListener) {
        if (!this.k.contains(registryEventListener)) {
            this.k.add(registryEventListener);
        }
    }

    public void removeRegistryEventListener(RegistryEventListener registryEventListener) {
        this.k.remove(registryEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegistryEvent(EventObject eventObject) {
        LinkedList linkedList;
        Object object = this;
        synchronized (object) {
            linkedList = new LinkedList(this.k);
        }
        object = linkedList.iterator();
        while (object.hasNext()) {
            RegistryEventListener registryEventListener = (RegistryEventListener)object.next();
            registryEventListener.handle(eventObject);
        }
    }

    public void startChangeListening(boolean bl, int n2) {
        Thread thread = new Thread(new b(this, bl, n2));
        thread.start();
    }

    public void startChangeListening() {
        int n2 = 15;
        this.startChangeListening(true, n2);
    }

    public void stopChangeListening() {
        this.a = false;
        this.close();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static boolean a(RegistryKey registryKey, boolean bl) {
        registryKey.a = bl;
        return registryKey.a;
    }

    static boolean a(RegistryKey registryKey) {
        return registryKey.a;
    }
}

