/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.ImageUtils;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.BitmapStructure;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.DIBitmap;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.WindowDC;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilder;
import com.jniwrapper.win32.ui.User32;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class DDBitmap
extends Bitmap {
    private DC f;
    static Class d;

    public DDBitmap() {
        this.f = new WindowDC(null);
        this.setSize(0, 0);
    }

    public DDBitmap(long l2) {
        super(l2);
        this.f = new WindowDC(null);
        this.setSize(0, 0);
    }

    public DDBitmap(int n2, int n3) {
        this(new WindowDC(null), n2, n3);
    }

    public DDBitmap(DC dC, int n2, int n3) {
        this.f = dC;
        this.setSize(n2, n3);
        Function function = Gdi32.get("CreateCompatibleBitmap");
        function.invoke(this, this.f, new Int(n2), new Int(n3));
    }

    public DDBitmap(DIBitmap dIBitmap) {
        this((DC)new WindowDC(null), dIBitmap);
    }

    public DDBitmap(DC dC, DIBitmap dIBitmap) {
        this(dC, dIBitmap.getWidth(), dIBitmap.getHeight());
        PrimitiveArray primitiveArray = dIBitmap.getDIBytes();
        Function function = Gdi32.getInstance().getFunction("CreateDIBitmap");
        function.invoke((Parameter)this, new Parameter[]{dC, new Pointer(dIBitmap.getDIBSection().getBitmapInfoHeader()), new UInt32(4L), new Pointer(primitiveArray), new Pointer(dIBitmap.getBitmapInfo()), new UInt(0L)});
    }

    public DDBitmap(String string) {
        this((DC)new WindowDC(null), string);
    }

    public DDBitmap(DC dC, String string) {
        this.f = dC;
        this.loadFromFile(string);
    }

    public DDBitmap(Image image) {
        this((DC)new WindowDC(null), image);
    }

    public DDBitmap(DC dC, Image image) {
        this(dC, image.getWidth(null), image.getHeight(null));
        BufferedImage bufferedImage = ImageUtils.createBufferedImage(image);
        this.a(bufferedImage);
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        this.setSize((int)bitmapInfo.getBitmapInfoHeader().getWidth(), (int)bitmapInfo.getBitmapInfoHeader().getHeight());
    }

    public DDBitmap(Bitmap.PredefinedBitmap predefinedBitmap) {
        this((DC)new WindowDC(null), predefinedBitmap);
    }

    public DDBitmap(DC dC, Bitmap.PredefinedBitmap predefinedBitmap) {
        this.f = dC;
        this.loadPredefinedBitmap(predefinedBitmap);
    }

    public void loadFromFile(String string) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle handle = new Handle();
        long l2 = function.invoke((Parameter)handle, new Parameter[]{new Pointer(null, true), new Str(string), new UInt(GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(32848L)});
        if (handle.isNull()) {
            throw new LastErrorException(l2, "Failed to load resource.", true);
        }
        this.setValue(handle.getValue());
        this.setSize((int)this.getBitmapStructure().getBitmapWidth(), (int)this.getBitmapStructure().getBitmapHeight());
    }

    public void loadPredefinedBitmap(Bitmap.PredefinedBitmap predefinedBitmap) {
        Function function = User32.getInstance().getFunction(User32.FUNCTION_LOAD_IMAGE.toString());
        Handle handle = new Handle();
        long l2 = function.invoke((Parameter)handle, new Parameter[]{new Pointer(null, true), new UInt32(predefinedBitmap.getValue()), new UInt(GdiObject.ImageType.BITMAP.getValue()), new Int(0L), new Int(0L), new UInt(32832L)});
        if (handle.isNull()) {
            throw new LastErrorException(l2, "Failed to load resource.", true);
        }
        this.setValue(handle.getValue());
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        this.setSize((int)bitmapInfo.getBitmapInfoHeader().getWidth(), (int)bitmapInfo.getBitmapInfoHeader().getHeight());
    }

    private void a(BufferedImage bufferedImage) {
        BitmapBuilder bitmapBuilder = _builderFactory.createBuilder(bufferedImage);
        BitmapInfo bitmapInfo = bitmapBuilder.getBitmapInfo();
        DIBitmap dIBitmap = new DIBitmap();
        this.createDIBSection(dIBitmap, new Pointer((Parameter)new Pointer(bitmapBuilder.getBitmapData())), bitmapInfo);
        bitmapBuilder.setBitmapColors();
        PrimitiveArray primitiveArray = bitmapBuilder.getBitmapData();
        dIBitmap.getDIBits(this.f, 0, this.getHeight(), new Pointer(primitiveArray), bitmapInfo, 0);
        this.setDIBits(this.f, 0, this.getHeight(), new Pointer(primitiveArray), bitmapInfo, 0);
        Image image = bitmapBuilder.getTransparentMask();
        if (image != null) {
            this.setTransparentMask(image);
        }
    }

    public BitmapInfo getBitmapInfo() {
        BitmapInfo bitmapInfo = new BitmapInfo();
        this.getDIBits(this.f, 0, 0, new Pointer(null, true), bitmapInfo, 0);
        bitmapInfo.getBitmapInfoHeader().setCompression(Bitmap.Compression.RGB);
        return bitmapInfo;
    }

    public BitmapStructure getBitmapStructure() {
        BitmapStructure bitmapStructure = new BitmapStructure();
        this.getObject(this, bitmapStructure);
        return bitmapStructure;
    }

    public BitmapInfoHeader getBitmapInfoHeader() {
        return this.getBitmapInfo().getBitmapInfoHeader();
    }

    public DIBitmap toDIBitmap() {
        BitmapInfoHeader bitmapInfoHeader = this.getBitmapInfoHeader();
        int n2 = (int)bitmapInfoHeader.getHeight();
        int n3 = (int)bitmapInfoHeader.getWidth();
        int n4 = (int)bitmapInfoHeader.getSizeImage();
        PrimitiveArray primitiveArray = new PrimitiveArray(d == null ? (d = DDBitmap.a("com.jniwrapper.UInt8")) : d, n4);
        Pointer pointer = new Pointer(primitiveArray);
        DIBitmap dIBitmap = new DIBitmap(n3, n2);
        this.createDIBSection(dIBitmap, this.f, this.getBitmapInfo(), 0, new Pointer((Parameter)pointer), new Handle(), 0);
        this.getDIBits(this.f, 0, n2, pointer, this.getBitmapInfo(), 0);
        return dIBitmap;
    }

    public PrimitiveArray getDIBytes() {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = this.getBitCount();
        Pointer pointer = new Pointer(null, true);
        this.getDIBits(this.f, 0, n2, pointer, bitmapInfo, 0);
        int n5 = n2 * n3 * n4 / 8;
        PrimitiveArray primitiveArray = new PrimitiveArray(d == null ? (d = DDBitmap.a("com.jniwrapper.UInt8")) : d, n5);
        this.getDIBits(this.f, 0, n2, new Pointer(primitiveArray), bitmapInfo, 0);
        return primitiveArray;
    }

    public void setDIBytes(PrimitiveArray primitiveArray) {
        BitmapInfo bitmapInfo = this.getBitmapInfo();
        PrimitiveArray primitiveArray2 = primitiveArray;
        this.setDIBits(this.f, 0, this.getHeight(), new Pointer(primitiveArray2), bitmapInfo, 0);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

