/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.ComplexArray;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt32;
import com.jniwrapper.ULongInt;
import com.jniwrapper.UShortInt;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.Enums;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.Bitmap;
import com.jniwrapper.win32.gdi.BlendFunction;
import com.jniwrapper.win32.gdi.Brush;
import com.jniwrapper.win32.gdi.ColorRef;
import com.jniwrapper.win32.gdi.DDBitmap;
import com.jniwrapper.win32.gdi.Font;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.GradientRect;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.gdi.LogBrush;
import com.jniwrapper.win32.gdi.Msimg32;
import com.jniwrapper.win32.gdi.Pen;
import com.jniwrapper.win32.gdi.PolyFillMode;
import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.gdi.TriVertex;
import com.jniwrapper.win32.ui.User32;
import java.awt.Color;

public class DC
extends Handle {
    public static final int DC_PEN = 19;
    static final FunctionName c = new FunctionName("TextOut");
    static final FunctionName f = new FunctionName("DrawText");
    static final FunctionName a = new FunctionName("GetTextExtentPoint32");
    public static final int BKMODE_TRANSPARENT = 1;
    public static final int BKMODE_OPAQUE = 2;
    public static final int BKMODE_LAST = 2;
    public static final long GRADIENT_FILL_RECT_H = 0L;
    public static final long GRADIENT_FILL_RECT_V = 1L;
    public static final int DT_RIGHT = 2;
    static Class e;

    public DC() {
    }

    public DC(long l2) {
        super(l2);
    }

    public static DC createCompatibleDC(DC dC) {
        Function function = Gdi32.getInstance().getFunction("CreateCompatibleDC");
        DC dC2 = new DC();
        function.invoke((Parameter)dC2, dC == null ? new Pointer(null, true) : dC);
        return dC2;
    }

    private long a(GdiObject gdiObject) {
        Function function = Gdi32.get("SelectObject");
        Handle handle = new Handle();
        function.invoke(handle, this, gdiObject);
        return handle.getValue();
    }

    public Brush selectObject(Brush brush) {
        long l2 = this.a(brush);
        Brush brush2 = new Brush(l2);
        return brush2;
    }

    public Pen selectObject(Pen pen) {
        long l2 = this.a(pen);
        Pen pen2 = new Pen(l2);
        return pen2;
    }

    public Bitmap selectObject(Bitmap bitmap) {
        long l2 = this.a(bitmap);
        DDBitmap dDBitmap = new DDBitmap(l2);
        return dDBitmap;
    }

    public Font selectObject(Font font) {
        long l2 = this.a(font);
        Font font2 = new Font(l2);
        return font2;
    }

    public Region selectObject(Region region) {
        long l2 = this.a(region);
        Region region2 = new Region(l2);
        return region2;
    }

    public static void bitBlt(DC dC, int n2, int n3, int n4, int n5, DC dC2, int n6, int n7, RasterOperation rasterOperation) {
        Function function = Gdi32.get("BitBlt");
        function.invoke(null, new Parameter[]{dC, new Int(n2), new Int(n3), new Int(n4), new Int(n5), dC2, new Int(n6), new Int(n7), new UInt32(rasterOperation.getValue())});
    }

    public static boolean stretchBlt(DC dC, int n2, int n3, int n4, int n5, DC dC2, int n6, int n7, int n8, int n9, RasterOperation rasterOperation) {
        Int intVal = new Int();
        Function function = Gdi32.get("StretchBlt");
        function.invoke((Parameter)intVal, new Parameter[]{dC, new Int(n2), new Int(n3), new Int(n4), new Int(n5), dC2, new Int(n6), new Int(n7), new Int(n8), new Int(n9), new UInt32(rasterOperation.getValue())});
        return intVal.getValue() > 0L;
    }

    public boolean patBlt(int n2, int n3, int n4, int n5, RasterOperation rasterOperation) {
        Bool bool = new Bool();
        Function function = Gdi32.get("PatBlt");
        function.invoke((Parameter)bool, new Parameter[]{this, new Int(n2), new Int(n3), new Int(n4), new Int(n5), new UInt32(rasterOperation.getValue())});
        return bool.getValue();
    }

    public void release() {
        DC.deleteDC(this);
    }

    public static void deleteDC(DC dC) {
        Function function = Gdi32.get("DeleteDC");
        Int intVal = new Int();
        long l2 = function.invoke((Parameter)intVal, dC);
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public void textOut(int n2, int n3, String string) {
        Function function = Gdi32.get(c.toString());
        UShortInt uShortInt = new UShortInt();
        long l2 = function.invoke((Parameter)uShortInt, new Parameter[]{this, new Int(n2), new Int(n3), new Str(string), new Int(string.length())});
        if (uShortInt.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public void drawText(String string, Rect rect, UInt uInt) {
        Function function = User32.getInstance().getFunction(f.toString());
        Int intVal = new Int();
        long l2 = function.invoke((Parameter)intVal, new Parameter[]{this, new Str(string), new Int(string.length()), new Pointer(rect), new UInt(uInt)});
        if (intVal.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public Size getTextExtentPoint32(DC dC, String string) {
        Size size = new Size();
        Gdi32.getInstance().getFunction(a.toString()).invoke(null, new Parameter[]{this, new Str(string), new UInt(string.length()), new Pointer(size)});
        return size;
    }

    public void drawIconEx(int n2, int n3, Icon icon, int n4, int n5, int n6, Handle handle, int n7) {
        Function function = User32.getInstance().getFunction("DrawIconEx");
        UShortInt uShortInt = new UShortInt();
        long l2 = function.invoke((Parameter)uShortInt, new Parameter[]{this, new Int(n2), new Int(n3), icon, new Int(n4), new Int(n5), new UInt(n6), handle, new UInt(n7)});
        if (uShortInt.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
    }

    public boolean drawIcon(int n2, int n3, Icon icon) {
        Function function = User32.getInstance().getFunction("DrawIcon");
        Bool bool = new Bool();
        function.invoke(bool, this, new Int(n2), new Int(n3), icon);
        return bool.getValue();
    }

    public int setBkMode(int n2) {
        Function function = Gdi32.get("SetBkMode");
        UShortInt uShortInt = new UShortInt();
        long l2 = function.invoke(uShortInt, this, new Int(n2));
        if (uShortInt.getValue() == 0L) {
            throw new LastErrorException(l2);
        }
        return (int)uShortInt.getValue();
    }

    public ColorRef setBkColor(ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetBkColor");
        long l2 = function.invoke(colorRef2, this, colorRef);
        if (colorRef2.isInvalid()) {
            throw new LastErrorException(l2, "Error while changing text color");
        }
        return colorRef2;
    }

    public ColorRef setTextColor(ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetTextColor");
        long l2 = function.invoke(colorRef2, this, colorRef);
        if (colorRef2.isInvalid()) {
            throw new LastErrorException(l2, "Error while changing text color");
        }
        return colorRef2;
    }

    public void selectClipRgn(Region region) {
        Int intVal = new Int();
        Function function = Gdi32.getInstance().getFunction("SelectClipRgn");
        long l2 = function.invoke(intVal, this, region);
        if (0L == intVal.getValue()) {
            throw new LastErrorException(l2, "Failed to select region");
        }
    }

    public void fillRegion(Region region, Brush brush) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("FillRgn");
        long l2 = function.invoke(bool, this, region, brush);
        if (!bool.getValue()) {
            throw new LastErrorException(l2, "Failed to fill region");
        }
    }

    public void frameRegion(Region region, Brush brush, int n2, int n3) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("FrameRgn");
        long l2 = function.invoke((Parameter)bool, new Parameter[]{this, region, brush, new Int(n2), new Int(n3)});
        if (!bool.getValue()) {
            throw new LastErrorException(l2, "Failed to frame region");
        }
    }

    public int getPolyFillMode() {
        Int intVal = new Int();
        Function function = Gdi32.getInstance().getFunction("GetPolyFillMode");
        function.invoke((Parameter)intVal, this);
        return (int)intVal.getValue();
    }

    public boolean invertRegion(Region region) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("InvertRgn");
        function.invoke(bool, this, region);
        return bool.getValue();
    }

    public boolean paintRegion(Region region) {
        Bool bool = new Bool();
        Function function = Gdi32.getInstance().getFunction("PaintRgn");
        function.invoke(bool, this, region);
        return bool.getValue();
    }

    public void setPolyFillMode(PolyFillMode polyFillMode) {
        Function function = Gdi32.getInstance().getFunction("SetPolyFillMode");
        function.invoke(null, this, new Int(polyFillMode.getValue()));
    }

    public ColorRef getPixel(int n2, int n3) {
        ColorRef colorRef = new ColorRef();
        Function function = Gdi32.get("GetPixel");
        function.invoke(colorRef, this, new Int(n2), new Int(n3));
        return colorRef;
    }

    public static ColorRef setDCBrushColor(DC dC, ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetDCBrushColor");
        function.invoke(colorRef2, dC, colorRef);
        return colorRef2;
    }

    public ColorRef setDCPenColor(DC dC, ColorRef colorRef) {
        ColorRef colorRef2 = new ColorRef();
        Function function = Gdi32.get("SetDCPenColor");
        function.invoke(colorRef2, dC, colorRef);
        return colorRef2;
    }

    private void a(Bitmap bitmap, int n2, int n3) {
        DC dC = DC.createCompatibleDC(this);
        Bitmap bitmap2 = dC.selectObject(bitmap);
        BlendFunction blendFunction = new BlendFunction();
        blendFunction.setSourceConstantAlpha(255);
        blendFunction.setAlphaFormat(1);
        this.alphaBlend(n2, n3, bitmap.getWidth(), bitmap.getHeight(), dC, 0, 0, bitmap.getWidth(), bitmap.getHeight(), blendFunction);
        dC.selectObject(bitmap2);
        DC.deleteDC(dC);
    }

    public void transparentBlt(Bitmap bitmap, int n2, int n3) {
        if (bitmap.getBitCount() == 32) {
            this.a(bitmap, n2, n3);
        } else if (bitmap.getTransparentMask() != null) {
            this.a(bitmap, bitmap.getTransparentMask(), n2, n3);
        }
    }

    public void paintBitmap(Bitmap bitmap, int n2, int n3) {
        if (bitmap.isTransparent()) {
            this.transparentBlt(bitmap, n2, n3);
        } else {
            this.paintOpaqueBitmap(bitmap, n2, n3);
        }
    }

    public void paintOpaqueBitmap(Bitmap bitmap, int n2, int n3) {
        DC dC = DC.createCompatibleDC(this);
        Bitmap bitmap2 = dC.selectObject(bitmap);
        DC.bitBlt(this, n2, n3, bitmap.getWidth(), bitmap.getHeight(), dC, 0, 0, RasterOperation.SRCCOPY);
        dC.selectObject(bitmap2);
        DC.deleteDC(dC);
    }

    private void a(Bitmap bitmap, Bitmap bitmap2, int n2, int n3) {
        Size size = bitmap.getSize();
        DC dC = DC.createCompatibleDC(this);
        DC dC2 = DC.createCompatibleDC(this);
        DC dC3 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap = new DDBitmap(this, size.getCx(), size.getCy());
        DDBitmap dDBitmap2 = new DDBitmap(this, size.getCx(), size.getCy());
        Bitmap bitmap3 = null;
        Bitmap bitmap4 = dC2.selectObject(dDBitmap2);
        Bitmap bitmap5 = dC3.selectObject(dDBitmap);
        bitmap3 = dC.selectObject(bitmap);
        this.a(dC3, size, dC);
        dC.selectObject(bitmap2);
        this.a(dC2, size, dC);
        this.a(dC3, dC2, size);
        this.a(n2, n3, size, dC2, dC3);
        dC.selectObject(bitmap3);
        dC2.selectObject(bitmap4);
        dC3.selectObject(bitmap5);
        dDBitmap.deleteObject();
        DC.deleteDC(dC3);
        DC.deleteDC(dC2);
        DC.deleteDC(dC);
    }

    private void a(DC dC, DC dC2, Size size) {
        dC.setBkColor(new ColorRef(Color.black));
        dC.setTextColor(new ColorRef(Color.white));
        DC.bitBlt(dC, 0, 0, size.getCx(), size.getCy(), dC2, 0, 0, RasterOperation.SRCAND);
    }

    private void a(DC dC, Size size, DC dC2) {
        DC.bitBlt(dC, 0, 0, size.getCx(), size.getCy(), dC2, 0, 0, RasterOperation.SRCCOPY);
    }

    private void a(int n2, int n3, Size size, DC dC, DC dC2) {
        dC.patBlt(0, 0, size.getCx(), size.getCy(), RasterOperation.DSTINVERT);
        DC.bitBlt(this, n2, n3, size.getCx(), size.getCy(), dC, 0, 0, RasterOperation.SRCAND);
        DC.bitBlt(this, n2, n3, size.getCx(), size.getCy(), dC2, 0, 0, RasterOperation.SRCPAINT);
    }

    public boolean alphaBlend(int n2, int n3, int n4, int n5, DC dC, int n6, int n7, int n8, int n9, BlendFunction blendFunction) {
        Bool bool = new Bool();
        Msimg32.getInstance().getFunction("AlphaBlend").invoke((Parameter)bool, new Parameter[]{this, new Int(n2), new Int(n3), new Int(n4), new Int(n5), dC, new Int(n6), new Int(n7), new Int(n8), new Int(n9), blendFunction});
        return bool.getValue();
    }

    public void drawGrayed(DC dC, Rect rect) {
        int n2 = rect.getWidth();
        int n3 = rect.getHeight();
        int n4 = (int)rect.getLeft();
        int n5 = (int)rect.getTop();
        DC dC2 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap = new DDBitmap(this, n2, n3);
        Bitmap bitmap = dC2.selectObject(dDBitmap);
        DC dC3 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap2 = new DDBitmap(this, n2, n3);
        Bitmap bitmap2 = dC3.selectObject(dDBitmap2);
        DC.bitBlt(dC2, 0, 0, n2, n3, dC, 0, 0, RasterOperation.SRCCOPY);
        DC.bitBlt(this, n4 + 1, n5 + 1, n2, n3, dC2, 0, 0, RasterOperation.MERGEPAINT);
        DC.bitBlt(this, n4, n5, n2, n3, dC2, 0, 0, RasterOperation.SRCAND);
        Rect rect2 = new Rect(0L, 0L, n2, n3);
        LogBrush logBrush = new LogBrush();
        logBrush.setColor(new ColorRef(new Color(127, 127, 127)));
        Brush brush = Brush.createBrushIndirect(logBrush);
        dC3.fillRect(rect2, brush);
        brush.deleteObject();
        dC2.patBlt(0, 0, n2, n3, RasterOperation.DSTINVERT);
        DC.bitBlt(dC3, 0, 0, n2, n3, dC2, 0, 0, RasterOperation.SRCAND);
        DC.bitBlt(this, n4, n5, n2, n3, dC3, 0, 0, RasterOperation.SRCPAINT);
        dC3.selectObject(bitmap2);
        dDBitmap2.deleteObject();
        DC.deleteDC(dC3);
        dC2.selectObject(bitmap);
        dDBitmap.deleteObject();
        DC.deleteDC(dC2);
    }

    public void fillRect(Rect rect, Brush brush) {
        Region region = Region.createRectRegion(rect);
        this.fillRegion(region, brush);
        region.deleteObject();
    }

    public void maskBlt(Bitmap.PredefinedBitmap predefinedBitmap, int n2, int n3, Brush brush) {
        DC dC = DC.createCompatibleDC(this);
        DDBitmap dDBitmap = new DDBitmap(predefinedBitmap);
        Bitmap bitmap = dC.selectObject(dDBitmap);
        Size size = dDBitmap.getSize();
        int n4 = size.getCx();
        int n5 = size.getCy();
        DC dC2 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap2 = new DDBitmap(this, n4, n5);
        Bitmap bitmap2 = dC2.selectObject(dDBitmap2);
        DC dC3 = DC.createCompatibleDC(this);
        DDBitmap dDBitmap3 = new DDBitmap(this, n4, n5);
        Bitmap bitmap3 = dC3.selectObject(dDBitmap3);
        DC.bitBlt(dC2, 0, 0, n4, n5, dC, 0, 0, RasterOperation.SRCCOPY);
        DC.bitBlt(this, n2, n3, n4, n5, dC2, 0, 0, RasterOperation.SRCAND);
        dC2.patBlt(0, 0, n4, n5, RasterOperation.DSTINVERT);
        Brush brush2 = dC3.selectObject(brush);
        DC.bitBlt(dC3, 0, 0, n4, n5, dC2, 0, 0, RasterOperation.MERGECOPY);
        dC3.selectObject(brush2);
        DC.bitBlt(this, n2, n3, n4, n5, dC3, 0, 0, RasterOperation.SRCPAINT);
        dC3.selectObject(bitmap3);
        dDBitmap3.deleteObject();
        DC.deleteDC(dC3);
        dC2.selectObject(bitmap2);
        dDBitmap2.deleteObject();
        DC.deleteDC(dC2);
        dC.selectObject(bitmap);
        dDBitmap.deleteObject();
        DC.deleteDC(dC);
    }

    public boolean gradientFill(Rect rect, Color color, Color color2) {
        Function function = Msimg32.getInstance().getFunction("GradientFill");
        TriVertex triVertex = new TriVertex();
        TriVertex triVertex2 = new TriVertex();
        this.a(triVertex, color, rect.getLeft(), rect.getTop());
        this.a(triVertex2, color2, rect.getRight(), rect.getBottom());
        GradientRect gradientRect = new GradientRect();
        gradientRect.setUpperLeft(0L);
        gradientRect.setLowerRight(1L);
        ComplexArray complexArray = new ComplexArray(new TriVertex(), 2);
        complexArray.setElement(0, triVertex);
        complexArray.setElement(1, triVertex2);
        Bool bool = new Bool();
        function.invoke((Parameter)bool, new Parameter[]{this, new Pointer(complexArray), new ULongInt(2L), new Pointer(new ComplexArray(new Parameter[]{gradientRect})), new ULongInt(1L), new ULongInt(0L)});
        return bool.getValue();
    }

    private void a(TriVertex triVertex, Color color, long l2, long l3) {
        triVertex.setX(l2);
        triVertex.setY(l3);
        triVertex.setRed(color.getRed() << 8);
        triVertex.setGreen(color.getGreen() << 8);
        triVertex.setBlue(color.getBlue() << 8);
        triVertex.setAlpha(0);
    }

    public boolean lineTo(int n2, int n3) {
        Function function = Gdi32.getInstance().getFunction("LineTo");
        Bool bool = new Bool();
        function.invoke(bool, this, new Int(n2), new Int(n3));
        return bool.getValue();
    }

    public boolean moveTo(int n2, int n3) {
        Function function = Gdi32.getInstance().getFunction("MoveToEx");
        Bool bool = new Bool();
        function.invoke(bool, this, new Int(n2), new Int(n3), new Handle());
        return bool.getValue();
    }

    public boolean drawRectangle(Rect rect) {
        this.moveTo(rect.getLeftAsInt(), rect.getTopAsInt());
        this.lineTo(rect.getRightAsInt(), rect.getTopAsInt());
        this.lineTo(rect.getRightAsInt(), rect.getBottomAsInt());
        this.lineTo(rect.getLeftAsInt(), rect.getBottomAsInt());
        this.lineTo(rect.getLeftAsInt(), rect.getTopAsInt());
        return true;
    }

    public MappingMode setMapMode(MappingMode mappingMode) {
        Function function = Gdi32.get("SetMapMode");
        Int intVal = new Int();
        function.invoke(intVal, this, new Int(mappingMode.getValue()));
        MappingMode mappingMode2 = (MappingMode)Enums.getItem(e == null ? (e = DC.a("com.jniwrapper.win32.gdi.DC$MappingMode")) : e, (int)intVal.getValue());
        return mappingMode2;
    }

    public int getDeviceCaps(int n2) {
        Function function = Gdi32.get("GetDeviceCaps");
        Int intVal = new Int();
        function.invoke(intVal, this, new Int(n2));
        return (int)intVal.getValue();
    }

    public int intersectClipRect(int n2, int n3, int n4, int n5) {
        Function function = Gdi32.get("IntersectClipRect");
        Int intVal = new Int();
        function.invoke((Parameter)intVal, new Parameter[]{this, new Int(n2), new Int(n3), new Int(n4), new Int(n5)});
        return (int)intVal.getValue();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MappingMode
    extends EnumItem {
        public static MappingMode TEXT = new MappingMode(1);
        public static MappingMode LOMETRIC = new MappingMode(2);
        public static MappingMode HIMETRIC = new MappingMode(3);
        public static MappingMode LOENGLISH = new MappingMode(4);
        public static MappingMode HIENGLISH = new MappingMode(5);
        public static MappingMode TWIPS = new MappingMode(6);
        public static MappingMode ISOTROPIC = new MappingMode(7);
        public static MappingMode ANISOTROPIC = new MappingMode(8);

        private MappingMode(int n2) {
            super(n2);
        }
    }

    public static class RasterOperation
    extends EnumItem {
        public static final RasterOperation SRCCOPY = new RasterOperation(0xCC0020);
        public static final RasterOperation SRCPAINT = new RasterOperation(15597702);
        public static final RasterOperation SRCAND = new RasterOperation(8913094);
        public static final RasterOperation SRCINVERT = new RasterOperation(0x660046);
        public static final RasterOperation SRCERASE = new RasterOperation(4457256);
        public static final RasterOperation NOTSRCCOPY = new RasterOperation(0x330008);
        public static final RasterOperation NOTSRCERASE = new RasterOperation(1114278);
        public static final RasterOperation MERGECOPY = new RasterOperation(0xC000CA);
        public static final RasterOperation MERGEPAINT = new RasterOperation(12255782);
        public static final RasterOperation PATCOPY = new RasterOperation(15728673);
        public static final RasterOperation PATPAINT = new RasterOperation(16452105);
        public static final RasterOperation PATINVERT = new RasterOperation(5898313);
        public static final RasterOperation DSTINVERT = new RasterOperation(0x550009);
        public static final RasterOperation BLACKNESS = new RasterOperation(66);
        public static final RasterOperation WHITENESS = new RasterOperation(16711778);

        private RasterOperation(int n2) {
            super(n2);
        }
    }
}

