/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.PrimitiveArray;
import com.jniwrapper.UInt;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt8;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Size;
import com.jniwrapper.win32.gdi.BitmapInfo;
import com.jniwrapper.win32.gdi.BitmapInfoHeader;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.gdi.DIBitmap;
import com.jniwrapper.win32.gdi.Gdi32;
import com.jniwrapper.win32.gdi.GdiObject;
import com.jniwrapper.win32.gdi.RGBQuad;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderFactory;
import com.jniwrapper.win32.gdi.bitmap.BitmapBuilderFactoryImpl;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;

public abstract class Bitmap
extends GdiObject {
    protected static final BitmapBuilderFactory _builderFactory = new BitmapBuilderFactoryImpl();
    protected static final String FUNCTION_GET_DIBITS = "GetDIBits";
    protected static final String FUNCTION_SET_DIBITS = "SetDIBits";
    protected static final String FUNCTION_CREATEDIBITMAP = "CreateDIBitmap";
    protected static final int DIB_RGB_COLORS = 0;
    protected static final int DIB_PAL_COLORS = 1;
    protected static final int CBM_INIT = 4;
    private Dimension e;
    private DIBitmap c;

    public Bitmap() {
    }

    public Bitmap(long l2) {
        super(l2);
    }

    public long setDIBits(DC dC, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        Int intVal = new Int();
        Function function = Gdi32.get(FUNCTION_SET_DIBITS);
        function.invoke((Parameter)intVal, new Parameter[]{dC, this, new UInt(n2), new UInt(n3), pointer, new Pointer(bitmapInfo), new UInt(n4)});
        return intVal.getValue();
    }

    public long getDIBits(DC dC, int n2, int n3, Pointer pointer, BitmapInfo bitmapInfo, int n4) {
        Int intVal = new Int();
        Function function = Gdi32.get(FUNCTION_GET_DIBITS);
        function.invoke((Parameter)intVal, new Parameter[]{dC, this, new UInt(n2), new UInt(n3), pointer, new Pointer(bitmapInfo), new UInt(n4)});
        return intVal.getValue();
    }

    protected void setSize(int n2, int n3) {
        this.e = new Dimension(n2, n3);
    }

    public Size getSize() {
        return new Size(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        return (int)this.e.getWidth();
    }

    public int getHeight() {
        return (int)this.e.getHeight();
    }

    private int a(PrimitiveArray primitiveArray, int n2) {
        return (int)((UInt8)primitiveArray.getElement(n2)).getValue();
    }

    public void createDIBSection(DIBitmap dIBitmap, Pointer pointer, BitmapInfo bitmapInfo) {
        this.createDIBSection(dIBitmap, new DC(), bitmapInfo, 0, pointer, new Handle(), 0);
    }

    public void createDIBSection(DIBitmap dIBitmap, DC dC, BitmapInfo bitmapInfo, int n2, Pointer pointer, Handle handle, int n3) {
        Function function = Gdi32.get("CreateDIBSection");
        function.invoke((Parameter)dIBitmap, new Parameter[]{dC, new Pointer(bitmapInfo), new UInt16(n2), pointer, handle, new UInt(n3)});
    }

    public int getBitCount() {
        return (int)this.getBitmapInfoHeader().getBitCount();
    }

    protected void setTransparentMask(Image image) {
        this.c = new DIBitmap(image);
    }

    public Bitmap getTransparentMask() {
        return this.c;
    }

    public boolean isTransparent() {
        return this.getBitCount() == 32 || this.c != null;
    }

    public void deleteObject() {
        super.deleteObject();
        if (this.c != null) {
            this.c.deleteObject();
        }
    }

    public BufferedImage toImage() {
        int n2 = this.getBitCount();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        PrimitiveArray primitiveArray = this.getDIBytes();
        BufferedImage bufferedImage = n2 >= 4 ? this.a(this.getBitmapInfo().getColors(), n3, n4, n2, primitiveArray) : this.a(n3, n4, n2, primitiveArray);
        return bufferedImage;
    }

    private BufferedImage a(int n2, int n3, int n4, PrimitiveArray primitiveArray) {
        int n5 = -16777216;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        int n6 = 0;
        int n7 = 0;
        int n8 = (n2 * n4 + 31) / 32 * 4;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                int n9 = 0;
                switch (n4) {
                    case 1: {
                        n7 = (n3 - 1 - i2) * n8 + i3 * n4 / 8;
                        n6 = i3 * n4 % 8;
                        int n10 = this.a(primitiveArray, n7);
                        FlagSet flagSet = new FlagSet(n10);
                        boolean bl = flagSet.getBit(7 - n6);
                        n9 = !bl ? n5 : 0;
                    }
                }
                bufferedImage.setRGB(i3, i2, n9);
            }
        }
        return bufferedImage;
    }

    private BufferedImage a(PrimitiveArray primitiveArray, int n2, int n3, int n4, PrimitiveArray primitiveArray2) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        int n5 = 0;
        int n6 = 0;
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                int n8 = 0;
                switch (n4) {
                    case 4: {
                        n5 = n6 / 8;
                        int n9 = this.a(primitiveArray2, n5);
                        n9 = n6 % 8 != 0 ? (n9 &= 0xF) : (n9 >>= 4);
                        RGBQuad rGBQuad = (RGBQuad)primitiveArray.getElement(n9);
                        n6 += 4;
                        n8 = rGBQuad.getRGB();
                        break;
                    }
                    case 8: {
                        int n9 = this.a(primitiveArray2, n5++);
                        RGBQuad rGBQuad = (RGBQuad)primitiveArray.getElement(n9);
                        n8 = rGBQuad.getRGB();
                        break;
                    }
                    case 16: {
                        int n9 = this.a(primitiveArray2, n5++);
                        int n10 = this.a(primitiveArray2, n5++);
                        int n11 = n10 << 8 | n9;
                        int n12 = (n11 & 0x1F) << 3;
                        int n13 = (n11 & 0x3E0) << 6;
                        int n14 = (n11 & 0x7C00) << 9;
                        n8 = n12 | n13 | n14;
                        break;
                    }
                    case 24: 
                    case 32: {
                        int n12;
                        int n9 = this.a(primitiveArray2, n5++);
                        int n15 = this.a(primitiveArray2, n5++);
                        int n11 = this.a(primitiveArray2, n5++);
                        n8 = n9 | n15 << 8 | n11 << 16;
                        if (n4 != 32) break;
                        if ((n12 = this.a(primitiveArray2, n5++)) == 0) {
                            n12 = 255;
                        }
                        n8 |= n12 << 24;
                    }
                }
                bufferedImage.setRGB(n7, i2, n8);
            }
            if (n4 != 4) {
                n7 = (int)(4.0 * (Math.ceil((double)(n2 * n4) / 32.0) - (double)(n2 * n4) / 32.0));
                n5 += n7;
                continue;
            }
            double d2 = 4.0 * (Math.ceil((double)(n2 * n4) / 32.0) - (double)(n2 * n4) / 32.0);
            n6 += (int)(d2 * 8.0);
        }
        return bufferedImage;
    }

    public abstract BitmapInfoHeader getBitmapInfoHeader();

    public abstract BitmapInfo getBitmapInfo();

    public abstract void loadFromFile(String var1);

    public abstract PrimitiveArray getDIBytes();

    public abstract void setDIBytes(PrimitiveArray var1);

    public static class PredefinedBitmap
    extends EnumItem {
        public static final PredefinedBitmap BTNCORNERS = new PredefinedBitmap(32758);
        public static final PredefinedBitmap BTSIZE = new PredefinedBitmap(32761);
        public static final PredefinedBitmap CHECK = new PredefinedBitmap(32760);
        public static final PredefinedBitmap CHECKBOXES = new PredefinedBitmap(32759);
        public static final PredefinedBitmap CLOSE = new PredefinedBitmap(32754);
        public static final PredefinedBitmap COMBO = new PredefinedBitmap(32738);
        public static final PredefinedBitmap DNARROW = new PredefinedBitmap(32752);
        public static final PredefinedBitmap DNARROWD = new PredefinedBitmap(32742);
        public static final PredefinedBitmap DNARROWI = new PredefinedBitmap(32736);
        public static final PredefinedBitmap LFARROW = new PredefinedBitmap(32750);
        public static final PredefinedBitmap LFARROWD = new PredefinedBitmap(32740);
        public static final PredefinedBitmap LFARROWI = new PredefinedBitmap(32734);
        public static final PredefinedBitmap MNARROW = new PredefinedBitmap(32739);
        public static final PredefinedBitmap REDUCE = new PredefinedBitmap(32749);
        public static final PredefinedBitmap REDUCED = new PredefinedBitmap(32746);
        public static final PredefinedBitmap RESTORE = new PredefinedBitmap(32747);
        public static final PredefinedBitmap RESTORED = new PredefinedBitmap(32744);
        public static final PredefinedBitmap RGARROW = new PredefinedBitmap(32751);
        public static final PredefinedBitmap RGARROWD = new PredefinedBitmap(32741);
        public static final PredefinedBitmap RGARROWI = new PredefinedBitmap(32735);
        public static final PredefinedBitmap SIZE = new PredefinedBitmap(32766);
        public static final PredefinedBitmap UPARROW = new PredefinedBitmap(32753);
        public static final PredefinedBitmap UPARROWD = new PredefinedBitmap(32743);
        public static final PredefinedBitmap UPARROWI = new PredefinedBitmap(32737);
        public static final PredefinedBitmap ZOOM = new PredefinedBitmap(32748);
        public static final PredefinedBitmap ZOOMD = new PredefinedBitmap(32745);

        private PredefinedBitmap(int n2) {
            super(n2);
        }
    }

    public static class Compression
    extends EnumItem {
        public static final Compression RGB = new Compression(0);
        public static final Compression RLE8 = new Compression(1);
        public static final Compression RLE4 = new Compression(2);
        public static final Compression BITFIELDS = new Compression(3);
        public static final Compression JPEG = new Compression(4);
        public static final Compression PNG = new Compression(5);

        protected Compression(int n2) {
            super(n2);
        }
    }
}

