/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.Int64;
import com.jniwrapper.IntegerParameter;
import java.math.BigInteger;

public class UInt64
extends Int64 {
    public static final BigInteger MAX_UINT64 = new BigInteger("18446744073709551615");
    private static final BigInteger a = MAX_UINT64.add(BigInteger.ONE);

    public UInt64() {
        super(0L);
    }

    public UInt64(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("The value is less than zero");
        }
        this.setValue(l2);
    }

    public UInt64(IntegerParameter integerParameter) {
        this(integerParameter.getValue());
    }

    public UInt64(BigInteger bigInteger) {
        this.setValue(bigInteger);
    }

    public void setValue(BigInteger bigInteger) {
        if (bigInteger.compareTo(MAX_UINT64) > 0) {
            throw new IllegalArgumentException("The value " + bigInteger.toString() + " is bigger than maximum allowed value " + MAX_UINT64.toString());
        }
        if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("The value is less than zero");
        }
        this.setValue(UInt64.a(bigInteger));
    }

    public long getValue() {
        return super.getValue();
    }

    public BigInteger toBigInteger() {
        return UInt64.a(this.getValue());
    }

    private static BigInteger a(long l2) {
        BigInteger bigInteger = BigInteger.valueOf(l2);
        if (l2 < 0L) {
            BigInteger bigInteger2 = a.add(bigInteger);
            return bigInteger2;
        }
        return bigInteger;
    }

    private static long a(BigInteger bigInteger) {
        if (bigInteger.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            BigInteger bigInteger2 = a.subtract(bigInteger);
            return -bigInteger2.longValue();
        }
        return bigInteger.longValue();
    }
}

