/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.tiff;

import com.asprise.util.tiff.F;
import com.asprise.util.tiff.TIFFReader;
import com.asprise.util.tiff.aE;
import com.asprise.util.tiff.av;
import com.asprise.util.tiff.t;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.ImageIcon;

public class TIFFWriter {
    public static final int TIFF_COMPRESSION_NONE = 1;
    public static final int TIFF_COMPRESSION_PACKBITS = 32773;
    public static final int TIFF_COMPRESSION_GROUP3_1D = 2;
    public static final int TIFF_COMPRESSION_GROUP3_2D = 3;
    public static final int TIFF_COMPRESSION_GROUP4 = 4;
    public static final int TIFF_COMPRESSION_DEFLATE = 32946;
    public static final int TIFF_CONVERSION_TO_BLACK_WHITE = 1;
    public static final int TIFF_CONVERSION_TO_GRAY = 2;
    public static final int TIFF_CONVERSION_NONE = 0;
    public static boolean reverseColorDuringConversion;
    public static int preferredResolution;
    private static final int[] a;
    private static final int[] b;

    static {
        TIFFReader.a();
        reverseColorDuringConversion = false;
        preferredResolution = 0;
        a = new int[]{32946, 2, 3, 4, 1, 32773};
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        b = nArray;
    }

    public static void createTIFFFromImages(BufferedImage[] bufferedImageArray, File file) throws IOException {
        TIFFWriter.createTIFFFromImages(bufferedImageArray, 1, 4, file);
    }

    public static void createTIFFFromImages(BufferedImage[] bufferedImageArray, int n2, int n3, File file) throws IOException {
        Object object;
        Object object2;
        if ((n3 == 2 || n3 == 3 || n3 == 4) && n2 != 1) {
            throw new IllegalArgumentException("You have specified a compression that only applicable to black-white images. Please specify TIFF_CONVERSION_BLACK_WHITE as the conversion method.");
        }
        if (bufferedImageArray == null || bufferedImageArray.length == 0) {
            throw new IllegalArgumentException("No input images.");
        }
        boolean bl = false;
        int n4 = 0;
        while (n4 < b.length) {
            if (b[n4] == n2) {
                bl = true;
                break;
            }
            ++n4;
        }
        if (!bl) {
            throw new IllegalArgumentException("Invalid conversion.");
        }
        bl = false;
        n4 = 0;
        while (n4 < a.length) {
            if (a[n4] == n3) {
                bl = true;
                break;
            }
            ++n4;
        }
        if (!bl) {
            throw new IllegalArgumentException("Invalid compression.");
        }
        n4 = 0;
        while (n4 < bufferedImageArray.length) {
            object2 = bufferedImageArray[n4];
            object = ((BufferedImage)object2).createGraphics();
            ((Graphics)object).setColor(Color.red);
            ((Graphics)object).setFont(new Font("Arial", 1, 24));
            ((Graphics2D)object).drawString("*UNLICENSED VERSION FOR EVALUATION PURPOSE ONLY, ASPRISE WATERMARKS HAVE BEEN INSERTED*. ", 100, 100);
            ++n4;
        }
        if (n2 != 0) {
            n4 = 0;
            while (n4 < bufferedImageArray.length) {
                if (n2 == 1) {
                    bufferedImageArray[n4] = TIFFWriter.a(bufferedImageArray[n4], reverseColorDuringConversion);
                } else if (n2 == 2) {
                    bufferedImageArray[n4] = TIFFWriter.a(bufferedImageArray[n4]);
                }
                ++n4;
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        object2 = new F();
        ((F)object2).a(n3);
        if (preferredResolution > 0) {
            object = new av[]{new av(282, 5, 1, new long[][]{{preferredResolution, 1L}, new long[2]}), new av(283, 5, 1, new long[][]{{preferredResolution, 1L}, new long[2]})};
            ((F)object2).a((av[])object);
        }
        object = aE.a("TIFF", fileOutputStream, (t)object2);
        Vector<BufferedImage> vector = new Vector<BufferedImage>();
        int n5 = 1;
        while (n5 < bufferedImageArray.length) {
            vector.add(bufferedImageArray[n5]);
            ++n5;
        }
        ((F)object2).a(vector.iterator());
        object.a(bufferedImageArray[0]);
        ((OutputStream)fileOutputStream).close();
    }

    private static BufferedImage a(BufferedImage bufferedImage, boolean bl) {
        byte[] byArray = new byte[2];
        byArray[0] = -1;
        byte[] byArray2 = byArray;
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray2, byArray2, byArray2);
        WritableRaster writableRaster = indexColorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(indexColorModel, writableRaster, false, null);
        int n2 = 0;
        while (n2 < bufferedImage.getWidth()) {
            int n3 = 0;
            while (n3 < bufferedImage.getHeight()) {
                bufferedImage2.setRGB(n2, n3, bufferedImage.getRGB(n2, n3));
                ++n3;
            }
            ++n2;
        }
        return bufferedImage2;
    }

    private static BufferedImage a(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        bufferedImage2.createGraphics().drawImage((Image)bufferedImage, 0, 0, null);
        return bufferedImage2;
    }

    public static BufferedImage getBufferedImageFromImage(Image image) {
        if (image == null) {
            return null;
        }
        Canvas canvas = new Canvas();
        new ImageIcon(image);
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "Usage: java com.asprise.util.tiff.TIFFWriter [tiff file to be created] [conversion option, set -1 to use default] [compression option, set -1 to use default] [path of image1] [path of image2] ...";
        if (stringArray.length < 4) {
            throw new IllegalArgumentException(string);
        }
        File file = new File(stringArray[0]);
        int n2 = -1;
        int n3 = -1;
        try {
            n2 = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(String.valueOf(string) + "\nInvalid image conversion option (" + stringArray[1] + "). if you are not sure, put -1 here.");
        }
        try {
            n3 = Integer.parseInt(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(String.valueOf(string) + "\nInvalid TIFF compression option (" + stringArray[2] + "). if you are not sure, put -1 here.");
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[stringArray.length - 3];
        int n4 = 3;
        while (n4 < stringArray.length) {
            bufferedImageArray[n4 - 3] = TIFFWriter.getBufferedImageFromImage(Toolkit.getDefaultToolkit().createImage(stringArray[n4]));
            ++n4;
        }
        if (n2 == -1) {
            n2 = 1;
        }
        if (n3 == -1) {
            n3 = 4;
        }
        TIFFWriter.createTIFFFromImages(bufferedImageArray, n2, n3, file);
    }
}

