/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.ForeignKeyDirection;
import net.sf.hibernate.type.Type;

public class ManyToOneType
extends EntityType {
    private Type getReferencedType(Mapping mapping) throws MappingException {
        if (this.uniqueKeyPropertyName == null) {
            return mapping.getIdentifierType(this.getAssociatedClass());
        }
        return mapping.getPropertyType(this.getAssociatedClass(), this.uniqueKeyPropertyName);
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.getReferencedType(mapping).getColumnSpan(mapping);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return this.getReferencedType(mapping).sqlTypes(mapping);
    }

    public ManyToOneType(Class persistentClass) {
        this(persistentClass, null);
    }

    public ManyToOneType(Class persistentClass, String uniqueKeyPropertyName) {
        super(persistentClass, uniqueKeyPropertyName);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeSet(st, this.getIdentifier(value, session), index, session);
    }

    public boolean isOneToOne() {
        return false;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT;
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Serializable id = (Serializable)this.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeGet(rs, names, session, owner);
        if (id != null) {
            session.scheduleBatchLoad(this.getAssociatedClass(), id);
        }
        return id;
    }

    protected Object resolveIdentifier(Serializable id, SessionImplementor session) throws HibernateException {
        return session.internalLoad(this.getAssociatedClass(), id);
    }

    public boolean usePrimaryKeyAsForeignKey() {
        return false;
    }

    public boolean isModified(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return current != null;
        }
        return this.getIdentifierOrUniqueKeyType(session.getFactory()).isModified(old, this.getIdentifier(current, session), session);
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = session.getEntityIdentifierIfNotUnsaved(value);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedClass().getName());
        }
        return this.getIdentifierType(session).disassemble(id, session);
    }

    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = (Serializable)this.getIdentifierType(session).assemble(oid, session, owner);
        if (id == null) {
            return null;
        }
        return this.resolveIdentifier(id, session);
    }
}

