/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.transaction;

import java.sql.SQLException;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.TransactionException;
import net.sf.hibernate.engine.SessionImplementor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCTransaction
implements Transaction {
    private SessionImplementor session;
    private boolean toggleAutoCommit;
    private boolean rolledBack;
    private boolean committed;
    private boolean begun;
    private boolean commitFailed;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$transaction$JDBCTransaction == null ? (class$net$sf$hibernate$transaction$JDBCTransaction = JDBCTransaction.class$("net.sf.hibernate.transaction.JDBCTransaction")) : class$net$sf$hibernate$transaction$JDBCTransaction));
    static /* synthetic */ Class class$net$sf$hibernate$transaction$JDBCTransaction;

    public JDBCTransaction(SessionImplementor session) throws HibernateException {
        this.session = session;
    }

    public void begin() throws HibernateException {
        log.debug((Object)"begin");
        try {
            this.toggleAutoCommit = this.session.connection().getAutoCommit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("current autocommit status:" + this.toggleAutoCommit));
            }
            if (this.toggleAutoCommit) {
                log.debug((Object)"disabling autocommit");
                this.session.connection().setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Begin failed", (Throwable)e);
            throw new TransactionException("Begin failed with SQL exception: ", e);
        }
        this.begun = true;
    }

    public void commit() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        if (this.session.getFlushMode() != FlushMode.NEVER) {
            this.session.flush();
        }
        try {
            this.session.connection().commit();
            this.committed = true;
            this.session.afterTransactionCompletion(true);
        }
        catch (SQLException e) {
            log.error((Object)"Commit failed", (Throwable)e);
            this.session.afterTransactionCompletion(false);
            this.commitFailed = true;
            throw new TransactionException("Commit failed with SQL exception: ", e);
        }
        finally {
            this.toggleAutoCommit();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        if (!this.commitFailed) {
            try {
                this.session.connection().rollback();
                this.rolledBack = true;
            }
            catch (SQLException e) {
                log.error((Object)"Rollback failed", (Throwable)e);
                throw new TransactionException("Rollback failed with SQL exception: ", e);
            }
            finally {
                this.session.afterTransactionCompletion(false);
                this.toggleAutoCommit();
            }
        }
    }

    private void toggleAutoCommit() {
        try {
            if (this.toggleAutoCommit) {
                log.debug((Object)"re-enabling autocommit");
                this.session.connection().setAutoCommit(true);
            }
        }
        catch (Exception sqle) {
            log.error((Object)"Could not toggle autocommit", (Throwable)sqle);
        }
    }

    public boolean wasRolledBack() {
        return this.rolledBack;
    }

    public boolean wasCommitted() {
        return this.committed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

