/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.type.LiteralType;
import org.apache.commons.collections.SequencedHashMap;

public class Insert {
    private Dialect dialect;
    private String tableName;
    private Map columns = new SequencedHashMap();

    public Insert(Dialect dialect) {
        this.dialect = dialect;
    }

    public Insert addColumn(String columnName) {
        return this.addColumn(columnName, "?");
    }

    public Insert addColumns(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumn(columnNames[i]);
        }
        return this;
    }

    public Insert addColumn(String columnName, String value) {
        this.columns.put(columnName, value);
        return this;
    }

    public Insert addColumn(String columnName, Object value, LiteralType type) throws Exception {
        return this.addColumn(columnName, type.objectToSQLString(value));
    }

    public Insert addIdentityColumn(String columnName) {
        String value = this.dialect.getIdentityInsertString();
        if (value != null) {
            this.addColumn(columnName, value);
        }
        return this;
    }

    public Insert setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String toStatementString() {
        StringBuffer buf = new StringBuffer(this.columns.size() * 15 + this.tableName.length() + 10);
        buf.append("insert into ").append(this.tableName);
        if (this.columns.size() == 0) {
            buf.append(' ').append(this.dialect.getNoColumnsInsertString());
        } else {
            buf.append(" (");
            Iterator<Object> iter = this.columns.keySet().iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(") values (");
            iter = this.columns.values().iterator();
            while (iter.hasNext()) {
                buf.append(iter.next());
                if (!iter.hasNext()) continue;
                buf.append(", ");
            }
            buf.append(')');
        }
        return buf.toString();
    }
}

