/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.odmg;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.Session;
import net.sf.hibernate.odmg.Database;
import net.sf.hibernate.odmg.Implementation;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;

public class Transaction
implements org.odmg.Transaction {
    private final Database database;
    private final Session session;
    private net.sf.hibernate.Transaction tx;

    public Transaction(org.odmg.Database database) throws ODMGException {
        this.database = (Database)database;
        try {
            this.session = this.database.getSessionFactory().openSession();
        }
        catch (HibernateException he) {
            throw new ODMGException(he.getMessage());
        }
        this.database.associateThread(this);
    }

    public Transaction() throws ODMGException {
        this(Implementation.getInstance().currentDatabase());
    }

    public Session getSession() {
        return this.session;
    }

    public void join() {
        this.database.associateThread(this);
    }

    public void leave() {
        this.database.disassociateThread();
    }

    public void begin() {
        try {
            this.tx = this.session.beginTransaction();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public boolean isOpen() {
        return this.tx != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() {
        this.database.disassociateThread();
        try {
            try {
                if (this.tx != null) {
                    this.tx.commit();
                }
            }
            catch (HibernateException he) {
                throw new ODMGRuntimeException(he.getMessage());
            }
            Object var3_1 = null;
            this.tx = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.tx = null;
            try {
                this.session.close();
                throw throwable;
            }
            catch (HibernateException he) {
                throw new ODMGRuntimeException(he.getMessage());
            }
        }
        try {}
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
        this.session.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void abort() {
        this.database.disassociateThread();
        try {
            try {
                if (this.tx != null) {
                    this.tx.rollback();
                }
            }
            catch (HibernateException he) {
                throw new ODMGRuntimeException(he.getMessage());
            }
            Object var3_1 = null;
            this.tx = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            this.tx = null;
            try {
                this.session.close();
                throw throwable;
            }
            catch (HibernateException he) {
                throw new ODMGRuntimeException(he.getMessage());
            }
        }
        try {}
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
        this.session.close();
    }

    public void checkpoint() {
        try {
            this.tx.commit();
            this.tx = this.session.beginTransaction();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public void lock(Object obj, int lockMode) throws LockNotGrantedException {
        try {
            if (lockMode == 1) {
                this.session.lock(obj, LockMode.READ);
            } else {
                this.session.lock(obj, LockMode.UPGRADE);
            }
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public boolean tryLock(Object obj, int lockMode) {
        throw new UnsupportedOperationException("try using lock()");
    }
}

