/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import net.sf.hibernate.MappingException;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.Collection;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.PrimaryKey;
import net.sf.hibernate.mapping.SimpleValue;

public abstract class IndexedCollection
extends Collection {
    public static final String DEFAULT_INDEX_COLUMN_NAME = "idx";
    private SimpleValue index;

    public IndexedCollection(PersistentClass owner) {
        super(owner);
    }

    public SimpleValue getIndex() {
        return this.index;
    }

    public void setIndex(SimpleValue index) {
        this.index = index;
    }

    public final boolean isIndexed() {
        return true;
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey pk = new PrimaryKey();
            pk.addColumns(this.getKey().getColumnIterator());
            pk.addColumns(this.getIndex().getColumnIterator());
            this.getCollectionTable().setPrimaryKey(pk);
        }
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIndex().isValid(mapping)) {
            throw new MappingException("collection index mapping has wrong number of columns: " + this.getRole() + " type: " + this.getIndex().getType().getName());
        }
    }
}

