/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.jmx;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.LazyInitializationException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.UUIDHexGenerator;
import net.sf.hibernate.impl.SessionFactoryObjectFactory;
import net.sf.hibernate.jmx.HibernateService;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionFactoryStub
implements SessionFactory {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$jmx$SessionFactoryStub == null ? (class$net$sf$hibernate$jmx$SessionFactoryStub = SessionFactoryStub.class$("net.sf.hibernate.jmx.SessionFactoryStub")) : class$net$sf$hibernate$jmx$SessionFactoryStub));
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private transient SessionFactory impl;
    private transient HibernateService service;
    private String uuid;
    private String name;
    static /* synthetic */ Class class$net$sf$hibernate$jmx$SessionFactoryStub;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryObjectFactory;

    SessionFactoryStub(HibernateService service) {
        this.service = service;
        this.name = service.getJndiName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, service.getProperties());
    }

    public Session openSession() throws HibernateException {
        return this.getImpl().openSession();
    }

    public Session openSession(Connection conn) {
        return this.getImpl().openSession(conn);
    }

    public Databinder openDatabinder() throws HibernateException {
        return this.getImpl().openDatabinder();
    }

    private synchronized SessionFactory getImpl() {
        if (this.impl == null) {
            try {
                this.impl = this.service.buildSessionFactory();
            }
            catch (Exception e) {
                throw new LazyInitializationException(e);
            }
        }
        return this.impl;
    }

    private Object readResolve() throws ObjectStreamException {
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a stub SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved stub SessionFactory by name");
        } else {
            log.debug((Object)"resolved stub SessionFactory by uid");
        }
        return result;
    }

    public Reference getReference() throws NamingException {
        return new Reference((class$net$sf$hibernate$jmx$SessionFactoryStub == null ? (class$net$sf$hibernate$jmx$SessionFactoryStub = SessionFactoryStub.class$("net.sf.hibernate.jmx.SessionFactoryStub")) : class$net$sf$hibernate$jmx$SessionFactoryStub).getName(), new StringRefAddr("uuid", this.uuid), (class$net$sf$hibernate$impl$SessionFactoryObjectFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryObjectFactory = SessionFactoryStub.class$("net.sf.hibernate.impl.SessionFactoryObjectFactory")) : class$net$sf$hibernate$impl$SessionFactoryObjectFactory).getName(), null);
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getImpl().getClassMetadata(persistentClass);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getImpl().getCollectionMetadata(roleName);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.getImpl().openSession(connection, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        return this.getImpl().openSession(interceptor);
    }

    public Map getAllClassMetadata() throws HibernateException {
        return this.getImpl().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return this.getImpl().getAllCollectionMetadata();
    }

    public void close() throws HibernateException {
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        this.getImpl().evict(persistentClass, id);
    }

    public void evict(Class persistentClass) throws HibernateException {
        this.getImpl().evict(persistentClass);
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        this.getImpl().evictCollection(roleName, id);
    }

    public void evictCollection(String roleName) throws HibernateException {
        this.getImpl().evictCollection(roleName);
    }

    public void evictQueries() throws HibernateException {
        this.getImpl().evictQueries();
    }

    public void evictQueries(String cacheRegion) throws HibernateException {
        this.getImpl().evictQueries(cacheRegion);
    }

    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.getImpl().getSQLExceptionConverter();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

