/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.binding;

import groovy.lang.MissingMethodException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.codehaus.groovy.binding.AbstractFullBinding;
import org.codehaus.groovy.binding.PropertyBinding;
import org.codehaus.groovy.binding.SourceBinding;
import org.codehaus.groovy.binding.TargetBinding;
import org.codehaus.groovy.runtime.InvokerHelper;

public class MutualPropertyBinding
extends AbstractFullBinding
implements PropertyChangeListener {
    boolean bound;
    Object sourceBoundBean;
    String sourceBoundProperty;
    boolean sourceBoundToProperty;
    Object targetBoundBean;
    String targetBoundProperty;
    boolean targetBoundToProperty;

    MutualPropertyBinding(SourceBinding source, TargetBinding target) {
        this.setSourceBinding(source);
        this.setTargetBinding(target);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.targetBoundBean) {
            if (this.sourceBoundToProperty || event.getPropertyName().equals(this.sourceBoundProperty)) {
                this.update();
            }
        } else if (event.getSource() == this.sourceBoundBean && (this.targetBoundToProperty || event.getPropertyName().equals(this.targetBoundProperty))) {
            this.reverseUpdate();
        }
    }

    public void setSourceBinding(SourceBinding sourceBinding) {
        if (sourceBinding instanceof PropertyBinding) {
            if (this.bound && this.sourceBoundBean != null) {
                MutualPropertyBinding.unbindProperty(this.sourceBoundBean, this.sourceBoundToProperty ? this.sourceBoundProperty : (String)null, this);
                this.sourceBoundBean = null;
                this.sourceBoundProperty = null;
            }
            super.setSourceBinding(sourceBinding);
            if (this.bound) {
                this.sourceBoundBean = ((PropertyBinding)sourceBinding).bean;
                this.sourceBoundProperty = MutualPropertyBinding.bindProperty(this.sourceBoundBean, ((PropertyBinding)sourceBinding).propertyName, this);
                this.sourceBoundToProperty = this.sourceBoundProperty != null;
            }
        } else {
            throw new RuntimeException("Only PropertyBindings can be set in a Mutual Property Binding");
        }
    }

    public void setTargetBinding(TargetBinding targetBinding) {
        if (targetBinding instanceof PropertyBinding) {
            if (this.bound && this.targetBoundBean != null) {
                MutualPropertyBinding.unbindProperty(this.targetBoundBean, this.targetBoundToProperty ? this.targetBoundProperty : (String)null, this);
                this.targetBoundBean = null;
                this.targetBoundProperty = null;
            }
            super.setTargetBinding(targetBinding);
            if (this.bound) {
                this.targetBoundBean = ((PropertyBinding)targetBinding).bean;
                this.targetBoundProperty = MutualPropertyBinding.bindProperty(this.targetBoundBean, ((PropertyBinding)targetBinding).propertyName, this);
                this.targetBoundToProperty = this.targetBoundProperty != null;
            }
        } else if (targetBinding != null) {
            throw new RuntimeException("Only PropertyBindings can be set in a Mutual Property Binding");
        }
    }

    public static String bindProperty(Object bean, String propertyName, PropertyChangeListener that) {
        try {
            InvokerHelper.invokeMethodSafe(bean, "addPropertyChangeListener", new Object[]{propertyName, that});
            return propertyName;
        }
        catch (MissingMethodException mme) {
            try {
                InvokerHelper.invokeMethodSafe(bean, "addPropertyChangeListener", new Object[]{that});
                return null;
            }
            catch (MissingMethodException mme2) {
                throw new RuntimeException("Properties in beans of type " + bean.getClass().getName() + " are not observable in any capacity (no PropertyChangeListener support).");
            }
        }
    }

    public static void unbindProperty(Object bean, String propertyName, PropertyChangeListener that) {
        if (propertyName != null) {
            try {
                InvokerHelper.invokeMethodSafe(bean, "removePropertyChangeListener", new Object[]{propertyName, that});
            }
            catch (MissingMethodException mme) {}
        } else {
            try {
                InvokerHelper.invokeMethodSafe(bean, "removePropertyChangeListener", new Object[]{that});
            }
            catch (MissingMethodException missingMethodException) {
                // empty catch block
            }
        }
    }

    public void bind() {
        if (!this.bound) {
            this.bound = true;
            if (this.sourceBinding != null) {
                this.sourceBoundBean = ((PropertyBinding)this.sourceBinding).bean;
                this.sourceBoundProperty = MutualPropertyBinding.bindProperty(this.sourceBoundBean, ((PropertyBinding)this.sourceBinding).propertyName, this);
                boolean bl = this.sourceBoundToProperty = this.sourceBoundProperty != null;
            }
            if (this.targetBinding != null) {
                this.targetBoundBean = ((PropertyBinding)this.targetBinding).bean;
                this.targetBoundProperty = MutualPropertyBinding.bindProperty(this.targetBoundBean, ((PropertyBinding)this.targetBinding).propertyName, this);
                this.targetBoundToProperty = this.targetBoundProperty != null;
            }
        }
    }

    public void unbind() {
        if (this.bound) {
            if (this.sourceBoundBean != null) {
                MutualPropertyBinding.unbindProperty(this.sourceBoundBean, this.sourceBoundToProperty ? this.sourceBoundProperty : (String)null, this);
                this.sourceBoundBean = null;
                this.sourceBoundProperty = null;
            }
            if (this.targetBoundBean != null) {
                MutualPropertyBinding.unbindProperty(this.targetBoundBean, this.targetBoundToProperty ? this.targetBoundProperty : (String)null, this);
                this.targetBoundBean = null;
                this.targetBoundProperty = null;
            }
            this.bound = false;
        }
    }

    public void rebind() {
        if (this.bound) {
            this.unbind();
            this.bind();
        }
    }
}

