/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.SequenceList;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sequencers {
    private Sequencers() {
        throw new UnsupportedOperationException();
    }

    public static SequenceList.Sequencer<Date> monthSequencer() {
        return new MonthSequencer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MonthSequencer
    implements SequenceList.Sequencer<Date> {
        private final Calendar cal = Calendar.getInstance();

        private MonthSequencer() {
        }

        @Override
        public Date previous(Date date) {
            if (date == null) {
                throw new IllegalArgumentException("date may not be null");
            }
            this.cal.setTime(date);
            if (GlazedListsImpl.isMonthStart(this.cal)) {
                this.cal.add(2, -1);
            }
            return GlazedListsImpl.getMonthStart(this.cal);
        }

        @Override
        public Date next(Date date) {
            if (date == null) {
                throw new IllegalArgumentException("date may not be null");
            }
            this.cal.setTime(date);
            this.cal.add(2, 1);
            return GlazedListsImpl.getMonthStart(this.cal);
        }
    }
}

