/*
 * Decompiled with CFR 0.152.
 */
package de.goto3d.freeimage4j;

import de.goto3d.freeimage4j.FreeImage;
import de.goto3d.freeimage4j.FreeImageException;
import de.goto3d.freeimage4j.FreeImageRuntimeException;
import de.goto3d.freeimage4j.FreeImageWrapper;
import de.goto3d.freeimage4j.SWIGTYPE_p_FIMULTIBITMAP;
import java.io.File;

public final class FreeImageMultiBitmap {
    private final SWIGTYPE_p_FIMULTIBITMAP fiMultiBitmap;
    private boolean isClosed;

    public FreeImageMultiBitmap(File file, boolean createNew) throws FreeImageException {
        this(file, FreeImage.getFileFormatsByExtension(file)[0], createNew);
    }

    public FreeImageMultiBitmap(File file, int format, boolean createNew) throws FreeImageException {
        if (format != 1 && format != 25 && format != 18) {
            throw new IllegalArgumentException("Free image type \"" + format + "\" does not support multiple pages");
        }
        SWIGTYPE_p_FIMULTIBITMAP fiMultiBitmap = FreeImageWrapper.FreeImage_OpenMultiBitmap(format, file.getAbsolutePath(), createNew, false, false, 0);
        if (fiMultiBitmap == null) {
            throw new FreeImageException("The bitmap \"" + file.getAbsolutePath() + "\" could not be created!");
        }
        this.fiMultiBitmap = fiMultiBitmap;
    }

    public final void close() {
        if (this.isClosed) {
            return;
        }
        FreeImageWrapper.FreeImage_CloseMultiBitmap(this.fiMultiBitmap, 0);
        this.isClosed = true;
    }

    public final void finalize() {
        this.close();
    }

    private void checkState() {
        if (this.isClosed) {
            throw new FreeImageRuntimeException("Bitmap has been closed");
        }
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this.getPageCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
    }

    public final int getPageCount() {
        this.checkState();
        return FreeImageWrapper.FreeImage_GetPageCount(this.fiMultiBitmap);
    }

    public final void appendImage(FreeImage image) {
        this.checkState();
        FreeImageWrapper.FreeImage_AppendPage(this.fiMultiBitmap, image.fiBitmap);
    }

    public final void insertImage(FreeImage image, int index) throws FreeImageException {
        this.checkState();
        this.checkBounds(index);
        FreeImageWrapper.FreeImage_InsertPage(this.fiMultiBitmap, index, image.fiBitmap);
    }

    public final void delete(int index) {
        this.checkState();
        this.checkBounds(index);
        FreeImageWrapper.FreeImage_DeletePage(this.fiMultiBitmap, index);
    }

    public final boolean moveImage(int srcIndex, int dstIndex) {
        this.checkState();
        this.checkBounds(srcIndex);
        this.checkBounds(dstIndex);
        return FreeImageWrapper.FreeImage_MovePage(this.fiMultiBitmap, dstIndex, srcIndex);
    }
}

