/*
 * Decompiled with CFR 0.152.
 */
package de.goto3d.freeimage4j;

import de.goto3d.freeimage4j.FreeImageCleanup;
import de.goto3d.freeimage4j.FreeImageException;
import de.goto3d.freeimage4j.FreeImageRuntimeException;
import de.goto3d.freeimage4j.FreeImageWrapper;
import de.goto3d.freeimage4j.SWIGTYPE_p_FIBITMAP;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public final class FreeImage {
    private static final Map<String, int[]> FILE_EXTENSION_MAP;
    private static final FreeImageCleanup CLEANUP_THREAD;
    private final int width;
    private final int height;
    private final int pitch;
    private final int bpp;
    protected final ByteBuffer byteBuffer;
    protected final SWIGTYPE_p_FIBITMAP fiBitmap;

    public FreeImage(File file) throws FreeImageException {
        this(FreeImage.load(file));
    }

    public FreeImage(int width, int height, int bpp, int redMask, int greenMask, int blueMask) {
        this(FreeImage.allocate(width, height, bpp, redMask, greenMask, blueMask));
    }

    private FreeImage(SWIGTYPE_p_FIBITMAP fiBitmap) {
        this.width = FreeImageWrapper.FreeImage_GetWidth(fiBitmap);
        this.pitch = FreeImageWrapper.FreeImage_GetPitch(fiBitmap);
        this.height = FreeImageWrapper.FreeImage_GetHeight(fiBitmap);
        this.bpp = FreeImageWrapper.FreeImage_GetBPP(fiBitmap);
        this.fiBitmap = fiBitmap;
        this.byteBuffer = FreeImageWrapper.FreeImage_GetBits(fiBitmap);
        CLEANUP_THREAD.register(this);
    }

    public static String getVersion() {
        return FreeImageWrapper.FreeImage_GetVersion();
    }

    public static String getCopyrightMessage() {
        return FreeImageWrapper.FreeImage_GetCopyrightMessage();
    }

    public static boolean isLittleEndian() {
        return FreeImageWrapper.FreeImage_IsLittleEndian();
    }

    public static int getFileType(File file) {
        return FreeImageWrapper.FreeImage_GetFileType(file.getAbsolutePath(), 0);
    }

    private static SWIGTYPE_p_FIBITMAP load(File file) throws FreeImageException {
        String fileName = file.getAbsolutePath();
        int fileType = FreeImage.getFileType(file);
        if (fileType == -1) {
            throw new FreeImageException("Unsupported file type, file =  " + fileName);
        }
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_Load(fileType, fileName, 0);
        if (fiBitmap == null) {
            throw new FreeImageException("Loading of file \"" + fileName + "\" failed.");
        }
        return fiBitmap;
    }

    private static SWIGTYPE_p_FIBITMAP allocate(int width, int height, int bpp, int redMask, int greenMask, int blueMask) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_Allocate(width, height, bpp, redMask, greenMask, blueMask);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("Allocation of image failed.");
        }
        return fiBitmap;
    }

    public static FreeImage convertFromRawBits(ByteBuffer buffer, int width, int height, int pitch, int bpp, int redMask, int greenMask, int blueMask, boolean topDown) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertFromRawBits(buffer, width, height, pitch, bpp, redMask, greenMask, blueMask, topDown);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("convertFromRawBits failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final void convertToRawBits(ByteBuffer buffer, int pitch, int bpp, int redMask, int greenMask, int blueMask, boolean topDown) {
        FreeImageWrapper.FreeImage_ConvertToRawBits(buffer, this.fiBitmap, pitch, bpp, redMask, greenMask, blueMask, topDown);
    }

    public static int[] getFileFormatsByExtension(File file) throws FreeImageException {
        String name = file.getName();
        int idx = name.lastIndexOf(46);
        if (idx == -1) {
            throw new FreeImageException("File does not have an extension: \"" + file.getAbsolutePath() + "\"");
        }
        String ext = name.substring(idx + 1).toLowerCase();
        int[] formats = FILE_EXTENSION_MAP.get(ext);
        if (formats == null) {
            throw new FreeImageException("File format is not supported: \"" + file.getAbsolutePath() + "\"");
        }
        return formats;
    }

    public final ByteBuffer getPixelBuffer() {
        return this.byteBuffer;
    }

    public final void save(File file) throws FreeImageException {
        this.save(file, FreeImage.getFileFormatsByExtension(file)[0]);
    }

    public final void save(File file, int format) throws FreeImageException {
        String fileName = file.getAbsolutePath();
        if (!FreeImageWrapper.FreeImage_Save(format, this.fiBitmap, fileName, 0)) {
            throw new FreeImageException("Could not save file: " + fileName);
        }
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getPitch() {
        return this.pitch;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getBitsPerPixel() {
        return this.bpp;
    }

    public final boolean isTransparent() {
        return FreeImageWrapper.FreeImage_IsTransparent(this.fiBitmap);
    }

    public final boolean adjustGamma(double gamma) {
        return FreeImageWrapper.FreeImage_AdjustGamma(this.fiBitmap, gamma);
    }

    public final boolean adjustBrightness(double percentage) {
        return FreeImageWrapper.FreeImage_AdjustBrightness(this.fiBitmap, percentage);
    }

    public final boolean adjustContrast(double percentage) {
        return FreeImageWrapper.FreeImage_AdjustContrast(this.fiBitmap, percentage);
    }

    public final boolean invert() {
        return FreeImageWrapper.FreeImage_Invert(this.fiBitmap);
    }

    public final FreeImage rotateClassic(double angle) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_RotateClassic(this.fiBitmap, angle);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("Classic Rotation failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage rotateEx(double angle, double xShift, double yShift, double xOrigin, double yOrigin, boolean useMask) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_RotateEx(this.fiBitmap, angle, xShift, yShift, xOrigin, yOrigin, useMask);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("Extended Rotation failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final boolean flipHorizontal() {
        return FreeImageWrapper.FreeImage_FlipHorizontal(this.fiBitmap);
    }

    public final boolean flipVertical() {
        return FreeImageWrapper.FreeImage_FlipVertical(this.fiBitmap);
    }

    public final FreeImage rescale(int dstWidth, int dstHeight, int filter) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_Rescale(this.fiBitmap, dstWidth, dstHeight, filter);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("rescale failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage makeThumbnail(int size, boolean convertHDR) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_MakeThumbnail(this.fiBitmap, size, convertHDR);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("make thumbnail failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage convertTo4Bits() {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertTo4Bits(this.fiBitmap);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("conversion failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage convertTo8Bits() {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertTo8Bits(this.fiBitmap);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("conversion failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage convertToGreyscale() {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertToGreyscale(this.fiBitmap);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("conversion failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage convertTo16Bits555() {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertTo16Bits555(this.fiBitmap);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("conversion failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage convertTo16Bits565() {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertTo16Bits565(this.fiBitmap);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("conversion failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage convertTo24Bits() {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertTo24Bits(this.fiBitmap);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("conversion failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage convertTo32Bits() {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ConvertTo32Bits(this.fiBitmap);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("conversion failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage colorQuantize(int quantizeAlgorithm) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_ColorQuantize(this.fiBitmap, quantizeAlgorithm);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("colorQuantize failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage threshold(int threshold) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_Threshold(this.fiBitmap, (short)threshold);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("threshold failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final FreeImage dither(int ditherAlgorithm) {
        SWIGTYPE_p_FIBITMAP fiBitmap = FreeImageWrapper.FreeImage_Dither(this.fiBitmap, ditherAlgorithm);
        if (fiBitmap == null) {
            throw new FreeImageRuntimeException("dither failed");
        }
        return new FreeImage(fiBitmap);
    }

    public final int getPixelColor(int x, int y) {
        return FreeImageWrapper.GetPixelColor(this.fiBitmap, x, y);
    }

    private void checkPaletteIndex(int idx) {
        int bpp = this.bpp;
        if (bpp > 8) {
            throw new NullPointerException("This image does not have a palette");
        }
        if (idx < 0 || idx >= 1 << bpp) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
    }

    public final int getPaletteColor(int idx) {
        this.checkPaletteIndex(idx);
        return FreeImageWrapper.GetPaletteColor(this.fiBitmap, idx);
    }

    public final void setPaletteColor(int idx, int color) {
        this.checkPaletteIndex(idx);
        FreeImageWrapper.SetPaletteColor(this.fiBitmap, idx, color);
    }

    public final short getPixelIndex(int x, int y) {
        return FreeImageWrapper.GetPixelIndex(this.fiBitmap, x, y);
    }

    public final void setPixelColor(int x, int y, int color) {
        FreeImageWrapper.SetPixelColor(this.fiBitmap, x, y, color);
    }

    public final void setPixelIndex(int x, int y, short index) {
        FreeImageWrapper.SetPixelIndex(this.fiBitmap, x, y, index);
    }

    static {
        System.loadLibrary("freeimage4j");
        FreeImageWrapper.FreeImage_Initialise(false);
        FILE_EXTENSION_MAP = new HashMap<String, int[]>();
        FILE_EXTENSION_MAP.put("bmp", new int[]{0});
        FILE_EXTENSION_MAP.put("cut", new int[]{21});
        FILE_EXTENSION_MAP.put("dds", new int[]{24});
        FILE_EXTENSION_MAP.put("exr", new int[]{29});
        FILE_EXTENSION_MAP.put("g3", new int[]{27});
        FILE_EXTENSION_MAP.put("gif", new int[]{25});
        FILE_EXTENSION_MAP.put("hdr", new int[]{26});
        FILE_EXTENSION_MAP.put("ico", new int[]{1});
        FILE_EXTENSION_MAP.put("iff", new int[]{5});
        FILE_EXTENSION_MAP.put("ilbm", new int[]{5});
        FILE_EXTENSION_MAP.put("lbm", new int[]{5});
        FILE_EXTENSION_MAP.put("j2c", new int[]{30});
        FILE_EXTENSION_MAP.put("j2k", new int[]{30});
        FILE_EXTENSION_MAP.put("jng", new int[]{3});
        FILE_EXTENSION_MAP.put("jp2", new int[]{31});
        FILE_EXTENSION_MAP.put("jif", new int[]{2});
        FILE_EXTENSION_MAP.put("jpe", new int[]{2});
        FILE_EXTENSION_MAP.put("jpeg", new int[]{2});
        FILE_EXTENSION_MAP.put("jpg", new int[]{2});
        FILE_EXTENSION_MAP.put("koa", new int[]{4});
        FILE_EXTENSION_MAP.put("mng", new int[]{6});
        FILE_EXTENSION_MAP.put("pbm", new int[]{8, 7});
        FILE_EXTENSION_MAP.put("pcd", new int[]{9});
        FILE_EXTENSION_MAP.put("pcx", new int[]{10});
        FILE_EXTENSION_MAP.put("pgm", new int[]{12, 11});
        FILE_EXTENSION_MAP.put("png", new int[]{13});
        FILE_EXTENSION_MAP.put("ppm", new int[]{15, 14});
        FILE_EXTENSION_MAP.put("psd", new int[]{20});
        FILE_EXTENSION_MAP.put("ras", new int[]{16});
        FILE_EXTENSION_MAP.put("sgi", new int[]{28});
        FILE_EXTENSION_MAP.put("tga", new int[]{17});
        FILE_EXTENSION_MAP.put("targa", new int[]{17});
        FILE_EXTENSION_MAP.put("tif", new int[]{18});
        FILE_EXTENSION_MAP.put("tiff", new int[]{18});
        FILE_EXTENSION_MAP.put("wap", new int[]{19});
        FILE_EXTENSION_MAP.put("wbm", new int[]{19});
        FILE_EXTENSION_MAP.put("wbmp", new int[]{19});
        FILE_EXTENSION_MAP.put("xbm", new int[]{22});
        FILE_EXTENSION_MAP.put("xpm", new int[]{23});
        CLEANUP_THREAD = new FreeImageCleanup();
    }
}

