/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.array.ByteArray;
import electric.util.encoding.XMLEncodings;
import electric.util.io.FastStringWriter;
import electric.util.io.Streams;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Node;
import electric.xml.NodeWriter;
import electric.xml.Parent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class Child
extends Node
implements Cloneable {
    protected Parent parent;

    protected Child() {
    }

    public Child(Parent parent) {
        parent.addChild(this);
    }

    public String toString() {
        return this.toString(this.getStartIndent());
    }

    public String toString(int n) {
        FastStringWriter fastStringWriter = new FastStringWriter(256);
        NodeWriter nodeWriter = new NodeWriter(fastStringWriter, n, false);
        try {
            nodeWriter.write(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fastStringWriter.toString();
    }

    public abstract Object clone();

    public void setParent(Parent parent) {
        this.parent = parent;
    }

    public Parent getParent() {
        return this.parent;
    }

    public void replaceWith(Child child) {
        this.parent.replaceChild(this, child);
    }

    public Child getNextSiblingChild() {
        return (Child)this.getNextSiblingNode();
    }

    public Child setNextSiblingChild(Child child) {
        child.setParent(this.parent);
        this.setNextSiblingNode(child);
        return this;
    }

    public Child getPreviousSiblingChild() {
        return (Child)this.getPreviousSiblingNode();
    }

    public Child setPreviousSiblingChild(Child child) {
        child.setParent(this.parent);
        this.setPreviousSiblingNode(child);
        return this;
    }

    public Document getDocument() {
        return this.parent == null ? null : this.parent.getDocument();
    }

    public Element getRoot() {
        return this.parent == null ? null : this.parent.getRoot();
    }

    private int getStartIndent() {
        Document document = this.getDocument();
        return document == null || document.isStripped() ? 0 : -1;
    }

    public void write(Writer writer) throws IOException {
        NodeWriter nodeWriter = new NodeWriter(writer, this.getStartIndent(), false);
        nodeWriter.write(this);
    }

    public void write(File file) throws IOException {
        Writer writer = Streams.getWriter(file, this.getDocument().getEncoding());
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        try {
            this.write(bufferedWriter);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((Writer)bufferedWriter).close();
            throw throwable;
        }
        ((Writer)bufferedWriter).close();
    }

    public void write(OutputStream outputStream) throws IOException {
        Writer writer = Streams.getWriter(outputStream, this.getDocument().getEncoding());
        this.write(writer);
        writer.flush();
    }

    public ByteArray getByteArray() throws UnsupportedEncodingException {
        return this.getByteArray(false);
    }

    public ByteArray getByteArray(boolean bl) throws UnsupportedEncodingException {
        return this.getByteArray(new NodeWriter(null, -1, bl));
    }

    public ByteArray getByteArray(NodeWriter nodeWriter) throws UnsupportedEncodingException {
        FastStringWriter fastStringWriter = new FastStringWriter(256);
        nodeWriter.setWriter(fastStringWriter);
        try {
            nodeWriter.write(this);
            nodeWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ByteArray(this.getBytes(fastStringWriter.toString()));
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        Document document = this.getDocument();
        if (document == null) {
            return string.getBytes("UTF8");
        }
        String string2 = XMLEncodings.getJavaEncoding(document.getEncoding());
        return string.getBytes(string2);
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        return this.getByteArray().getBytes();
    }

    public byte[] getBytes(boolean bl) throws UnsupportedEncodingException {
        return this.getByteArray(bl).getBytes();
    }

    public org.w3c.dom.Node cloneNode(boolean bl) {
        return (org.w3c.dom.Node)this.clone();
    }

    public org.w3c.dom.Document getOwnerDocument() {
        return this.getDocument();
    }

    public org.w3c.dom.Node getParentNode() {
        return this.parent;
    }
}

