/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.util.array.ArrayUtil;
import electric.util.named.IQNamed;
import electric.xml.Element;
import electric.xml.NamespaceException;
import electric.xml.Node;
import electric.xml.NodeReader;
import electric.xml.NodeWriter;
import electric.xml.Text;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

public final class Attribute
extends Node
implements IQNamed,
Attr {
    private Element element;
    private String prefix;
    String namespace;
    String name;
    String value;
    boolean isNamespace;
    boolean isId;
    private boolean raw;

    public Attribute() {
    }

    public Attribute(String string, String string2) {
        this.name = string;
        this.value = string2;
        this.initialize();
    }

    public Attribute(String string, String string2, String string3) {
        this.prefix = string;
        this.name = string2;
        this.value = string3;
        this.initialize();
    }

    public Attribute(Attribute attribute) {
        this.prefix = attribute.prefix;
        this.namespace = attribute.namespace;
        this.name = attribute.name;
        this.value = attribute.value;
        this.isNamespace = attribute.isNamespace;
        this.isId = attribute.isId;
        this.raw = attribute.raw;
    }

    Attribute(String string, String string2, boolean bl) {
        this.isNamespace = bl;
        this.value = string2;
        if (bl) {
            if (string.equals("")) {
                this.name = "xmlns";
            } else {
                this.prefix = "xmlns";
                this.name = string;
            }
        } else {
            this.name = string;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return attribute.name.equals(this.name) && attribute.value.equals(this.value) && ArrayUtil.equals(attribute.namespace, this.namespace);
    }

    public int hashCode() {
        return this.name.hashCode() + this.value.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.prefix != null) {
            stringBuffer.append(this.prefix).append(':');
        }
        stringBuffer.append(this.name).append("='").append(this.value).append('\'');
        return stringBuffer.toString();
    }

    public Object clone() {
        return new Attribute(this);
    }

    public String getLocalName() {
        return this.name;
    }

    public String getName() {
        return this.prefix == null ? this.name : this.prefix + ":" + this.name;
    }

    public String getQName() {
        return this.namespace == null ? this.name : this.namespace + ":" + this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean isNamespace() {
        return this.isNamespace;
    }

    public boolean hasName(String string, String string2) {
        if (!this.name.equals(string2)) {
            return false;
        }
        if (string == null) {
            return true;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.namespace.equals(string);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void initialize(String string, String string2, String string3) {
        this.prefix = string;
        this.name = string2;
        this.value = string3;
        this.initialize();
    }

    public void initialize() {
        if ("xmlns".equals(this.name) || "xmlns".equals(this.prefix)) {
            this.isNamespace = true;
            this.namespace = "http://www.w3.org/2000/xmlns/";
        } else if ("id".equals(this.name) || "Id".equals(this.name)) {
            this.isId = true;
        }
    }

    void resolve(Element element) throws NamespaceException {
        this.element = element;
        if (this.prefix != null && !this.isNamespace && !this.prefix.equals("xml")) {
            this.namespace = element.getNamespace(this.prefix);
            if (this.namespace == null) {
                throw new NamespaceException("could not find namespace with prefix " + this.prefix);
            }
        }
    }

    public Element getElement() {
        return this.element;
    }

    public void setRaw(boolean bl) {
        this.raw = bl;
    }

    public boolean getRaw() {
        return this.raw;
    }

    public void read(NodeReader nodeReader) throws IOException, NamespaceException {
        this.name = nodeReader.readToken();
        if (nodeReader.peek() == 58) {
            this.prefix = this.name;
            nodeReader.read();
            this.name = nodeReader.readToken();
        }
        nodeReader.readChar(61);
        nodeReader.skipWhitespace();
        int n = nodeReader.read();
        if (n == 34) {
            this.value = nodeReader.readToPattern("\"", 66);
        } else if (n == 39) {
            this.value = nodeReader.readToPattern("'", 66);
        } else {
            throw new IOException("missing quote at start of attribute");
        }
        this.initialize();
    }

    public void write(NodeWriter nodeWriter) throws IOException {
        if (this.prefix != null) {
            nodeWriter.write(this.prefix);
            nodeWriter.write(':');
        }
        nodeWriter.write(this.name);
        nodeWriter.write("='");
        if (this.value == null) {
            nodeWriter.write("null");
        } else if (this.raw) {
            nodeWriter.write(this.value);
        } else {
            Text.writeWithSubstitution(nodeWriter, this.value);
        }
        nodeWriter.write('\'');
    }

    public short getNodeType() {
        return 2;
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() {
        return this.value;
    }

    public void setNodeValue(String string) {
        this.value = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public org.w3c.dom.Node cloneNode(boolean bl) {
        return new Attribute(this);
    }

    public Document getOwnerDocument() {
        return this.element != null ? this.element.getOwnerDocument() : null;
    }

    public String getNamespaceURI() {
        return this.namespace;
    }

    public org.w3c.dom.Element getOwnerElement() {
        return this.element;
    }

    public boolean getSpecified() {
        return true;
    }
}

