/*
 * Decompiled with CFR 0.152.
 */
package electric.util.string;

import electric.util.encoding.XMLEncodings;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;

public final class Strings {
    public static String getString(String string, String[] stringArray, int n) {
        if (n >= stringArray.length) {
            throw new IllegalArgumentException("missing argument to -" + string);
        }
        return stringArray[n];
    }

    public static String asJavaName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (n == 0 && Character.isJavaIdentifierStart(c) || Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getJavaPackage(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : null;
    }

    public static String getLocalJavaName(String string) {
        return Strings.tail(string, '.');
    }

    public static boolean isUTF16(byte[] byArray) {
        if (byArray.length < 2) {
            return false;
        }
        return byArray[0] == -1 && byArray[1] == -2 || byArray[0] == -2 && byArray[1] == -1;
    }

    public static boolean isUTF8(String string) {
        return string == null || string.equalsIgnoreCase("UTF-8") || string.equalsIgnoreCase("UTF8");
    }

    public static String toString(byte[] byArray) throws UnsupportedEncodingException {
        byte[] byArray2 = byArray;
        if (byArray.length > 100) {
            byArray2 = new byte[100];
            System.arraycopy(byArray, 0, byArray2, 0, 100);
        }
        return new String(byArray, XMLEncodings.getJavaEncoding(byArray2));
    }

    public static String extension(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        return n2 > n ? string.substring(n2 + 1) : null;
    }

    public static String tail(String string, char c) {
        int n = string.lastIndexOf(c);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String head(String string, char c) {
        int n = string.lastIndexOf(c);
        return n == -1 ? string : string.substring(0, n);
    }

    public static String splice(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string.endsWith("/") && string2.startsWith("/")) {
            return string + string2.substring(1);
        }
        if (string.endsWith("/") || string2.startsWith("/")) {
            return string + string2;
        }
        if (string.length() > 0) {
            return string + "/" + string2;
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        if (string.indexOf(string2.charAt(0)) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = string.indexOf(string2, n)) == -1) {
                stringBuffer.append(string.substring(n, string.length()));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n, n2)).append(string3);
            n = n2 + string2.length();
        }
    }

    public static String stripChar(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] != c) {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(Object object) {
        int n = Array.getLength(object);
        if (n == 0) {
            return "()";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("( ");
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(Array.get(object, n2));
            ++n2;
        }
        return stringBuffer.append(" )").toString();
    }

    public static String getURN(String string) {
        int n = string.lastIndexOf("/");
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getEndpoint(String string) {
        int n = string.lastIndexOf("/");
        return n == -1 ? "" : string.substring(0, n);
    }

    public static String toFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isLetterOrDigit(c) || c == '.') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append('_');
                stringBuffer.append(Integer.toString(c));
                stringBuffer.append('_');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String fromFilename(String string) {
        int n = string.indexOf(95);
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf(95, n + 1);
        char c = (char)Integer.parseInt(string.substring(n + 1, n2));
        return string.substring(0, n) + c + Strings.fromFilename(string.substring(n2 + 1));
    }

    public static void substitute(String[][] stringArray, String[][] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n][1];
            if (string.length() > 0 && string.charAt(0) == '$') {
                String string2 = string.substring(1, string.length());
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray2[n2][0].equals(string2)) {
                        stringArray[n][1] = stringArray2[n2][1];
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public static String getCapitalized(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static boolean getBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("1")) {
            return true;
        }
        if (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("0")) {
            return false;
        }
        return bl;
    }

    public static String stripQuotes(String string) {
        if (string != null && string.length() > 2 && string.startsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

