/*
 * Decompiled with CFR 0.152.
 */
package electric.util.lex;

import electric.util.io.FastStringReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public final class Lex {
    public static final int SKIP_WS = 1;
    public static final int CONSUME = 2;
    public static final int INCLUDE = 4;
    public static final int EOF_OK = 8;
    public static final int QUOTES = 16;
    public static final int STRIP = 32;
    public static final int HTML = 64;
    public static final int COMMENTS = 128;
    static final int BUFFER_SIZE = 60;
    static final Hashtable substitutions = new Hashtable();
    private Reader reader;
    private String defaultDelimiters;
    private int defaultFlags;
    private int index = 0;
    private boolean eol;
    private int lineNumber = 1;
    private int charNumber = 0;
    private StringBuffer comment;
    private int[] window = null;

    public Lex(String string) {
        this(new FastStringReader(string));
    }

    public Lex(Reader reader) {
        this(reader, "", 1);
    }

    public Lex(String string, String string2, int n) {
        this(new FastStringReader(string), string2, n);
    }

    public Lex(Reader reader, String string, int n) {
        this.reader = reader;
        this.defaultDelimiters = string;
        this.defaultFlags = n;
        this.setWindow(60);
    }

    public String getComment() {
        return this.comment == null ? "" : this.comment.toString();
    }

    public void clearComment() {
        this.comment = null;
    }

    public String readToPattern(String string, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            this.skipWhitespace(n);
        }
        char c = string.charAt(0);
        int n2 = string.length();
        while (true) {
            int n3;
            if ((n3 = this.peek()) == -1) {
                if ((n & 8) == 0) {
                    throw new IOException("unexpected EOF while searching for '" + string + "'");
                }
                this.read();
                return stringBuffer.toString();
            }
            if (n3 == c) {
                if (n2 == 1) {
                    if ((n & 4) != 0) {
                        stringBuffer.append((char)n3);
                    }
                    if ((n & 2) != 0) {
                        this.read();
                    }
                    return stringBuffer.toString();
                }
                int[] nArray = new int[n2];
                this.peek(nArray);
                boolean bl = true;
                int n4 = 1;
                while (n4 < n2) {
                    if (nArray[n4] != string.charAt(n4)) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    if ((n & 2) != 0) {
                        int n5 = 0;
                        while (n5 < n2) {
                            this.read();
                            ++n5;
                        }
                    }
                    if ((n & 4) != 0) {
                        int n6 = 0;
                        while (n6 < n2) {
                            stringBuffer.append((char)nArray[n6]);
                            ++n6;
                        }
                    }
                    return stringBuffer.toString();
                }
            }
            if (n3 == 38 && (n & 0x40) != 0) {
                this.readHTML(stringBuffer);
                continue;
            }
            if ((n3 == 39 || n3 == 34) && (n & 0x10) != 0) {
                this.readQuoted(stringBuffer, n3, n);
                continue;
            }
            stringBuffer.append((char)this.read());
        }
    }

    public String readToDelimiter(String string, int n) throws IOException {
        if ((n & 1) != 0) {
            this.skipWhitespace(n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            if ((n2 = this.peek()) == -1) {
                if (stringBuffer.length() <= 0) {
                    throw new IOException("unexpected EOF");
                }
                this.read();
                return stringBuffer.toString();
            }
            if (string.indexOf(n2) != -1) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append((char)this.read());
                }
                return stringBuffer.toString();
            }
            if (Character.isWhitespace((char)n2)) {
                return stringBuffer.toString();
            }
            if (n2 == 38 && (n & 0x40) != 0) {
                this.readHTML(stringBuffer);
                continue;
            }
            if ((n2 == 39 || n2 == 34) && (n & 0x10) != 0) {
                this.readQuoted(stringBuffer, n2, n);
                continue;
            }
            stringBuffer.append((char)this.read());
        }
    }

    public String readToDelimiter(String string) throws IOException {
        return this.readToDelimiter(string, this.defaultFlags);
    }

    public String readToken() throws IOException {
        return this.readToDelimiter(this.defaultDelimiters, this.defaultFlags);
    }

    public void readToken(String string) throws IOException {
        String string2 = this.readToken();
        if (!string.equals(string2)) {
            throw new IOException("expected \"" + string + "\", got \"" + string2 + "\"");
        }
    }

    public void readHTML(StringBuffer stringBuffer) throws IOException {
        this.read();
        String string = this.readTo(59);
        try {
            if (string.startsWith("#x")) {
                stringBuffer.append((char)Integer.parseInt(string.substring(2), 16));
            } else if (string.startsWith("#")) {
                stringBuffer.append((char)Integer.parseInt(string.substring(1)));
            } else {
                String string2 = (String)substitutions.get(string);
                if (string2 != null) {
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string);
                    stringBuffer.append(';');
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("number format exception while parsing &" + string + ";");
        }
    }

    private void readQuoted(StringBuffer stringBuffer, int n, int n2) throws IOException {
        int n3 = this.read();
        if ((n2 & 0x20) == 0) {
            stringBuffer.append((char)n3);
        }
        while ((n3 = this.read()) != -1) {
            if (n3 == n) {
                if ((n2 & 0x20) != 0) break;
                stringBuffer.append((char)n3);
                break;
            }
            stringBuffer.append((char)n3);
        }
    }

    public int readChar() throws IOException {
        this.skipWhitespace();
        int n = this.read();
        if (n == -1) {
            throw new IOException("unexpected EOF");
        }
        return n;
    }

    public void readChar(int n) throws IOException {
        int n2 = this.readChar();
        if (n2 != n) {
            throw new IOException("expected '" + (char)n + "', got '" + (char)n2 + "'");
        }
    }

    public String readTo(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            if ((n2 = this.read()) == -1) {
                throw new IOException("could not find " + n);
            }
            if (n2 == n) break;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public StringBuffer readWhitespace() throws IOException {
        return this.readWhitespace(this.defaultFlags);
    }

    public StringBuffer readWhitespace(int n) throws IOException {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = null;
            while (true) {
                this.reader.mark(2);
                int n2 = this.reader.read();
                if (Character.isWhitespace((char)n2)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    this.reader.reset();
                    stringBuffer.append((char)this.read());
                    continue;
                }
                if (n2 != 47 || (n & 0x80) == 0) break block4;
                n2 = this.reader.read();
                this.reader.reset();
                if (n2 == 47) {
                    this.readOneLineComment();
                    continue;
                }
                if (n2 != 42) break;
                this.readMultiLineComment();
            }
            return stringBuffer;
        }
        this.reader.reset();
        return stringBuffer;
    }

    public void skipWhitespace() throws IOException {
        this.skipWhitespace(this.defaultFlags);
    }

    public void skipWhitespace(int n) throws IOException {
        block3: {
            while (true) {
                this.reader.mark(2);
                int n2 = this.reader.read();
                if (Character.isWhitespace((char)n2)) {
                    this.reader.reset();
                    this.read();
                    continue;
                }
                if (n2 != 47 || (n & 0x80) == 0) break block3;
                n2 = this.reader.read();
                this.reader.reset();
                if (n2 == 47) {
                    this.readOneLineComment();
                    continue;
                }
                if (n2 != 42) break;
                this.readMultiLineComment();
            }
            return;
        }
        this.reader.reset();
    }

    private void readOneLineComment() throws IOException {
        if (this.comment == null) {
            this.comment = new StringBuffer();
        }
        this.comment.append(this.readToPattern("\n", 10));
    }

    private void readMultiLineComment() throws IOException {
        int n;
        if (this.comment == null) {
            this.comment = new StringBuffer();
        }
        do {
            if ((n = this.read()) == -1) {
                throw new IOException("missing */ on comment");
            }
            this.comment.append((char)n);
        } while (n != 42 || this.peek() != 47);
        n = this.read();
        this.comment.append((char)n);
    }

    public String peekString(int n) throws IOException {
        int[] nArray = new int[n];
        this.peek(nArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] == -1) break;
            stringBuffer.append((char)nArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public boolean peekString(String string) throws IOException {
        return string.equals(this.peekString(string.length()));
    }

    public void peek(int[] nArray) throws IOException {
        this.reader.mark(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.reader.read();
            ++n;
        }
        this.reader.reset();
    }

    public int peek() throws IOException {
        this.reader.mark(1);
        int n = this.reader.read();
        this.reader.reset();
        return n;
    }

    public void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public boolean eof() throws IOException {
        this.skipWhitespace();
        return this.peek() == -1;
    }

    public void skip(int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            this.read();
            ++n2;
        }
    }

    public String getLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("line ").append(this.lineNumber).append(", char ").append(this.charNumber);
        if (this.window == null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(": ...");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        int n2 = this.index;
        while (n++ < this.charNumber) {
            if (n2-- == 0) {
                n2 = 59;
            }
            if (this.window[n2] == 10 || n2 == this.index) break;
            stringBuffer2.append((char)this.window[n2]);
        }
        return stringBuffer.append((Object)stringBuffer2.reverse()).toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int peekRead() throws IOException {
        return this.reader.read();
    }

    public int read() throws IOException {
        if (this.eol) {
            ++this.lineNumber;
            this.charNumber = 0;
        }
        int n = this.reader.read();
        ++this.charNumber;
        boolean bl = this.eol = n == 10;
        if (this.window != null) {
            this.window[this.index] = n;
            if (++this.index == this.window.length) {
                this.index = 0;
            }
        }
        return n;
    }

    public void setWindow(int n) {
        this.window = new int[n];
    }

    private static void initSubstitutions() {
        substitutions.put("apos", "'");
        substitutions.put("lt", "<");
        substitutions.put("gt", ">");
        substitutions.put("quot", "\"");
        substitutions.put("amp", "&");
    }

    static {
        Lex.initSubstitutions();
    }
}

