/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import java.io.IOException;
import java.io.Reader;

public final class FastBufferedReader
extends Reader {
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private static int defaultCharBufferSize = 8192;
    private Reader reader;
    private char[] buffer;
    private int nChars;
    private int nextChar;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;

    public FastBufferedReader(Reader reader, int n) {
        super((Object)reader);
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.reader = reader;
        this.buffer = new char[n];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public FastBufferedReader(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.nextChar - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else {
                if (this.readAheadLimit <= this.buffer.length) {
                    System.arraycopy(this.buffer, this.markedChar, this.buffer, 0, n);
                    this.markedChar = 0;
                    n2 = n;
                } else {
                    char[] cArray = new char[this.readAheadLimit];
                    System.arraycopy(this.buffer, this.markedChar, cArray, 0, n);
                    this.buffer = cArray;
                    this.markedChar = 0;
                    n2 = n;
                }
                this.nextChar = this.nChars = n;
            }
        }
        while ((n = this.reader.read(this.buffer, n2, this.buffer.length - n2)) == 0) {
        }
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    public int read() throws IOException {
        while (true) {
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            if (!this.skipLF) break;
            this.skipLF = false;
            if (this.buffer[this.nextChar] != '\n') break;
            ++this.nextChar;
        }
        return this.buffer[this.nextChar++];
    }

    private int read1(char[] cArray, int n, int n2) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (n2 >= this.buffer.length && this.markedChar <= -1 && !this.skipLF) {
                return this.reader.read(cArray, n, n2);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.buffer[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n3 = Math.min(n2, this.nChars - this.nextChar);
        System.arraycopy(this.buffer, this.nextChar, cArray, n, n3);
        this.nextChar += n3;
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public int read(char[] var1_1, int var2_2, int var3_3) throws IOException {
        if (var3_3 == 0) {
            return 0;
        }
        var4_4 = this.read1(var1_1, var2_2, var3_3);
        if (var4_4 > 0) ** GOTO lbl8
        return var4_4;
        while ((var5_5 = this.read1(var1_1, var2_2 + var4_4, var3_3 - var4_4)) > 0) {
            var4_4 += var5_5;
lbl8:
            // 2 sources

            if (var4_4 < var3_3 && this.reader.ready()) continue;
        }
        return var4_4;
    }

    public long skip(long l) throws IOException {
        long l2 = l;
        while (l2 > 0L) {
            long l3;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) break;
            if (this.skipLF) {
                this.skipLF = false;
                if (this.buffer[this.nextChar] == '\n') {
                    ++this.nextChar;
                }
            }
            if (l2 <= (l3 = (long)(this.nChars - this.nextChar))) {
                this.nextChar = (int)((long)this.nextChar + l2);
                l2 = 0L;
                break;
            }
            l2 -= l3;
            this.nextChar = this.nChars;
        }
        return l - l2;
    }

    public boolean ready() throws IOException {
        return this.nextChar < this.nChars || this.reader.ready();
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.readAheadLimit = n;
        this.markedChar = this.nextChar;
        this.markedSkipLF = this.skipLF;
    }

    public void reset() throws IOException {
        if (this.markedChar < 0) {
            throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
        }
        this.nextChar = this.markedChar;
        this.skipLF = this.markedSkipLF;
    }

    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.buffer = null;
    }
}

