
import net.java.dev.properties.container.BeanContext
import net.java.dev.properties.container.BeanContainer
import net.java.dev.properties.jdbc.SessionConfiguration
import net.java.dev.properties.jdbc.EntityPersister


startGeneration = {
	persistedClassesOut = new java.io.PrintStream(new java.io.FileOutputStream( "./src/main/resources/persisted-classes.txt" ))
}

endGeneration = {
	persistedClassesOut.close()
}

codeGenerator = { 

	sessionConfiguration = net.model3.guice.DependencyInjector.getInstance(SessionConfiguration)

	entityPersister = null
	virtualManagerDao = false
	if ( clazz != null ) {
		entityPersister = sessionConfiguration.getPersister(clazz)
	}	
	if ( entityPersister == null ) {
		if ( clazz.getAnnotation(net.java.dev.properties.annotations.Table.class) != null ) {
			entityPersister = new EntityPersister(clazz, BeanContainer.get().getContext(clazz), sessionConfiguration)
			virtualManagerDao = true
		} else {
			return
		}
	}
	
	
	
	persistedClassesOut.println(fullClassname)
	
	keySig = ahsCodeGen.getKeySig(entityPersister)
	fetchSig = ahsCodeGen.getFetchSig(entityPersister)
	gettersAndSetters = ahsCodeGen.generateGettersAndSetters(helper)

	imports = """
net.java.dev.properties.container.IPropertyContext
net.java.dev.properties.container.BeanContext
net.java.dev.properties.container.BeanContainer
net.model3.guice.DependencyInjector
java.util.List
"""	

	if ( virtualManagerDao ) {

		imports += """
com.ahsrcm.corp.cdl.CDLEntity
net.model3.guice.DependencyInjector
com.ahsrcm.core.virtualmanager.VirtualManagerDAO
"""		
		daoMethods = """
public static ${classname} fetchByPk(CDLEntity cdl, Object...args) {
	return DependencyInjector.getInstance(VirtualManagerDAO.class).fetchByPk(cdl, ${classname}.class, args);
}

public static net.java.dev.properties.jdbc.Query<${classname}> select(CDLEntity cdl, String whereClause, Object...args ) {
	return DependencyInjector.getInstance(VirtualManagerDAO.class).select(cdl, ${classname}.class, whereClause, args);
}

public static List<${classname}> selectAll(CDLEntity cdl) {
	return select(cdl, "").getResults();
}

public static ${classname} fetch(CDLEntity cdl, String whereClause, Object...args ) {
	return select(cdl, whereClause, args).getResult();
}

public static void insert(CDLEntity cdl, ${classname} bean) {
	DependencyInjector.getInstance(VirtualManagerDAO.class).insert(cdl, bean);
}

public static void update(CDLEntity cdl, ${classname} bean) {
	DependencyInjector.getInstance(VirtualManagerDAO.class).update(cdl, bean);
}

public static void delete(CDLEntity cdl, ${classname} bean) {
	DependencyInjector.getInstance(VirtualManagerDAO.class).delete(cdl, bean);
}
	
"""
	} else {

		imports += """
net.model3.collections.ListX
com.ahsrcm.scanning.dao.ScanningDao
"""		
	
		daoMethods = 
"""public static ${classname} fetchByPk( ${keySig} ) {
	return CurrentSession.get().fetchByPK(${classname}.class, ${fetchSig} );
}

public static net.java.dev.properties.jdbc.Query<${classname}> select( String whereClause, Object...args ) {
	return CurrentSession.get().select(${classname}.class, whereClause, args );
}

public static List<${classname}> selectAll() {
	return DependencyInjector.getInstance(ScanningDao.class).selectAll(${classname}.class);
}

public static ${classname} fetch( String whereClause, Object...args ) {
	return ListX.getFirst(select(whereClause, args));
}
"""
	}

	
	props = new StringBuilder();
	beanContext = BeanContainer.get().getContext(clazz)
	for ( propContext in beanContext.getProperties() ) {
		props.append( """public static final IPropertyContext \$${propContext.getName()} = \$BeanContext.getProperty(\"${propContext.getName()}\");\n""" )
	}


	code = """

public static final BeanContext \$BeanContext = (BeanContext) BeanContainer.get().getContext(${classname}.class);

${props}

${gettersAndSetters}

public static final ${classname} Meta = new ${classname}();

${daoMethods}
"""

}
