#include <Misc.au3>
_Singleton("ahs-snapit-tm")

HotKeySet("^+S", "DoResize")
HotKeySet("^+A", "SaveWindowPositions")
HotKeySet("^+C", "ClearSavedWindowPosition")

Global $NextClientAccessOnLeft = True
Global $clientAccessRegExp = "[REGEXPCLASS:PCSWS]"
Global $batchViewerRegExp = "[CLASS:SunAwtFrame]"

Global $configFile = @HomeDrive & @HomePath & "\ahs\snapit.ini"

#MsgBox(0, $configFile, $configFile)

Func SaveWindowPositions()
	SavePosition("client-access", WinGetPos($clientAccessRegExp))
	SavePosition("batch-viewer", WinGetPos($batchViewerRegExp))
EndFunc

Func SavePosition($section, $pos)
	IniWrite($configFile, $section, "x", $pos[0])
	IniWrite($configFile, $section, "y", $pos[1])
	IniWrite($configFile, $section, "width", $pos[2])
	IniWrite($configFile, $section, "height", $pos[3])
EndFunc

Func ClearSavedWindowPosition()
	FileDelete($configFile)
EndFunc

Func RestoreSavedPosition()
	RestorePosition("client-access", $clientAccessRegExp)
	RestorePosition("batch-viewer", $batchViewerRegExp)
EndFunc

Func RestorePosition($section, $windowLocator)
	$x = IniRead($configFile, $section, "x", "default")
	$y = IniRead($configFile, $section, "y", "default")
	$width = IniRead($configFile, $section, "width", "default")
	$height = IniRead($configFile, $section, "height", "default")
	WinMove($windowLocator, "", $x, $y, $width, $height)
EndFunc

Func DoResize()

	$screenSize = WinGetPos("Program Manager")

	$screenX = $screenSize[0]
	$screenY = $screenSize[1]
	$screenWidth = $screenSize[2]
	$screenHeight = $screenSize[3]
	$halfWidth = $screenWidth/2
	
	If FileExists($configFile) Then
		RestoreSavedPosition()
		
	ElseIf $NextClientAccessOnLeft Then
		
		$NextClientAccessOnLeft = False
		$result = WinMove( $clientAccessRegExp, "", $screenX, $screenY, $halfWidth, $halfWidth * 0.6 )

		$pos = WinGetPos($clientAccessRegExp)

		$viewerX = $pos[0] + $pos[2] 
		$viewerWidth = $screenWidth - $viewerX

		$result = WinMove( $batchViewerRegExp, "", $viewerX, $screenY, $viewerWidth, $screenHeight - 30 ) 
		
	Else
		$NextClientAccessOnLeft = True
		
		$caHeight = $halfWidth * 0.6 

		$result = WinMove( $clientAccessRegExp, "", $screenX+$halfWidth, $screenY, $halfWidth, $caHeight )

		$pos = WinGetPos($clientAccessRegExp)

		$viewerX = $pos[0] + $pos[2] 
		$viewerWidth = $pos[2]
		
		$result = WinMove( $clientAccessRegExp, "", $screenX+($screenWidth-$viewerWidth), $screenY, $viewerWidth, $caHeight )

		$result = WinMove($batchViewerRegExp, "", $screenX, $screenY, $screenWidth-$viewerWidth, $screenHeight - 30 ) 		
		
	EndIf
	
	WinActivate($batchViewerRegExp)
	WinActivate($clientAccessRegExp)

EndFunc

While True
	Sleep(60000)
WEnd
