/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util.guice.server;

import com.ahsrcm.corp.rules.UserRole;
import com.ahsrcm.util.guice.AbstractBootstrapper;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Enumeration;
import java.util.Properties;
import net.model3.collections.PropertiesX;
import net.model3.lang.Function0;
import net.model3.logging.AutoLoggingConfigurator;
import net.model3.logging.Level;
import net.model3.logging.LoggerHelper;
import net.model3.util.ProcessManagerHelper;
import net.model3.util.Versioning;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

@Singleton
public class ServerBootstrapper
extends AbstractBootstrapper {
    @Inject
    AutoLoggingConfigurator _autoLoggingConfigurator;

    public void bootstrap() {
        this._autoLoggingConfigurator.apply((Function0)new Function0<Void>(){

            public Void apply() {
                if (ProcessManagerHelper.isRunningInProcessManager()) {
                    ServerBootstrapper.this._autoLoggingConfigurator.doProcman();
                } else {
                    ServerBootstrapper.this._autoLoggingConfigurator.doEclipe();
                }
                return null;
            }
        });
        this.addNoSelectOnePlusOneFilter();
        this.initDefaultLoggingLevels();
    }

    @Override
    public void postBootstrap() {
        PropertiesX.logProperties((Properties)System.getProperties(), (Level)Level.DEBUG);
        Versioning.logAllVersioningFound((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void configComplete() throws Exception {
        super.configComplete();
        UserRole.selectAll();
    }

    public void addNoSelectOnePlusOneFilter() {
        NoSelectOnePlusOneFilter noSelectOnePlusOneFilter = new NoSelectOnePlusOneFilter();
        Enumeration enumeration = ((Logger)LoggerHelper.getRootLogger().getDelegate()).getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Filter filter;
            Appender appender = (Appender)enumeration.nextElement();
            for (filter = appender.getFilter(); filter != null; filter = filter.getNext()) {
                if (!(filter instanceof NoSelectOnePlusOneFilter)) continue;
                filter = null;
                break;
            }
            if (filter != null) continue;
            appender.addFilter((Filter)noSelectOnePlusOneFilter);
        }
    }

    class NoSelectOnePlusOneFilter
    extends Filter {
        NoSelectOnePlusOneFilter() {
        }

        public int decide(LoggingEvent loggingEvent) {
            String string;
            if (loggingEvent.getLoggerName().startsWith("jdbc.") && (string = (String)loggingEvent.getMessage()).contains("select 1+1")) {
                return -1;
            }
            return 1;
        }
    }
}

