/*
 * Decompiled with CFR 0.152.
 */
package com.ahsrcm.util.guice.client;

import com.ahsrcm.util.CachePurger;
import com.ahsrcm.util.guice.AbstractBootstrapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyEventDispatcher;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.JComponent;
import net.model3.collections.PropertiesX;
import net.model3.lang.Function0;
import net.model3.logging.AutoLoggingConfigurator;
import net.model3.logging.Level;
import net.model3.logging.SimpleLoggingConfigurator;
import net.model3.util.Versioning;

@Singleton
public class ClientBootstrapper
extends AbstractBootstrapper {
    @Inject
    AutoLoggingConfigurator _autoLoggingConfigurator;
    @Inject
    Injector _injector;

    public void bootstrap() {
        this._autoLoggingConfigurator.apply((Function0)new Function0<Void>(){

            public Void apply() {
                ClientBootstrapper.this._autoLoggingConfigurator.doStdFile();
                ClientBootstrapper.this._autoLoggingConfigurator.doEclipe();
                return null;
            }
        });
        this.initDefaultLoggingLevels();
    }

    @Override
    public void postBootstrap() {
        SimpleLoggingConfigurator simpleLoggingConfigurator = new SimpleLoggingConfigurator();
        simpleLoggingConfigurator.overrideSystemErrAndOut();
        simpleLoggingConfigurator.addUncaughtExceptionHandler();
        PropertiesX.logProperties((Properties)System.getProperties(), (Level)Level.DEBUG);
        Versioning.logAllVersioningFound((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void configComplete() throws Exception {
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getID() == 402 && keyEvent.getModifiers() == 0 && keyEvent.getModifiersEx() == 0) {
                    Component component = keyEvent.getComponent();
                    while (true) {
                        JComponent jComponent;
                        KeyEventDispatcher keyEventDispatcher;
                        if (component instanceof JComponent && (keyEventDispatcher = (KeyEventDispatcher)(jComponent = (JComponent)component).getClientProperty("KeyEventDispatcher")) != null) {
                            return keyEventDispatcher.dispatchKeyEvent(keyEvent);
                        }
                        if (component == null) break;
                        component = component.getParent();
                    }
                }
                return false;
            }
        });
        this._scheduler.submit("cache-purger", (Runnable)this._injector.getInstance(CachePurger.class));
    }
}

